  Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt          <  InfoElems Alloc  V   Syntax10.Scn.Fnt  L     StampElems Alloc 10 Feb 95  !    n  "Title": XIn.Mod - Extended In
"Author": Christoph Steindl (CS)
"Abstract": Extended In provides some often needed procedures in order to read parameters (marked viewer,
	focus viewer, scanner for arguments, viewer with selection)
"Keywords": marked viewer, focus frame, arguments
"Version": 1.0
"From":  17.01.95 15:17:52
"Until": 
"Changes": no changes
"Hints": 
Syntax10i.Scn.Fnt  '      StampElems Alloc 10 Feb 95      N           Syntax8i.Scn.Fnt  8  FoldElems New #   Syntax8i.Scn.Fnt         Returns the marked text frame.     8           
    *    g8  #   Syntax8i.Scn.Fnt  w    w   Returns the text frame with the input focus. 
		If needsCaret is TRUE the frame only is returned if it shows the caret. y   8  Syntax8.Scn.Fnt              *    [8  #   Syntax8i.Scn.Fnt         If last command was executed from a menuviewer, 
		TargetFrame returns the menu viewers body, otherwise the FocusFrame(needsCaret).    8           
        s8  #   Syntax8i.Scn.Fnt  k    k   Returns the scanner for the arguments after the command or (^) at the 
		selection (most recent selection). 2   8                   x8  #   Syntax8i.Scn.Fnt  f    f   Returs the scanner for the arguments after the command or (^) at the 
		selection in the command frame 3   8               -    8  #   Syntax8i.Scn.Fnt  %    %   Opens and returns a temporary viewer. 0   8           
        8  #   Syntax8i.Scn.Fnt  ?    ?   Removes the exclamation mark from the menu frame of the viewer.     8               R    8  #   Syntax8i.Scn.Fnt  Z    Z   Like Oberon.GetSelection, additionally it returns the viewer which contains the selection. i   8       	    
  MODULE XIn;		(* Christoph Steindl (CS), 17.01.95 -  *)

IMPORT TextFrames, Texts, Viewers, Oberon, MenuViewers, Display;

	PROCEDURE MarkedFrame* (): TextFrames.Frame;
		VAR v: Viewers.Viewer;
	BEGIN v := Oberon.MarkedViewer();
		IF (v # NIL) & (v IS MenuViewers.Viewer) & (v.dsc.next IS TextFrames.Frame) THEN
			RETURN v.dsc.next(TextFrames.Frame)
		ELSE RETURN NIL
		END
	END MarkedFrame;

	PROCEDURE FocusFrame* (needsCaret: BOOLEAN): TextFrames.Frame;
		VAR v: Viewers.Viewer; f: TextFrames.Frame;
	BEGIN v := Oberon.FocusViewer;
		IF (v # NIL) & (v IS MenuViewers.Viewer) & (v.dsc # NIL) & (v.dsc.next # NIL) & (v.dsc.next IS TextFrames.Frame) THEN
			f := v.dsc.next(TextFrames.Frame);
			IF needsCaret THEN 
				IF f.hasCar THEN RETURN f ELSE RETURN NIL END 
			ELSE RETURN f 
			END
		ELSE RETURN NIL
		END
	END FocusFrame;
	
	PROCEDURE TargetFrame* (needsCaret: BOOLEAN): TextFrames.Frame;
		VAR f: Display.Frame;
	BEGIN
		IF Oberon.Par.vwr.dsc = Oberon.Par.frame THEN f := Oberon.Par.frame.next;
			IF (f # NIL) & (f IS TextFrames.Frame) THEN RETURN f(TextFrames.Frame) ELSE RETURN NIL END
		ELSE RETURN FocusFrame(needsCaret)
		END
	END TargetFrame;

	PROCEDURE GetMainArg* (VAR S: Texts.Scanner);
		VAR text: Texts.Text; beg, end, time: LONGINT;
	BEGIN Texts.Scan(S);
		IF (S.class = Texts.Char) & (S.c = "^") THEN Oberon.GetSelection(text, beg, end, time);
			IF time >= 0 THEN Texts.OpenScanner(S, text, beg); Texts.Scan(S) END
		END;
		IF S.line # 0 THEN S.class := Texts.Inval END
	END GetMainArg;

	PROCEDURE GetArg* (VAR S: Texts.Scanner);
		VAR F: TextFrames.Frame;
	BEGIN Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
		IF (S.class = Texts.Char) & (S.c = "^") THEN F := Oberon.Par.frame(TextFrames.Frame);
			IF F.hasSel THEN Texts.OpenScanner(S, F.text, F.selbeg.pos); Texts.Scan(S); F.time := 0 END
		END
	END GetArg;

	PROCEDURE OpenTempViewer* (t: Texts.Text; VAR v: MenuViewers.Viewer);
		VAR x, y, h: INTEGER;
	BEGIN y := Display.Bottom; x := Display.Width-1; h := Viewers.minH; Viewers.minH := 1;
		v := MenuViewers.New(TextFrames.NewMenu("", ""), TextFrames.NewText(t, 0), TextFrames.menuH, x, y);
		Oberon.Pointer.X := x; Oberon.Pointer.Y := y;
		Viewers.minH := h
	END OpenTempViewer;

	PROCEDURE UnmarkMenu* (V: Viewers.Viewer);
		VAR R: Texts.Reader; T: Texts.Text; ch: CHAR;
	BEGIN T := V.dsc(TextFrames.Frame).text;
		Texts.OpenReader(R, T, T.len - 1); Texts.Read(R, ch);
		IF ch = "!" THEN Texts.Delete(T, T.len - 1, T.len) END
	END UnmarkMenu;

	PROCEDURE GetSelectionViewer* (VAR vwr: Viewers.Viewer; VAR text: Texts.Text; 
		VAR time, beg, end: LONGINT);
		CONST filler = 1; (* state of the filler viewer *)
		VAR selText, t2: Texts.Text; selBeg, selEnd, selTime, beg2, end2, time2: LONGINT;
			left: INTEGER; cur: Viewers.Viewer;
			m: Oberon.SelectionMsg;
	BEGIN
		Oberon.GetSelection(selText, selBeg, selEnd, selTime);
		m.time := -1; m.text := NIL;
		IF selTime >= 0 THEN
			left := 0;
			WHILE left < Display.Width DO	(* for all tracks *)
				cur := Viewers.This(left, 0);
				WHILE cur.state # filler DO	(* for all viewers in the track *)
					cur.handle(cur, m);
					IF (m.time = selTime) & (m.text = selText) & (m.beg = selBeg) & (m.end = selEnd) THEN
						text := selText; time := selTime; beg := selBeg; end := selEnd; vwr := cur;
						RETURN
					END;
					cur := Viewers.Next(cur)
				END;
				left := left + cur.W
			END
		END;
		vwr := NIL; text := NIL; time := -1; beg := 0; end := 0
	END GetSelectionViewer;


END XIn.