  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt       I StampElems Alloc 17 Dec 98         Syntax10b.Scn.Fnt                      &            	                                                  MarkElems Alloc H  K    8  FoldElems New  i   8         r!  2    8   9    8   ^   8       8      8        8       8   ?    8   d    8   3    8         F +    8      8  #   Syntax10.Scn.Fnt  
    
    inside elem  g    8       8             K      +    8   s          
       8             7         8       8             L          8   >    8             M          @    8      8   o      MODULE StaticTextElems; (* CE  *)

IMPORT Texts, TextFrames, TextPrinter, Display, Viewers, Files, Fonts, Elems, GU := GUtils, Input, Oberon;
			 	
CONST
	DUnit = TextFrames.Unit;
	left* = 0; center* = 1; right* = 2;
	MR = 0; MM = 1; ML = 2;

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (Elems.ElemDesc)
		value* : ARRAY 128 OF CHAR;
		x3D*, border*, transparent* : BOOLEAN;
		align* : SHORTINT
	END;
	
PROCEDURE Draw (e : Elem; x, y, color: INTEGER; fnt : Fonts.Font; f : Display.Frame);
VAR h, w, diy : INTEGER;
BEGIN
	h := GU.Unit(e.H, TRUE); w := GU.Unit(e.W, TRUE);
	
	IF ~e.transparent & (GU.device = GU.display) THEN GU.ReplConst(f, 13, x, y, w, h, Display.paint) END;
	IF e.border THEN
		IF e.x3D THEN
			GU.Area(f, 13, 0, x, y, w, h, GU.Unit(1, FALSE), FALSE, TRUE);
		ELSE
			GU.Frame(f, color, x, y, w, h, GU.Unit(1, FALSE), Display.paint)
		END
	END;
	IF h > GU.Unit(fnt.maxY-fnt.minY, FALSE) THEN
		diy := (h DIV 2) - (GU.Unit(fnt.minY + fnt.maxY, FALSE) DIV 2);
		GU.String(f, e.value, x + GU.Unit(2, FALSE), y + diy, w - GU.Unit(4, FALSE), fnt, color, Display.paint, e.align)
	END
END Draw;

PROCEDURE HandleAttrMsg (e : Elem; VAR msg : Elems.AttrMsg);
BEGIN
	Elems.Done := TRUE;
	
	IF msg.id = Elems.get THEN
		IF msg.name = "Value" THEN
			msg.class := Elems.String;
			COPY(e.value, msg.s)
		ELSIF msg.name = "Border" THEN
			msg.class := Elems.Bool;
			msg.b := e.border
		ELSIF msg.name = "3D" THEN
			msg.class := Elems.Bool;
			msg.b := e.x3D
		ELSIF msg.name = "Transparent" THEN
			msg.class := Elems.Bool;
			msg.b := e.transparent
		ELSIF msg.name = "Align" THEN
			msg.class := Elems.String;
			msg.hasProps := TRUE;
			IF e.align = center THEN
				COPY("Center", msg.s)
			ELSIF e.align = right THEN
				COPY("Right", msg.s)
			ELSE
				COPY("Left", msg.s)
			END
		ELSE
			Elems.Handle(e, msg);
		END;
	ELSIF msg.id = Elems.set THEN
		IF msg.name = "Value" THEN
			IF msg.class = Elems.String THEN COPY(msg.s, e.value) END
		ELSIF msg.name = "Border" THEN
			IF msg.class = Elems.Bool THEN e.border := msg.b END
		ELSIF msg.name = "3D" THEN
			IF msg.class = Elems.Bool THEN e.x3D := msg.b END
		ELSIF msg.name = "Transparent" THEN
			IF msg.class = Elems.Bool THEN e.transparent := msg.b END
		ELSIF msg.name = "Align" THEN
			IF msg.class = Elems.Int THEN
				e.align := SHORT(SHORT(msg.i))
			ELSIF msg.class = Elems.String THEN
				IF CAP(msg.s[0]) = "L" THEN
					e.align := left
				ELSIF CAP(msg.s[0]) = "C" THEN
					e.align := center
				ELSIF CAP(msg.s[0]) = "R" THEN
					e.align := right
				END
			END
		ELSE
			Elems.Handle(e, msg)
		END;
	ELSIF msg.id = Elems.enum THEN
		Elems.Handle(e, msg);
		msg.enum("Border", Elems.Bool);
		msg.enum("3D", Elems.Bool); msg.enum("Transparent", Elems.Bool);
		msg.enum("Value", Elems.String); msg.enum("Align", Elems.String);  
	ELSIF (msg.id = Elems.enumProps) & (msg.name = "Align") THEN 
		msg.enum("Left", Elems.String); msg.enum("Center", Elems.String); msg.enum("Right", Elems.String)
	ELSE Elems.Handle(e, msg)
	END
END HandleAttrMsg;

PROCEDURE Track(e : Elem; msg : TextFrames.TrackMsg);
VAR X, Y, w, h : INTEGER; keysum : SET; exec : Elems.ExecMsg; pressed : BOOLEAN;
BEGIN
	keysum := msg.keys;
	REPEAT
		Input.Mouse(msg.keys, X, Y); keysum := keysum + msg.keys;
		Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, X, Y);
	UNTIL msg.keys = {};

	IF (X > msg.X0) & (X < msg.X0 + SHORT(e.W DIV DUnit)) & (Y > msg.Y0) & (Y < msg.Y0 + SHORT(e.H DIV DUnit)) & ~(MR IN keysum) THEN
		exec.e := e; exec.x := msg.X0; exec.y := msg.Y0;
		exec.f := msg.frame; exec.unload := ML IN keysum;
		e.handle(e, exec)
	END
END Track;

PROCEDURE Handle* (e : Texts.Elem; VAR msg : Texts.ElemMsg);
VAR copy: Elem; ch: CHAR; a : INTEGER;
BEGIN
	WITH e : Elem DO
		WITH msg: TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, msg.frame)
			END
		| msg : TextPrinter.PrintMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.printer);
				Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, NIL);
				GU.SetDevice(GU.display)
			END
		| msg : Texts.CopyMsg DO
			IF msg.e = NIL THEN NEW(copy); msg.e := copy ELSE copy := msg.e(Elem) END;
			Elems.CopyElem(e, copy);
			COPY(e.value, copy.value);
			copy.align := e.align; copy.border := e.border; copy.x3D := e.x3D; copy.transparent := e.transparent;
			msg(Texts.CopyMsg).e := copy;
		| msg: Texts.IdentifyMsg DO msg.mod := "StaticTextElems"; msg.proc := "New"
		| msg: Texts.FileMsg DO
			Elems.Handle(e, msg);
			IF msg.id = Texts.load THEN
				Files.Read(msg.r, ch); (* version -> not used *)
				Files.ReadString(msg.r, e.value); Files.ReadInt(msg.r, a); e.align := SHORT(a);
				Files.ReadBool(msg.r, e.border); Files.ReadBool(msg.r, e.x3D);
				Files.ReadBool(msg.r, e.transparent);
			ELSIF msg.id = Texts.store THEN
				Files.Write(msg.r, 0X); (* version *)
				Files.WriteString(msg.r, e.value); Files.WriteInt(msg.r, e.align);
				Files.WriteBool(msg.r, e.border); Files.WriteBool(msg.r, e.x3D);
				Files.WriteBool(msg.r, e.transparent);
			END
		| msg : TextFrames.TrackMsg DO
			Elems.Handle(e, msg);
			IF msg.keys = {MM} THEN Track(e, msg) END
		| msg : Elems.AttrMsg DO
			HandleAttrMsg(e, msg)
		ELSE
			Elems.Handle(e, msg)
		END
	END
END Handle;

PROCEDURE Init* (e : Elem);
BEGIN
	Elems.Init(e);
	e.handle := Handle;
	e.value := "StaticText";
	e.border := FALSE; e.x3D := FALSE; e.transparent := FALSE;
	e.align := left;
	e.H := LONG(Fonts.Default.maxY - Fonts.Default.minY + 5) * DUnit;
	e.W := 100 * DUnit
END Init;

PROCEDURE New*;
VAR e : Elem;
BEGIN NEW(e); Init(e); Texts.new := e;
END New;

PROCEDURE Insert*; (** Name Cmd Par W H Value align ("B" | "3D" | "") ("Y"  | "")*)
VAR e : Elem; m : TextFrames.InsertElemMsg; s : Texts.Scanner;
BEGIN
	NEW(e); Init(e);
	Elems.GetPar(e, s);
	IF ~s.eot & (s.class IN {Texts.Name, Texts.String}) THEN
		COPY(s.s, e.value);

		Texts.Scan(s);
		IF ~s.eot & (s.class IN {Texts.Char, Texts.Name, Texts.String}) THEN
			IF s.class = Texts.Char THEN s.s[0] := s.c END;
			IF CAP(s.s[0]) = "R" THEN e.align := right
			ELSIF CAP(s.s[0]) = "C" THEN e.align := center
			END;

			Texts.Scan(s);
			IF ~s.eot & (s.class IN {Texts.Name, Texts.String}) THEN
				e.x3D := s.s = "3D";
				e.border := (s.s = "3D") OR (s.s[0] = "B");

				Texts.Scan(s);
				IF ~s.eot & (s.class IN {Texts.Name, Texts.String}) THEN
					e.transparent := s.s[0] = "Y"
				END
			END
		END
	END;
	m.e := e; Viewers.Broadcast(m)
END Insert;

END StaticTextElems.

System.Free StaticTextElems ~

StaticTextElems.Insert "" "" "" 0 0 Wert center "3D" F~
