
  Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt  
    J    8  FoldElems New     8   "            8   v   8   !            8      8   !            8      8   !    	        8       8   !            8       8   !    	        8       8   !            8       8   !            8      8   !        5    8   a    8   !             8       8   !            8       8   !    
        8   z    8   !            8       8   !        *    8      8   !        *    8      8   !        *    8      8   !        *    8   F   8   !        J    8      8       8      8       .  MODULE ScrollBars;
IMPORT Display, Input, Oberon;
CONST
	MR = 0; MM = 1; ML = 2; Cancel = {ML, MM, MR};
	black = 15; darkgrey = 14; middlegrey = 13; lightgrey = 12; white = 0;
	patternCol = darkgrey; backCol = white;

TYPE
	ScrollBarElem* = POINTER TO ScrollBarElemDesc;
	ScrollBarElemDesc* = RECORD
		F*: Display.Frame;
		x-, y-, w-, h-: INTEGER;
		minW-, sliderdY-, sliderH-: INTEGER;
		backgroundCol: INTEGER;
		downArrow, upArrow: Display.Pattern;
		downdX, downdY, updX, updY: INTEGER;;
		downW, downH, upW, upH: INTEGER;
	END ;

VAR
	backgroundCol: INTEGER;
	downArrow, upArrow: Display.Pattern;
	downArrowImage, upArrowImage, pat: ARRAY 9 OF SET;
	downPatW, upPatW, downPatH, upPatH: INTEGER;
	lowDelay, middleDelay, highDelay, suspendTime, time: LONGINT;

	PROCEDURE DrawButton(pressed: BOOLEAN; pat: Display.Pattern; patX, patY, X, Y, W, H: INTEGER);
	VAR
		lowerCol, upperCol : INTEGER;
	BEGIN
		IF pressed THEN
			lowerCol := lightgrey;
			upperCol := darkgrey;
			INC(patX); DEC(patY)
		ELSE
			lowerCol := darkgrey;
			upperCol := lightgrey
		END ;
		Display.ReplConst(lowerCol, X, Y, W, 2, Display.replace);
		Display.ReplConst(lowerCol, X+W-2, Y +2, 2, H-2, Display.replace);

		Display.ReplConst(upperCol, X, Y+2, 2, H-2, Display.replace);
		Display.ReplConst(upperCol, X+2, Y+H-2, W-4, 2, Display.replace);
		Display.Dot(upperCol, X, Y+1, Display.replace);
		Display.Dot(upperCol, X+W-2, Y+H-1, Display.replace);

		Display.ReplConst(middlegrey, X+2, Y+2, W-4, H-4, Display.replace);

		IF pat # 0 THEN
			Display.CopyPattern(black, pat, X + patX, Y + patY, Display.paint)
		END
	END DrawButton;


	PROCEDURE (obj: ScrollBarElem) Init*;
	BEGIN
		obj.downArrow := downArrow;
		obj.upArrow := upArrow;
		obj.backgroundCol := backgroundCol;
		obj.downW := downPatW; obj.downH := downPatH;
		obj.upW := upPatW; obj.upH := upPatH;
		obj.downdX := 0; obj.downdY := 0;
		obj.updX := 0; obj.updY := 0;
		obj. x := 0; obj.y := 0; obj.w := 0; obj.h := 0;
		obj.sliderdY := 0; obj.sliderH := 0;
		obj.F := NIL
	END Init;

	PROCEDURE (obj: ScrollBarElem) CalculateSliderDim* (length, beg, end: LONGINT);
	VAR h, minSliderH: INTEGER;
	BEGIN
		h := obj.h - 2*obj.w;
		minSliderH := obj.minW + obj.minW DIV 2;
		IF h <= minSliderH THEN
			obj.sliderdY := 0; obj.sliderH := h
		ELSIF length = 0 THEN obj.sliderdY := 0; obj.sliderH := h
		ELSIF (beg = 0) & (length = end) THEN obj.sliderdY := 0; obj.sliderH := h
		ELSE
			obj.sliderH := SHORT(((h-minSliderH)*(end-beg)) DIV length);
			IF obj.sliderH < minSliderH THEN obj.sliderH := minSliderH
			ELSIF obj.sliderH > h THEN obj.sliderH := h  END ;
			obj.sliderdY := SHORT(((h-minSliderH)*beg) DIV length);
			IF (beg > 0) & (obj.sliderdY = 0) THEN INC(obj.sliderdY) END ;
			IF length = end THEN obj.sliderdY := h - obj.sliderH
			ELSIF obj.sliderdY + obj.sliderH >= h THEN
				obj.sliderH := obj.sliderH - (obj.sliderdY - obj.sliderH) DIV 2;
				IF obj.sliderH < minSliderH THEN obj.sliderH := minSliderH
				ELSIF obj.sliderH > h THEN obj.sliderH := h END ;
				obj.sliderdY := h -  obj.sliderH;
				IF obj.sliderdY > 1 THEN DEC(obj.sliderdY) END
			END
		END
	END CalculateSliderDim;

	PROCEDURE (obj: ScrollBarElem) SetDim* (x, y, w, h: INTEGER); 
	BEGIN
		obj.minW := w;
		obj.x := x; obj.y := y; obj.w := w; obj.h := h;
		IF (obj.minW < obj.downW + 4) & (obj.downW >= obj.upW) THEN obj.minW := obj.downW + 4
		ELSIF (obj.minW < obj.upW + 4) & (obj.upW >= obj.downW) THEN obj.minW := obj.upW + 4
		END ;
		obj.downdX := (w - obj.downW) DIV 2;
		obj.downdY := (w - obj.downH) DIV 2 ;
		obj.updX := (w - obj.upW) DIV 2;
		obj.updY := (w - obj.upH+1) DIV 2;
		obj.sliderH := w + w DIV 2;
		obj.sliderdY := 0;
	END SetDim;

	PROCEDURE (obj: ScrollBarElem) LineDown*;
	BEGIN
	END LineDown;

	PROCEDURE (obj: ScrollBarElem) LineUp*;
	BEGIN
	END LineUp;

	PROCEDURE (obj: ScrollBarElem) PageDown*;
	BEGIN
	END PageDown;

	PROCEDURE (obj: ScrollBarElem) PageUp*;
	BEGIN
	END PageUp;

	PROCEDURE (obj: ScrollBarElem) DrawSlider* (pressed : BOOLEAN);
	VAR x, y, w, h, sdY, sH: INTEGER;
	BEGIN
		x := obj.x; y := obj.y + obj.w;
		w := obj.w; h := obj.h - 2*w;
		sdY := obj.sliderdY; sH := obj.sliderH;
		IF obj.minW # w THEN
			Display.ReplConst(backCol, x, y, w, h, Display.replace)
		ELSIF (h < w + w DIV 2) THEN
			Display.ReplConst(obj.backgroundCol, x, y, w, h, Display.replace)
		ELSE
			IF sdY > 0 THEN
				Display.ReplConst(obj.backgroundCol, x, y+h-sdY, w, sdY, Display.replace)
			END ;
			DrawButton(pressed, 0, 0, 0, x, y+h-sdY-sH, w, sH);
			IF h - sdY - sH > 0 THEN
				Display.ReplConst(obj.backgroundCol, x, y, w, h - sdY - sH, Display.replace)
			END
		END
	END DrawSlider;

	PROCEDURE (obj: ScrollBarElem) Update* (sliderPressed: BOOLEAN; length, beg, end: LONGINT);
	BEGIN
		obj.CalculateSliderDim(length, beg, end);
		obj.DrawSlider(sliderPressed)
	END Update;

	PROCEDURE (obj: ScrollBarElem) UpdateView*(pressed: BOOLEAN; dY: INTEGER);
	BEGIN
	END UpdateView;

	PROCEDURE (obj: ScrollBarElem) DrawDownButton* (pressed : BOOLEAN);
	VAR pat: Display.Pattern;
	BEGIN
		DrawButton(pressed, obj.downArrow, obj.downdX, obj.downdY, obj.x, obj.y, obj.w, obj.w)
	END DrawDownButton;

	PROCEDURE (obj: ScrollBarElem) DrawUpButton* (pressed : BOOLEAN);
	BEGIN
		DrawButton(pressed, obj.upArrow, obj.updX, obj.updY, obj.x, obj.y+obj.h-obj.w, obj.w, obj.w)
	END DrawUpButton;

	PROCEDURE (obj: ScrollBarElem) Draw*;
	BEGIN
		IF obj.h < obj.minW*2 THEN
			Display.ReplConst(obj.backgroundCol, obj.x, obj.y, obj.w, obj.h, Display.replace)
		ELSE
			obj.DrawUpButton(FALSE);
			obj.DrawSlider(FALSE);
			obj.DrawDownButton(FALSE)
		END
	END Draw;

	PROCEDURE (obj: ScrollBarElem) TrackDownButton* (VAR mx, my : INTEGER; VAR keysum : SET);
	VAR fast, pressed: BOOLEAN; keys : SET; x, y, w, h: INTEGER;
	BEGIN
		x := obj.x; y := obj.y; w := obj.w; h := w;
		Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
		pressed := FALSE;
		suspendTime := Input.Time();
		fast := FALSE;
		REPEAT
			IF ~pressed & (x <= mx) & (mx < x + w) & (y <= my) & (my <  y + h) THEN
				pressed := TRUE;
				obj.DrawDownButton(pressed)
			ELSIF pressed & ((mx < x) OR (x + w <= mx) OR (my < y) OR (y + h <= my)) THEN
				pressed := FALSE;
				obj.DrawDownButton(pressed)
			END ;
			IF pressed & (keysum # {}) THEN
				time := Input.Time();
				IF time >= suspendTime THEN
					IF fast THEN suspendTime := time + lowDelay
					ELSE fast := TRUE; suspendTime := time + middleDelay
					END ;
					obj.LineUp
				END
			END ;
			Input.Mouse(keys, mx, my); Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
			keysum := keysum + keys
		UNTIL keys = {};
		obj.DrawDownButton(FALSE)
	END TrackDownButton;

	PROCEDURE (obj: ScrollBarElem) TrackUpButton* (VAR mx, my : INTEGER; VAR keysum : SET);
	VAR fast, pressed: BOOLEAN; keys : SET; x, y, w, h: INTEGER;
	BEGIN
		x := obj.x; y := obj.y + obj.h - obj.w; w := obj.w; h := w;
		Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
		pressed := FALSE;
		suspendTime := Input.Time();
		fast := FALSE;
		REPEAT
			IF ~pressed & (x <= mx) & (mx < x + w) & (y <= my) & (my <  y + h) THEN
				pressed := TRUE;
				obj.DrawUpButton(pressed)
			ELSIF pressed & ((mx < x) OR (x + w <= mx) OR (my < y) OR (y + h <= my)) THEN
				pressed := FALSE;
				obj.DrawUpButton(pressed)
			END ;
			IF pressed & (keysum # {}) THEN
				time := Input.Time();
				IF time >= suspendTime THEN
					IF fast THEN suspendTime := time + lowDelay
					ELSE fast := TRUE; suspendTime := time + middleDelay
					END ;
					 obj.LineDown
				 END
			END ;
			Input.Mouse(keys, mx, my); Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
			keysum := keysum + keys
		UNTIL keys = {};
		obj.DrawUpButton(FALSE)
	END TrackUpButton;

	PROCEDURE (obj: ScrollBarElem) TrackSlider* (VAR mx, my : INTEGER; VAR keysum : SET);
	VAR
		keys: SET;
		x, y, w, h, sH, sdY, dY, minH, myOld, myHelp, dYOld, delta: INTEGER;
	BEGIN
		x := obj.x; y := obj.y + obj.w; w := obj.w; h := obj.h - 2*obj.w;
		sH := obj.sliderH; sdY := obj.sliderdY;
		minH := obj.minW + obj.minW DIV 2;
		dYOld := sdY; dY := sdY;
		myOld := my; delta := 0;
		Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
		obj.DrawSlider(TRUE);
		REPEAT
			myHelp := my;
			IF (keysum # {}) & (delta # 0) THEN
				obj.UpdateView(TRUE,dY)
			END ;
			Input.Mouse(keys, mx, my); Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
			keysum := keysum + keys;
			delta := myHelp - my;
			dY := sdY + (myOld - my);
			IF ((delta > 0 ) & (dY <= obj.sliderdY)) OR ((delta < 0) & (dY >= obj.sliderdY)) THEN delta := 0 END ;
			IF (delta > 0) & (h = obj.sliderdY + obj.sliderH) THEN
				myOld := my; sdY := obj.sliderdY; delta := 0;
				IF myOld < y THEN myOld := y END
			ELSIF (delta < 0) & (obj.sliderdY = 0 ) THEN
				myOld := my; sdY := 0; delta := 0;
				IF myOld >= y + h THEN myOld := y + h - 1 END
			END ;
			IF dY <  0 THEN dY := 0
			ELSIF dY > h - minH THEN dY := h - minH
			END ;
		UNTIL keys = {};
		IF keysum # Cancel THEN
			obj.DrawSlider(FALSE)
		ELSE
			obj.UpdateView(FALSE, dYOld)
		END
	END TrackSlider;

	PROCEDURE (obj: ScrollBarElem) TrackSliderBar*(VAR mx, my : INTEGER; VAR keysum : SET);
	VAR keys: SET; fast: BOOLEAN;
	BEGIN
		suspendTime := Input.Time();
		IF my >= obj.y + obj.h -obj.w - obj.sliderdY THEN
			Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
			fast := FALSE;
			REPEAT
				IF (keysum # {}) & (my >= obj.y + obj.h -obj.w - obj.sliderdY) & (my < obj.y + obj.h -obj.w) THEN
					time := Input.Time();
					IF time >= suspendTime THEN
						IF fast THEN suspendTime := time + middleDelay
						ELSE fast := TRUE; suspendTime := time + highDelay
						END ;
						obj.PageUp
					 END
				END ;
				Input.Mouse(keys, mx, my); Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
				keysum := keysum + keys
			UNTIL keys = {};
		ELSIF my >= obj.y + obj.h -obj.w -obj.sliderdY - obj.sliderH THEN
			obj.TrackSlider(mx, my, keysum)
		ELSE
			Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
			fast := FALSE;
			REPEAT
				IF (keysum # {}) & (my >= obj.y + obj.w) & (my < obj.y + obj.h -obj.w - obj.sliderdY - obj.sliderH) THEN
					time := Input.Time();
					IF time >= suspendTime THEN
						IF fast THEN suspendTime := time + middleDelay
						ELSE fast := TRUE; suspendTime := time + highDelay
						END ;
						obj.PageDown
					 END
				END ;
				Input.Mouse(keys, mx, my); Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, mx, my);
				keysum := keysum + keys
			UNTIL keys = {};
		END
	END TrackSliderBar;

	PROCEDURE (obj: ScrollBarElem) HandleScrollBar* (F: Display.Frame; mx, my : INTEGER;
																						keysum : SET);
	BEGIN
		obj.F := F;
		IF (keysum # {}) & (obj.w >= obj.minW) & (obj.h >= 2*obj.w) THEN
			Oberon.RemoveMarks(obj.x, obj.y, obj.w, obj.h);
			IF my < obj.y + obj.w THEN obj.TrackDownButton(mx, my, keysum)
			ELSIF my >= obj.y + obj.h - obj.w THEN obj.TrackUpButton(mx, my, keysum)
			ELSIF obj.h >= 2*obj.w + obj.sliderH THEN obj.TrackSliderBar(mx, my, keysum)
			END ;
		END
	END HandleScrollBar;

BEGIN
	highDelay := Input.TimeUnit DIV 2;
	middleDelay := Input.TimeUnit DIV 3;
	lowDelay := Input.TimeUnit DIV 18;

	backgroundCol := middlegrey;

	upArrowImage[0] := {};	downArrowImage[0] := {};
	upArrowImage[1] := {2..4};	downArrowImage[7] := {2..4};
	upArrowImage[2] := {2..4};	downArrowImage[6] := {2..4};
	upArrowImage[3] := {2..4};	downArrowImage[5] := {2..4};
	upArrowImage[4] := {0..6};	downArrowImage[4] := {0..6};
	upArrowImage[5] := {1..5};	downArrowImage[3] := {1..5};
	upArrowImage[6] := {2..4};	downArrowImage[2] := {2..4};
	upArrowImage[7] := {3};	downArrowImage[1] := {3};
	upArrow := Display.NewPattern(upArrowImage, 7, 7);
	downArrow := Display.NewPattern(downArrowImage, 7, 7);
	downPatW := 7; downPatH := 7;
	upPatW := 7; upPatH := 7;


END ScrollBars.