#   Syntax10.Scn.Fnt  ;   ;  MODULE -->modulename;
(*  scanner module generated by Coco-R.  Cap1 and Cap 2 added by GH, 2000*)

IMPORT Texts, SYSTEM;

CONST
	EOL = 0DX;
	EOF = 0X;
	maxLexLen = 127;
-->declarations

TYPE
	ErrorProc* = PROCEDURE (n: INTEGER; pos: LONGINT);
	StartTable = ARRAY 128 OF INTEGER;
  
VAR
	src*: Texts.Text;  (*source text. To be set by the main pgm*)
	pos*: LONGINT;  (*position of current symbol*)
	line*, col*, len*: INTEGER;  (*line, column, length of current symbol*)
	nextPos*: LONGINT;  (*position of lookahead symbol*)
	nextLine*, nextCol*, nextLen*: INTEGER;  (*line, column, length of lookahead symbol*)
	errors*: INTEGER;  (*number of errors detected*)
	Error*: ErrorProc;

	ch: CHAR;        (*current input character*)
	r: Texts.Reader;	(*global reader*)
	chPos: LONGINT;	(*position of current character*)
	chLine: INTEGER;  (*current line number*)
	lineStart: LONGINT;  (*start position of current line*)
	apx: INTEGER;     (*length of appendix*)
	oldEols: INTEGER;     (*nr. of EOLs in a comment*)

	start: StartTable;  (*start state for every character*)

PROCEDURE NextCh; (*return global variable ch*)
BEGIN
	IF oldEols > 0 THEN DEC(oldEols); ch := EOL
	ELSE
		Texts.Read(r, ch); INC(chPos);
		IF ch = EOL THEN INC(chLine); lineStart := chPos + 1 END
	END
END NextCh;


PROCEDURE Comment(): BOOLEAN;
	VAR level, startLine: INTEGER; oldLineStart: LONGINT;
BEGIN (*Comment*)
	level := 1; startLine := chLine; oldLineStart := lineStart;
-->comment
END Comment;


PROCEDURE Get*(VAR sym: INTEGER);
VAR i, state: INTEGER; lexeme: ARRAY maxLexLen+1 OF CHAR;

	PROCEDURE CheckLiteral;
	BEGIN
		IF nextLen < maxLexLen THEN lexeme[nextLen] := 0X END;
-->literals
	END CheckLiteral;
	
BEGIN
-->GetSy1
	IF ch > 7FX THEN ch := " " END;
	pos := nextPos; col := nextCol; line := nextLine; len := nextLen;
	nextPos := chPos; nextCol := SHORT(chPos - lineStart); nextLine := chLine; nextLen := 0;
	state := start[ORD(ch)]; apx := 0;
	LOOP
		IF nextLen < maxLexLen THEN
-->Cap1
			lexeme[nextLen] := ch
		END;
		INC(nextLen);
		NextCh;
		IF state > 0 THEN
			CASE state OF
-->GetSy2
			END (*CASE*)
		ELSE sym := noSym; RETURN (*NextCh already done*)
		END (*IF*)
	END (*LOOP*)
END Get;
	

PROCEDURE GetName*(pos: LONGINT; len: INTEGER; VAR s: ARRAY OF CHAR);
	VAR i: INTEGER; r: Texts.Reader;	ch: CHAR;
BEGIN
	Texts.OpenReader(r, src, pos);
	IF len >= LEN(s) THEN len := SHORT(LEN(s)) - 1 END;
	i := 0;
	WHILE i < len DO Texts.Read(r, ch);
-->Cap2
		s[i] := ch;
		INC(i)
	END;
	s[i] := 0X
END GetName;
	
PROCEDURE StdErrorProc* (n: INTEGER; pos: LONGINT);
BEGIN INC(errors) END StdErrorProc;

PROCEDURE Reset* (t: Texts.Text; pos: LONGINT; errProc: ErrorProc);
BEGIN
	src := t; Error := errProc;
	Texts.OpenReader(r, src, pos);
	chPos := pos - 1; chLine := 1; lineStart := 0;
	oldEols := 0; apx := 0; errors := 0;
	NextCh
END Reset;

BEGIN
-->initialization
END -->modulename.
