)  Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt  	       Syntax10i.Scn.Fnt        InfoElems Alloc  V   Syntax10.Scn.Fnt  S   z  StampElems Alloc 26 Sep 97  {     "Title": OpenElems
"Author": Christoph Steindl (CS)
"Abstract": OpenElems perform a generic open command on the selected item. Depending on the suffix of the
	entry different commands are called. The items are collected automatically from the current directory.
"Keywords": Opening files
"Version": 1.0
"From":  22.05.95 15:39:15
"Until": 
"Changes": no changes
"Hints": You can insert new suffix mappings by calling OpenElems.Add pattern command, can also be used to override
	the default mapping, i.e. OpenElems.Add *.Text MyEdit.Open will cause *.Text files to be opened with MyEdit.
	The predefined mappings are taken from the file Dir.Menu.Text. The syntax for entries in Dir.Menu.Text is described
	in Dir.Text.
 2    x            
    )                               ]        &   R        
           n    
    C   N  OpenElems AllocAutoDir * w   Syntax10.Scn.Fnt     	           H        v    	                   %    :  AsciiCoder.Mod
AsciiCoder.Mod.Bak
AutoMenuElems.Mod
BalloonElems.Mod
Batch.Mod
CR.ATG
CRA.Mod
CRP.Mod
CRS.Mod
CRT.Mod
CRX.Mod
Calc.Mod
Catalogs.Mod
Class.Mod
ClockElems.Mod
Coco.Mod
Colors.Mod
Compress.Mod
Count.Mod
Count.Mod.Bak
CrazyFiller.Mod
Curves.Mod
Def.Mod
Dir.Mod
Dir.Mod.Bak
DirElems.Mod
Distributor.Mod
Distributor.Mod.Bak
Documents.Mod
Documents.Mod.Bak
Draw.Mod
Dsp.Mod
Edit.Mod
Edit.Mod.Bak
EditKeys.Mod
EditTools.Mod
ErrorElems.Mod
Film.Mod
Find.Mod
Flush.Mod
FoldElems.Mod
FoldElems.Mod.Bak
Folds.Mod
FontElems.Mod
GIF.Mod
Generic.Mod
GraphicElems.Mod
GraphicFrames.Mod
GraphicOps.Mod
Graphics.Mod
HandlerElems.Mod
Hex.Mod
HistoryElems.Mod
IconElems.Mod
In.Mod
IndexElems.Mod
IndexElems.Mod.Bak
InfoElems.Mod
Interface.Mod
Internal
Jpeg.Mod
Jpeg.Mod.Bak
Kepler.Mod
Kepler1.Mod
Kepler2.Mod
Kepler4.Mod
Kepler5.Mod
Kepler6.Mod
Kepler7.Mod
Kepler8.Mod
Kepler9.Mod
KeplerElems.Mod
KeplerFrames.Mod
KeplerGraphs.Mod
KeplerLinks.Mod
KeplerPorts.Mod
KeplerPorts.Mod.Bak
LineElems.Mod
LineSorter.Mod
Lines.Mod
LinkElems.Mod
Linux
Log.Mod
Make.Mod
Make.Mod.Bak
MarkElems.Mod
MenuViewers.Mod
Mirrors.Mod
Misc
MoreMathL.Mod
OpenElems.Mod
OpenElems.Mod.Bak
Out.Mod
PElems.Mod
ParcElems.Mod
Parser.FRM
Platform.Mod
PopupElems.Mod
PowerMac
Put.Mod
Put.Mod.Bak
Rectangles.Mod
RefElems.Mod
Regexp.Mod
Scanner.FRM
Screen.Mod
ScrollBars.Mod
Sets.Mod
Sort.Mod
SortDemo.Mod
Sparc
Splines.Mod
Split.Mod
StampElems.Mod
Strings.Mod
StyleElems.Mod
TableElems.Mod
TarDump.Mod
Telnet.Mod
Telnet.Mod.Bak
TerminalFrames.Mod
Terminals.Mod
TextFrames.Mod
TextFrames.Mod.Bak
TextFrames1.Mod
TextFrames3.Mod
TextFrames3.Mod.Bak
TextPFrames.Mod
TextPFrames.Mod.Bak
TextPreview.Mod
Texts.Mod
Texts.Mod.Bak
Timer.Mod
Timer.Mod.Bak
Trace.Mod
TreeElems.Mod
UUDecoder.Mod
Util.Mod
VersionElems.Mod
VersionElems.Mod.Bak
Viewers.Mod
Win
XBM.Mod
XIn.Mod
XYplane.Mod
Xref.Mod
       MODULE OpenElems;	(** CS  Documents.Open is called to open the document *)

IMPORT Viewers, Texts, TextFrames, Oberon, PopupElems, Directories, Display, Strings;

CONST DefTableSize = 64;

TYPE
	OpenElem* = POINTER TO OpenElemDesc;
	OpenElemDesc* = RECORD (PopupElems.ElemDesc)
	END ;

	AutoDirElem* = POINTER TO AutoDirElemDesc;
	AutoDirElemDesc* = RECORD (OpenElemDesc)
	END ;

	StrArray = POINTER TO ARRAY OF ARRAY 128 OF CHAR;
	Table = RECORD
		arr: StrArray;
		len: LONGINT
	END;

VAR
	w: Texts.Writer;
	cnt: INTEGER;
	elem: OpenElem;
	pattern: ARRAY 32 OF CHAR;

PROCEDURE ReadName (t: Texts.Text; pos: LONGINT; VAR name: ARRAY OF CHAR);
	VAR r: Texts.Reader; ch: CHAR; i: INTEGER; beg, end, time: LONGINT;
BEGIN
	Texts.OpenReader(r, t, pos); Texts.Read(r, ch); i := 0;
	IF ch = '"' THEN Texts.Read(r, ch);
		WHILE ~r.eot & (ch # '"') DO name[i] := ch; INC(i); Texts.Read(r, ch) END
	ELSE
		WHILE ~r.eot & (ch > " ") DO name[i] := ch; INC(i); Texts.Read(r, ch) END
	END ;
	name[i] := 0X;
	IF name = "^" THEN
		Oberon.GetSelection(t, beg, end, time);
		IF time >= 0 THEN ReadName(t, beg, name) END
	END
END ReadName;

PROCEDURE Exec (e: OpenElem; f: Display.Frame; pos: LONGINT);
	VAR m: TextFrames.UpdateMsg; res: INTEGER; name: ARRAY 256 OF CHAR;
		par: Oberon.ParList; dir: Directories.Directory;
BEGIN
	ReadName(e.menu, pos, name);
	dir := Directories.This(name);
	IF dir # NIL THEN
		Directories.Change(dir.path)
	ELSE
		NEW(par); par.frame := f; par.text := e.menu; par.pos := pos;
		Oberon.Call("Documents.Open", par, FALSE, res);
		IF res = 0 THEN
			m.id := TextFrames.replace; m.text := Texts.ElemBase(e); m.beg := Texts.ElemPos(e); m.end := m.beg + 1;
			Viewers.Broadcast(m)
		ELSE Texts.WriteString(w, " -- failed"); Texts.WriteLn(w); Texts.Append(Oberon.Log, w.buf)
		END
	END
END Exec;

PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);
	VAR e1: OpenElem;
BEGIN
	WITH e: OpenElem DO
		WITH
			m: Texts.CopyMsg DO
				IF m.e = NIL THEN NEW (e1); m.e := e1 END ;
				PopupElems.Handle(e, m)
		|  m: Texts.IdentifyMsg DO
				m.mod := "OpenElems"; m.proc := "Alloc"
		|  m: PopupElems.ExecMsg DO Exec(e, m.frame, m.pos)
		ELSE PopupElems.Handle(e, m)
		END
	END
END Handle;

PROCEDURE Alloc*;
	VAR e: OpenElem;
BEGIN
	NEW(e); e.handle := Handle; Texts.new := e
END Alloc;

PROCEDURE Insert*;
	VAR e: OpenElem; insert: TextFrames.InsertElemMsg; s: Texts.Scanner;
BEGIN
	NEW(e); e.handle := Handle; e.small := TRUE;
	Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s);
	IF ~(s.class IN {Texts.Name, Texts.String}) THEN s.s := "OpenElem" END ;
	COPY(s.s, e.name);
	e.menu := TextFrames.Text(""); PopupElems.MeasureMenu(e);
	insert.e := e; Viewers.Broadcast(insert)
END Insert;

PROCEDURE WriteName (name: ARRAY OF CHAR);
	VAR ch: CHAR; i: INTEGER; quote: CHAR;
BEGIN
	ch := name[0]; i := 0; quote := '"';
	WHILE (ch # 0X) & (("a" <= ch) & (ch <= "z") OR ("A" <= ch) & (ch <= "Z") OR (ch = ".") OR (ch = "/") OR (ch = "$")
		OR (i > 0) & (("0" <= ch) & (ch <= "9") OR (ch = ":"))) DO
		IF ch = '"' THEN quote := "'"
		ELSIF ch = "'" THEN quote := '"'
		END ;
		INC(i); ch := name[i]
	END ;
	IF ch # 0X THEN Texts.Write(w, quote) END ;
	Texts.WriteString(w, name);
	IF ch # 0X THEN Texts.Write(w, quote) END
END WriteName;

PROCEDURE AddName (VAR name: ARRAY OF CHAR);
VAR s: Texts.Scanner; pos: LONGINT;
BEGIN
	Texts.OpenScanner(s, elem.menu, 0); Texts.Scan(s);
	pos := 0; 
	WHILE ((s.class=Texts.String) OR (s.class=Texts.Name)) & (s.s < name) DO
		pos := Texts.Pos(s);
		Texts.Scan(s)
	END;
	Texts.Insert (elem.menu, pos, w.buf)
END AddName;

PROCEDURE ListProc (d: Directories.Directory; name: ARRAY OF CHAR; isDir: BOOLEAN; VAR continue: BOOLEAN);
	CONST blue = 3;
	VAR col: SHORTINT;
BEGIN
	IF Strings.Match(name, pattern) OR isDir THEN
		IF isDir THEN col := blue ELSE col := Display.white END ;
		Texts.SetColor(w, col); WriteName(name); Texts.WriteLn (w);
		AddName (name);
		INC(cnt)
	END
END ListProc;

PROCEDURE CollectFiles;
BEGIN
	elem.menu := TextFrames.Text(""); cnt := 0; COPY(elem.name, pattern);
	Directories.Enumerate(Directories.Current(), ListProc);
	IF cnt = 1 THEN Texts.WriteLn(w) (* prohibit AutoDirElems that do not pop up because they only contain one item *)
	ELSIF cnt = 0 THEN Texts.WriteString (w, "no files found"); Texts.WriteLn (w); Texts.WriteLn (w) END ;
	Texts.Append(elem.menu, w.buf); PopupElems.MeasureMenu(elem)
END CollectFiles;

PROCEDURE HandleAutoDir* (e: Texts.Elem; VAR m: Texts.ElemMsg);
	VAR e1: AutoDirElem;
BEGIN
	WITH e: AutoDirElem DO
		WITH m: Texts.CopyMsg DO
				IF m.e = NIL THEN NEW (e1); m.e := e1 END ;
				Handle(e, m)
		|  m: Texts.IdentifyMsg DO
				m.mod := "OpenElems"; m.proc := "AllocAutoDir"
		|  m: TextFrames.TrackMsg DO
				IF 1 IN m.keys THEN elem := e; CollectFiles; Handle (e, m); elem := NIL END
		ELSE Handle(e, m)
		END
	END
END HandleAutoDir;

PROCEDURE AllocAutoDir*;
	VAR e: AutoDirElem;
BEGIN
	NEW(e); e.handle := HandleAutoDir; Texts.new := e
END AllocAutoDir;

PROCEDURE InsertAutoDir*;
	VAR e: AutoDirElem; insert: TextFrames.InsertElemMsg;
BEGIN
	NEW(e); e.handle := HandleAutoDir; e.small := TRUE; e.name := "*";
	e.menu := TextFrames.Text(""); PopupElems.MeasureMenu(e);
	insert.e := e; Viewers.Broadcast(insert)
END InsertAutoDir;

BEGIN Texts.OpenWriter(w)
END OpenElems.Insert
OpenElems.InsertAutoDir


