  Syntax10.Scn.Fnt      P  StampElems Alloc 8 Aug 2      "8  FoldElems New  #   Syntax10.Scn.Fnt       (*-----------------------------------------------------------------------
Lines extracts lines containing a certain pattern from a text. This can be used, to get directory
listings with negative selections. For example, in order to get all files except *.Bak files one
does the following:
	System.Directory *
	-- mark the output viewer
	Lines.Separate *.Bak

Lines.Separate (pattern | ^)
	Extracts the lines with the specified pattern from the marked text and displays them in a
	separate viewer. The pattern either follows the command or is described by the selection.
	It contains any character up to the first blank or tab.
-----------------------------------------------------------------------*)Syntax10i.Scn.Fnt  
    8   d   Syntax10b.Scn.Fnt          B         MODULE Lines;	(* HM  *)
Documentation

IMPORT Texts, Viewers, TextFrames, MenuViewers, Oberon, Strings;

VAR w: Texts.Writer;

PROCEDURE Separate*;	(* [ pattern | "^"] -- removes lines with pattern from marked viewer *)
	VAR t: Texts.Text; r: Texts.Reader; pat, line: ARRAY 128 OF CHAR; ll, pl: INTEGER;
		v: Viewers.Viewer; x, y: INTEGER; eof: BOOLEAN; out: TextFrames.Frame; pos: LONGINT;

	PROCEDURE GetPattern(VAR s: ARRAY OF CHAR);
		VAR r: Texts.Reader; t: Texts.Text; beg, end, time: LONGINT; ch: CHAR; pl: INTEGER;
	BEGIN
		Texts.OpenReader(r, Oberon.Par.text, Oberon.Par.pos);
		REPEAT Texts.Read(r, ch) UNTIL (ch > " ") OR (ch = 0DX);
		IF ch = "^" THEN
			Oberon.GetSelection(t, beg, end, time);
			IF time >= 0 THEN Texts.OpenReader(r, t, beg); Texts.Read(r, ch) ELSE ch := 0X END
		END ;
		pl := 0; WHILE ch > " " DO s[pl] := ch; INC(pl); Texts.Read(r, ch) END ;
		s[pl] := 0X
	END GetPattern;

	PROCEDURE GetText(VAR t: Texts.Text);
	BEGIN
		v := Oberon.MarkedViewer();
		IF (v # NIL) & (v.dsc.next IS TextFrames.Frame) THEN t := v.dsc.next(TextFrames.Frame).text
		ELSE t := NIL
		END
	END GetText;

	PROCEDURE GetLine(VAR s: ARRAY OF CHAR; VAR ll: INTEGER; VAR eof: BOOLEAN);
		VAR i: INTEGER; ch: CHAR;
	BEGIN i := 0;
		IF ~ eof THEN
			LOOP
				Texts.Read(r, ch); IF (ch = 0DX) OR (ch = 0X) THEN EXIT END ;
				s[i] := ch; INC(i)
			END ;
			eof := ch = 0X
		END ;
		s[i] := 0X; ll := i
	END GetLine;

	PROCEDURE WriteString (VAR s: ARRAY OF CHAR);
		VAR i: INTEGER; ch: CHAR;
	BEGIN
		i := 0; ch := s[0];
		WHILE ch # 0X DO Texts.Write(w, ch); INC(i); ch := s[i] END
	END WriteString;

BEGIN
	GetPattern(pat); GetText(t);
	IF (pat # "") & (t # NIL) THEN
		out := TextFrames.NewText(TextFrames.Text(""), 0);
		Texts.OpenReader(r, t, 0); pos := 0; eof := FALSE;
		LOOP
			GetLine(line, ll, eof); IF eof & (ll = 0) THEN EXIT END ;
			IF (ll > 0) & Strings.Match(line, pat) THEN
				WriteString(line); Texts.WriteLn(w);
				Texts.Delete(t, pos, pos + ll + 1); Texts.OpenReader(r, t, pos)
			ELSE pos := pos + ll +1
			END
		END ;
		Oberon.AllocateUserViewer(0, x, y);
		v := MenuViewers.New(TextFrames.NewMenu(pat, "System.Close"), out, TextFrames.menuH, x, y);
		Texts.Append(out.text, w.buf)
	END
END Separate;

BEGIN
	Texts.OpenWriter(w)
END Lines.