#   Syntax10.Scn.Fnt  	   	  MODULE Kepler5;	(* J. Templ 4.4.91 *)

IMPORT KeplerGraphs, KeplerFrames, KeplerPorts, Oberon, Display;

TYPE
	FocusStar* = POINTER TO StarDesc;
	StarDesc* = RECORD
		(KeplerGraphs.ConsDesc)
	END ;

	FocusStar2* = POINTER TO StarDesc2;
	StarDesc2* = RECORD
		(KeplerGraphs.ConsDesc)
	END ;

	SelStar* = POINTER TO SelStarDesc;
	SelStarDesc* = RECORD
		(KeplerGraphs.ConsDesc)
	END ;

	Planet* = POINTER TO PlanetDesc;
	PlanetDesc* = RECORD
		(KeplerGraphs.ConsDesc)
	END ;

(* ------------------------------- FocusStar ------------------------------- *)

	PROCEDURE (self: FocusStar) Draw* (F: KeplerPorts.Port);
		VAR x, y: INTEGER;
	BEGIN
		x := self.p[0].x - 8; y := self.p[0].y - 8;
		F.DrawLine(x, y, x + 16, y + 16, Display.white, Display.replace);
		F.DrawLine(x, y + 16, x + 16, y, Display.white, Display.replace)
	END Draw;

	PROCEDURE NewFocusStar*;
		VAR o: FocusStar;
	BEGIN
		IF KeplerFrames.nofpts > 0 THEN
			NEW(o); o.nofpts := 1;
			KeplerFrames.ConsumePoint(o.p[0]);
			KeplerFrames.Focus.Append(o);
		END
	END NewFocusStar;

(* ------------------------------- FocusStar2 ------------------------------- *)

	PROCEDURE (self: FocusStar2) Draw* (F: KeplerPorts.Port);
		VAR x, y: INTEGER;
	BEGIN x := self.p[0].x; y := self.p[0].y;
		F.DrawLine(x - 16, y, x + 16, y, Display.white, Display.replace);
		F.DrawLine(x, y + 16, x, y - 16, Display.white, Display.replace)
	END Draw;

	PROCEDURE NewFocusStar2*;
		VAR o: FocusStar2;
	BEGIN
		IF KeplerFrames.nofpts > 0 THEN
			NEW(o); o.nofpts := 1;
			KeplerFrames.ConsumePoint(o.p[0]);
			KeplerFrames.Focus.Append(o);
		END
	END NewFocusStar2;

(* ------------------------------- SelStar ------------------------------- *)

	PROCEDURE (self: SelStar) Draw* (F: KeplerPorts.Port);
	BEGIN
		F.FillRect(self.p[0].x - 12, self.p[0].y - 12, 28, 28, Display.white, 5, Display.replace)
	END Draw;

	PROCEDURE NewSelStar*;
		VAR o: SelStar;
	BEGIN
		IF KeplerFrames.nofpts > 0 THEN
			NEW(o); o.nofpts := 1;
			KeplerFrames.ConsumePoint(o.p[0]);
			KeplerFrames.Focus.Append(o);
		END
	END NewSelStar;

(* ------------------------------- Planet ------------------------------- *)

	PROCEDURE (self: Planet) Draw* (F: KeplerPorts.Port);
	BEGIN
		F.DrawRect(self.p[0].x - 12, self.p[0].y - 12, 24, 24, Display.white, Display.replace)
	END Draw;

	PROCEDURE NewPlanet*;
		VAR o: Planet;
	BEGIN
		IF KeplerFrames.nofpts > 0 THEN
			NEW(o); o.nofpts := 1;
			KeplerFrames.ConsumePoint(o.p[0]);
			KeplerFrames.Focus.Append(o);
		END
	END NewPlanet;


END Kepler5.
