,  Syntax10.Scn.Fnt  8  FoldElems New     Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      1   Syntax10i.Scn.Fnt      1                Z       \                        G   L  (*
Interface.Shrink [modName]
In order to customize the interface of a module M, proceed as follows:
1. Display the interface of M using Browser.ShowDef M
2. Textually delete declarations in the interface as appropriate.
	If you want to import a reduced interface SmallX of an imported module X,
	change the import clause to IMPORT X := SmallX;
3. Mark the viewer with the interface text
4. Execute "Interface.Shrink SmallM"
	the command will generate a new symbol file SmallM.Sym which is a copy of M.Sym
	but without the deleted declarations. If SmallM is not specified the default name
	is M1.Sym.
You can now import the customized interface (IMPORT SmallM) and refer to an
object x exported from SmallM (SmallM.x).
 
New error code
err 400: unknown name

Implementation
The new interface is generated by importing the old one, selectively marking
names which are in the modified interface text as external (other names are
marked internal) and writing a new symbol file. This is
done by reusing the compiler modules OPM, OPS and OPT.
After importing the module the following must be done:
- In all types, change mno=1 to mno=0
- In all procedures and methods change vis=internal to vis=external.
- If a type is imported from a reduced interface all references to this type
  must be changed to the corresponding type node in the reduced interface.
*)

Syntax10i.Scn.Fnt  
    8       	     I StampElems Alloc 18 Nov 96      <    dp  VersionElems AllocBeg   #   Syntax10.Scn.Fnt         PowerMac
WindowsWindows PowerMac #   Syntax10.Scn.Fnt  %    %   OPM := POPM, OPS := POPS, OPT := POPTWindows           %        p  VersionElems AllocEnd  &    R8   #   Syntax10.Scn.Fnt         
	Var = 1; VarPar = 2; Con = 3; Fld = 4; Typ = 5; LProc = 6; XProc = 7;
	SProc = 8; CProc = 9; IProc = 10; Mod = 11; Head = 12; TProc = 13;
 8       8   #   Syntax10.Scn.Fnt       
	Undef = 0; Byte = 1; Bool = 2; Char = 3; SInt = 4; Int = 5; LInt = 6;
	Real = 7; LReal = 8; Set = 9; String = 10; NilTyp = 11; NoTyp = 12;
	Pointer = 13; ProcTyp = 14; Comp = 15;
	
	(* composite structure forms *)
	Basic = 1; Array = 2; DynArr = 3; Record = 4;
 8       8   #   Syntax10.Scn.Fnt         
	internal = 0; external = 1;
 8       8   #   Syntax10.Scn.Fnt       
		null = 0; times = 1; slash = 2; div = 3; mod = 4;
		and = 5; plus = 6; minus = 7; or = 8; eql = 9;
		neq = 10; lss = 11; leq = 12; gtr = 13; geq = 14;
		in = 15; is = 16; arrow = 17; period = 18; comma = 19;
		colon = 20; upto = 21; rparen = 22; rbrak = 23; rbrace = 24;
		of = 25; then = 26; do = 27; to = 28; by = 29;
		lparen = 30; lbrak = 31; lbrace = 32; not = 33; becomes = 34;
		number = 35; nil = 36; string = 37; ident = 38; semicolon = 39;
		bar = 40; end = 41; else = 42; elsif = 43; until = 44;
		if = 45; case = 46; while = 47; repeat = 48; for = 49;
		loop = 50; with = 51; exit = 52; return = 53; array = 54;
		record = 55; pointer = 56; begin = 57; const = 58; type = 59;
		var = 60; procedure = 61; import = 62; module = 63; eof = 64;
 8   ;    ,        +        8   #   Syntax10.Scn.Fnt  8    8   
BEGIN
	OPM.errpos := OPM.curpos-1; OPM.err(n)
END Err;
 8       8   #   Syntax10.Scn.Fnt         
BEGIN
	OPS.Get(sym)
END Get;
 8       8   #   Syntax10.Scn.Fnt  7    7   
BEGIN
	IF sym = s THEN Get ELSE Err(s) END
END Check;
 8        8   #   Syntax10.Scn.Fnt  3    3   
BEGIN
	REPEAT Get UNTIL sym = s;
	Get
END SkipTo;
 8   #    8   #   Syntax10.Scn.Fnt       
	VAR typ1: OPT.Struct;
BEGIN
	IF sym = ident THEN Get;
		IF sym = period THEN Get; Get END
	ELSIF sym = record THEN Get;
		IF sym = lparen THEN Get; Type(typ.BaseTyp); Check(rparen) END;
		LOOP
			IF sym = ident THEN
				MarkField(typ, typ1); Get; IF sym = minus THEN Get END;
				WHILE sym = comma DO
					Get;
					MarkField(typ, typ1); Get; IF sym = minus THEN Get END
				END;
				Check(colon); Type(typ1)
			ELSIF sym = procedure THEN Get;
				IF sym = lparen THEN SkipTo(rparen) END;
				IF sym = ident THEN MarkField(typ, typ1); Get ELSE Err(ident) END;
				IF sym = lparen THEN SkipTo(rparen) END;
				IF sym = colon THEN Get; Check(ident);
					IF sym = period THEN Get; Check(ident) END
				END;
				IF sym = semicolon THEN Get END
			ELSE EXIT
			END
		END;
		Check(end)
	ELSIF sym = array THEN SkipTo(of); Type(typ.BaseTyp)
	ELSIF sym = pointer THEN Get; Get; Type(typ.BaseTyp)
	ELSIF sym = procedure THEN Get;
		IF sym = lparen THEN SkipTo(rparen) END
	END;
	IF sym = semicolon THEN Get END
END Type;
 8       8   #   Syntax10.Scn.Fnt  [   [  
	VAR name: OPS.Name;
BEGIN
	IF sym = import THEN Get;
		WHILE sym = ident DO
			name := OPS.name; Get;
			IF sym = becomes THEN Get;
				IF sym = ident THEN
					imp.old[imp.n] := name; imp.new[imp.n] := OPS.name; INC(imp.n);
					Get
				ELSE Err(ident)
				END
			END;
			IF sym = comma THEN Get END
		END;
		Check(semicolon)
	END
END Imports;
 8       8   #   Syntax10.Scn.Fnt  %   %  
	VAR dummy: OPS.Name; typ: OPT.Struct;
BEGIN
	Get;
	Check(ident);
	IF sym = ident THEN
		COPY(OPS.name, modName); Get;
		OPT.Import(modName, modName, dummy);
		OPT.topScope.right := OPT.topScope.right.scope;
		AdjustObj(OPT.topScope.right);
	ELSE Err(ident)
	END;
	Check(semicolon);
	Imports;
	LOOP
		IF sym = const THEN Get;
			WHILE sym = ident DO
				Mark(typ); SkipTo(semicolon)
			END
		ELSIF sym = type THEN Get;
			WHILE sym = ident DO
				Mark(typ); Get; Check(eql); Type(typ)
			END
		ELSIF sym = var THEN Get;
			WHILE sym = ident DO
				Mark(typ); Get; IF sym = minus THEN Get END;
				WHILE sym = comma DO
					Get;
					Mark(typ); Get; IF sym = minus THEN Get END
				END;
				Check(colon); Type(typ)
			END
		ELSIF sym = procedure THEN Get;
			IF sym = ident THEN
				Mark(typ); Get;
				IF sym = lparen THEN SkipTo(rparen) END;
				IF sym = colon THEN Get; Check(ident);
					IF sym = period THEN Get; Check(ident) END
				END;
				Check(semicolon)
			ELSE EXIT
			END
		ELSE EXIT
		END
	END;
	Check(end); Check(ident); Check(period)
END Parse;
 8   -    8     Syntax10.Scn.Fnt  R    8  FoldElems New  #   Syntax10.Scn.Fnt       
		VAR obj: OPT.Object;
	BEGIN
		OPS.name := typ.strobj.name; m.scope := m.right;
		OPT.FindImport(m, obj);
		IF obj # NIL THEN typ := obj.typ
		ELSE Out.String(OPS.name); Out.String(" not found in module "); Out.String(m.name); Out.Ln; OPM.noerr := FALSE
		END
	END ChangeTyp; 8   !    8   #   Syntax10.Scn.Fnt         typ.mno >= 2Syntax10i.Scn.Fnt      8       8   #   Syntax10.Scn.Fnt         typ.txtpos > run     8   	    8   #   Syntax10.Scn.Fnt         typ.txtpos := run; 	    8   <   k  
	VAR x: OPT.Object;
	
	PROCEDURE ChangeTyp (VAR typ: OPT.Struct; m: OPT.Object);	
	
BEGIN
	IF typ # NIL THEN
		IF typ was imported THEN
			IF (run = -2) & (OPT.GlbMod[typ.mno-1].link # NIL) THEN
				ChangeTyp(typ, OPT.GlbMod[typ.mno-1].link)
			END
		ELSIF typ not yet visited THEN
			visit typ
			IF typ.mno = 1 THEN typ.mno := 0 END;
			CASE typ.comp OF
				Basic:
			|  Array, DynArr: AdjustTyp(typ.BaseTyp)
			|  Record: AdjustTyp(typ.BaseTyp); AdjustObj(typ.link)
			END;
			IF typ.form = ProcTyp THEN x := typ.link;
				WHILE x # NIL DO AdjustTyp(x.typ); x := x.link END
			END
		END
	END
END AdjustTyp;
 8   (    ,8   #   Syntax10.Scn.Fnt       
	VAR x: OPT.Object; vis: SHORTINT;
BEGIN
	IF obj # NIL THEN
		AdjustObj(obj.left); AdjustObj(obj.right);
		CASE obj.mode OF
		   Con: vis := -external
		| Var, Fld, Typ: vis := -obj.vis; AdjustTyp(obj.typ)	
		| XProc, TProc:
			vis := -external;
			x := obj.link;
			WHILE x # NIL DO AdjustTyp(x.typ); x := x.link END
		ELSE
		END;
		IF run = -1 THEN obj.vis := vis ELSIF obj.vis < 0 THEN obj.vis := internal END
	END
END AdjustObj;
 8   '    H8   #   Syntax10.Scn.Fnt         
	VAR obj: OPT.Object;
BEGIN
	OPT.Find(obj);
	IF obj = NIL THEN Err(400); typ := OPT.undftyp
	ELSE obj.vis := -obj.vis; typ := obj.typ
	END
END Mark;
 8   >    8   #   Syntax10.Scn.Fnt         
	VAR obj, x: OPT.Object;
BEGIN
	IF typ # OPT.undftyp THEN
		OPT.FindField(OPS.name, typ, obj);
		IF obj = NIL THEN Err(400); typ1 := OPT.undftyp
		ELSE obj.vis := -obj.vis; typ1 := obj.typ
		END
	ELSE typ1 := OPT.undftyp
	END
END MarkField;
 8   "    8     Syntax10.Scn.Fnt  m    m8  FoldElems New  #   Syntax10.Scn.Fnt  q    q   j := 0; oldM := 0;
		WHILE j < newM DO
			IF OPT.GlbMod[j].name = imp.old[i] THEN oldM := j END;
			INC(j)
		END;Syntax10i.Scn.Fnt  %    8       78   #   Syntax10.Scn.Fnt         
				if at all, the name of the reduced interface has to be written as an alias into
				the symbol file. This requires a modification of the compiler and the browser. 8         
	VAR i, j, oldM, newM: INTEGER; dummy: OPS.Name;
BEGIN
	FOR i := 0 TO imp.n - 1 DO
		newM := OPT.nofGmod;
		oldM := index of imp.old[i] in GlbMod
		IF oldM # 0 THEN
			OPT.GlbMod[oldM].name := "###";
			OPT.Import(imp.new[i], imp.new[i], dummy);
			IF OPM.noerr THEN
				OPT.GlbMod[oldM].link := OPT.GlbMod[newM]
				(*OPT.GlbMod[newM].name := imp.new[i] *)
			END
		ELSE Out.String("module "); Out.String(imp.old[i]); Out.String(" not found$"); OPM.noerr := FALSE
		END
	END
END LoadReducedInterfaces;
 8      Syntax10b.Scn.Fnt          8      Syntax10.Scn.Fnt  a   8  FoldElems New  #   Syntax10.Scn.Fnt         OPT.GlbMod[0].adrSyntax10i.Scn.Fnt      8   '     
	VAR sym, out, temp: ARRAY 32 OF CHAR; res, res0: INTEGER; r: Texts.Reader; newSF: BOOLEAN; v: Viewers.Viewer;
BEGIN
	In.Open; In.Name(out);
	IF ~ In.Done THEN out := "" END;
	v := Oberon.MarkedViewer();
	IF (v # NIL) & (v.dsc.next IS TextFrames.Frame) THEN
		Texts.OpenReader(r, v.dsc.next(TextFrames.Frame).text, 0);
		OPM.Init(r, Oberon.Log); OPS.Init; OPT.Init;
		OPT.OpenScope(0, NIL);
		imp.n := 0; run := -1;
		Parse;
		IF OPM.noerr THEN
			LoadReducedInterfaces;
			run := -2;
			AdjustObj(OPT.topScope.right);
			COPY(modName, sym); Strings.Append(".Sym", sym);
			COPY(modName, temp); Strings.Append(".Temp", temp);
			IF out = "" THEN COPY(modName, out); Strings.Append("1.Sym", out)
			ELSE Strings.Append(".Sym", out)
			END;
			IF OPM.noerr THEN
				Files.Rename(sym, temp, res0); ASSERT(res0 <= 2, 97);
				newSF := TRUE; OPT.Export(modName, newSF, key);
				IF out # sym THEN
					Files.Rename(sym, out, res); ASSERT(res <= 1, 98);
					IF res0 # 2 THEN Files.Rename(temp, sym, res); ASSERT(res <= 1, 99) END
				END;
				Out.String(out); Out.String(" generated$")
			END
		END
	ELSE Out.String("-- no interface viewer marked$")
	END
END Shrink;
 8       D  documentation
MODULE Interface;	(** HM /  **)
IMPORT Strings, Files, Viewers, Texts, TextFrames, Oberon, OPM := iOPM, OPS := iOPS, OPT := iOPT, In, Out;

CONST
	(* object modes *)	
	(* structure forms *)		
	(* visibility *)		
	(* tokens *)	

VAR
	sym: SHORTINT;
	modName: OPS.Name;
	run: INTEGER;	(*traversal number for AdjustObj and AdjustTyp*)
	imp: RECORD	(*mapping between old and new interface names*)
		n: INTEGER;
		old, new: ARRAY 16 OF OPS.Name
	END;

PROCEDURE ^AdjustObj (obj: OPT.Object);
PROCEDURE ^Mark (VAR typ: OPT.Struct);
PROCEDURE ^MarkField (typ: OPT.Struct; VAR typ1: OPT.Struct);

PROCEDURE Err (n: INTEGER);	
PROCEDURE Get;	
PROCEDURE Check (s: INTEGER);	
PROCEDURE SkipTo (s: INTEGER);	
PROCEDURE Type (typ: OPT.Struct);	
PROCEDURE Imports;	
PROCEDURE Parse;	

PROCEDURE AdjustTyp (VAR typ: OPT.Struct);	
PROCEDURE AdjustObj (obj: OPT.Object);	
PROCEDURE Mark (VAR typ: OPT.Struct);	
PROCEDURE MarkField (typ: OPT.Struct; VAR typ1: OPT.Struct);	
PROCEDURE LoadReducedInterfaces;	

PROCEDURE Shrink*;		

END Interface.Shrink Ref2
