L  Syntax10.Scn.Fnt        InfoElems Alloc  V   Syntax10.Scn.Fnt     z  StampElems Alloc 11 Dec 95  K      "Title": InfoElems - a new kind of text elements.
"Author": Christoph Steindl (CS)
"Abstract": AuthorElems are a new kind of text elements. They are like PopupElems
	and contain additional information about a text (like title, author, abstract, version,
	date of creation and date of most recent modification).
"Keywords": information about a document, information retrieval
"Version": 1.0
"From": 25 Oct 94
"Until": 
"Changes": 
"Hints": This text can again contain arbitrary text elements!
 f   Syntax10b.Scn.Fnt              2      MarkElems Alloc       F           Z            	     
  l     MODULE InfoElems; 

IMPORT Display, Viewers, Texts, TextFrames, PopupElems, Oberon;

VAR
	icon: Display.Pattern;

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (PopupElems.ElemDesc) END ;

PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);
	VAR e1: Elem;
BEGIN
	WITH e: Elem DO
		WITH m: Texts.CopyMsg DO
			IF m.e = NIL THEN NEW(e1); m.e := e1 END ;
			PopupElems.Handle(e, m)
		| m: Texts.IdentifyMsg DO
			m.mod := "InfoElems"; m.proc := "Alloc"
		| m: TextFrames.DisplayMsg DO
			IF m.prepare THEN
				e.W := 13 * TextFrames.Unit; e.H := LONG(TextFrames.menuH-1) * TextFrames.Unit;
			ELSE e.name := ""; PopupElems.Handle(e, m);
				Display.CopyPattern(Display.white, icon, m.X0+2, m.Y0+2, Display.paint)
			END
		ELSE PopupElems.Handle(e, m)
		END
	END
END Handle;

PROCEDURE Alloc*;
	VAR e: Elem;
BEGIN
	NEW(e); e.handle := Handle; Texts.new := e;
END Alloc;

PROCEDURE Insert*;
	VAR e: Elem; insert: TextFrames.InsertElemMsg; Wr: Texts.Writer; t, d: LONGINT;
BEGIN
	NEW(e); e.handle := Handle; e.name := ""; e.small := TRUE;
	e.menu := TextFrames.Text("");
	Texts.OpenWriter(Wr);
	Texts.WriteString(Wr, '"Title": no title'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Author": no name'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Abstract": no abstract'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Keywords": no keywords'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Version": no version'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"From": '); Oberon.GetClock(t, d); Texts.WriteDate(Wr, t, d); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Until": no date (use StampElems.Insert)'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Changes": no changes'); Texts.WriteLn(Wr);
	Texts.WriteString(Wr, '"Hints": This text can again contain arbitrary text elements!'); Texts.WriteLn(Wr);
	Texts.Append(e.menu, Wr.buf);
	PopupElems.MeasureMenu(e);
	insert.e := e; Viewers.Broadcast(insert)
END Insert;

PROCEDURE InitIcon;
	VAR line: ARRAY 11 OF SET;
BEGIN
	line[10] := {2..7};
	line[9] := {1, 8};
	line[8] := {0, 3..6, 9};
	line[7] := {0, 2, 7, 9};
	line[6] := {0, 2, 9};
	line[5] := {0, 2, 9};
	line[4] := {0, 2, 7, 9};
	line[3] := {0, 3..6, 9};
	line[2] := {1, 8};
	line[1] := {2..7};
	icon := Display.NewPattern(line, 12, 10);
END InitIcon;

BEGIN
	InitIcon;
END InfoElems.