#   Syntax10.Scn.Fnt  k
   k
  MODULE In;  (* HM 18 March 1994; mah Fehler in In.Char *)
IMPORT Display, Viewers, Texts, TextFrames, Oberon;

CONST
	inval* = Texts.Inval;
	name* = Texts.Name;
	string* = Texts.String;
	int* = Texts.Int;
	real* = Texts.Real;
	longReal* = Texts.LongReal;
	char* = Texts.Char;

VAR
	Done-: BOOLEAN;
	s: Texts.Scanner;
	text: Texts.Text;
	startpos: LONGINT;		(* reminder for In.char *)

PROCEDURE OpenText* (t: Texts.Text; pos: LONGINT);
BEGIN
	text := t; Texts.OpenScanner(s, t, pos); startpos := pos; Done := TRUE
END OpenText;

PROCEDURE Open*;
	VAR t: Texts.Text; beg, end, time: LONGINT; v: Viewers.Viewer; f: Display.Frame;
BEGIN
	OpenText(Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s);
	IF (s.class = Texts.Char) & (s.c = "^") THEN
		Oberon.GetSelection(t, beg, end, time);
		IF time > 0 THEN OpenText(t, beg) ELSE Done := FALSE END
	ELSIF (s.class = Texts.Char) & (s.c = "*") THEN
		v := Oberon.MarkedViewer();
		f := v.dsc;
		WHILE (f # NIL) & ((Oberon.Pointer.Y < f.Y) OR (Oberon.Pointer.Y >= f.Y + f.H)) DO f := f.next END ;
		IF (f # NIL) & (f IS TextFrames.Frame) THEN
			OpenText(f(TextFrames.Frame).text, 0)
		ELSE Done := FALSE
		END
	ELSE OpenText(Oberon.Par.text, Oberon.Par.pos)
	END
END Open;

PROCEDURE Next* (): INTEGER;
	VAR s1: Texts.Scanner;
BEGIN
	IF Done THEN
		Texts.OpenScanner(s1, text, Texts.Pos(s));
		Texts.Scan(s1); Done := s1.class # Texts.Inval; RETURN s1.class
	ELSE RETURN inval
	END ;
END Next;

PROCEDURE Int* (VAR n: INTEGER);
BEGIN
	IF Done THEN
		Texts.Scan(s);
		IF s.class = int THEN n := SHORT(s.i) ELSE n := 0; Done := FALSE END
	END
END Int;

PROCEDURE LongInt* (VAR n: LONGINT);
BEGIN
	IF Done THEN
		Texts.Scan(s);
		IF s.class = int THEN n := s.i ELSE n := 0; Done := FALSE END
	END
END LongInt;

PROCEDURE Real* (VAR r: REAL);
BEGIN
	IF Done THEN
		Texts.Scan(s);
		IF s.class = real THEN r := s.x ELSE r := 0; Done := FALSE END
	END
END Real;

PROCEDURE LongReal* (VAR r: LONGREAL);
BEGIN
	IF Done THEN
		Texts.Scan(s);
		IF s.class = Texts.LongReal THEN r := s.y ELSE r := 0; Done := FALSE END
	END
END LongReal;

PROCEDURE Char* (VAR ch: CHAR);
BEGIN
	IF Done THEN
		IF startpos = Texts.Pos (s) THEN Texts.Read (s, s.nextCh) END ;
		ch := s.nextCh; Done := ~s.eot;
		Texts.Read(s, s.nextCh)
	END
END Char;

PROCEDURE Name* (VAR name: ARRAY OF CHAR);
BEGIN
	IF Done THEN
		Texts.Scan(s);
		IF s.class = Texts.Name THEN COPY(s.s, name) ELSE COPY("", name); Done := FALSE END
	END
END Name;

PROCEDURE String* (VAR string: ARRAY OF CHAR);
BEGIN
	IF Done THEN
		Texts.Scan(s);
		IF s.class = Texts.String THEN COPY(s.s, string) ELSE COPY("", string); Done := FALSE END
	END
END String;

BEGIN
	Done := FALSE
END In.
