   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt          	    "   Syntax10i.Scn.Fnt  6                   U                        C           >             +   E  MODULE Generic;	(* Generic sample frame class MB/gri/mh 3.11.93 *)

	IMPORT Oberon, TextFrames, MenuViewers, Viewers, Display;

	TYPE
		Frame* = POINTER TO FrameDesc;
		FrameDesc* = RECORD (Display.FrameDesc)
			(* may have a model and/or view-specific attributes *)
		END ;

	PROCEDURE DrawContent* (X, Y, W, H: INTEGER);
		CONST w = 8;
		VAR i, j: INTEGER;
	BEGIN i := 0; j := W DIV w;
		WHILE i < j DO
			IF ODD(i) THEN Display.ReplConst(Display.black, X+i*w, Y, w, H, Display.replace)
			ELSE Display.ReplConst(i MOD 14 + 2, X+i*w, Y, w, H, Display.replace)
			END ;
			INC(i)
		END ;
		Display.ReplConst(Display.black, X+i*w, Y, W MOD w, H, Display.replace)
	END DrawContent;

	PROCEDURE Modify* (F: Frame; Y, H: INTEGER);
		VAR dH: INTEGER;
	BEGIN dH := H-F.H;
		IF dH > 0 THEN (* extend *)
			IF F.Y+F.H # Y+H THEN Display.CopyBlock(F.X, F.Y, F.W, F.H, F.X, Y+dH, Display.replace) END ;
			F.Y := Y; F.H := H; DrawContent(F.X, F.Y, F.W, dH)
		ELSIF dH < 0 THEN (* reduce *)
			IF F.Y+F.H # Y+H THEN Display.CopyBlock(F.X, F.Y-dH, F.W, H, F.X, Y, Display.replace) END ;
			F.Y := Y; F.H := H
		END
	END Modify;

	PROCEDURE Copy* (src, dst: Frame);
	BEGIN
		dst^ := src^;
	END Copy;

	PROCEDURE Handle* (f: Display.Frame; VAR Msg: Display.FrameMsg);
		VAR F, CopyOfF: Frame;
	BEGIN
		F := f(Frame);
		IF Msg IS Oberon.InputMsg THEN
			WITH Msg: Oberon.InputMsg DO
				IF Msg.id = Oberon.track THEN
					Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, Msg.X, Msg.Y);
				END
			END
		ELSIF Msg IS Oberon.CopyMsg THEN
			WITH Msg: Oberon.CopyMsg DO
				NEW(CopyOfF); Copy(F, CopyOfF); Msg.F := CopyOfF
			END
		ELSIF Msg IS MenuViewers.ModifyMsg THEN
			WITH Msg: MenuViewers.ModifyMsg DO Modify(F, Msg.Y, Msg.H) END
		(* ELSIF more messages, e.g. update messages from the model *)
		END
	END Handle;

	PROCEDURE Open*;
		VAR F: Frame; V: Viewers.Viewer; x, y: INTEGER;
	BEGIN
		Oberon.AllocateUserViewer(Oberon.Mouse.X, x, y);
		NEW(F); F.handle := Handle;
		V := MenuViewers.New(TextFrames.NewMenu("Generic.Open", "System.Close  System.Copy  System.Grow"),
					F, TextFrames.menuH, x, y)
	END Open;

END Generic.
