   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt  &    :   Syntax10b.Scn.Fnt      ,    P                MODULE Easter; (**  ww 14 Apr 92; dg 21 Apr 92 **)

	IMPORT Texts, Oberon;

	VAR w: Texts.Writer;

	PROCEDURE GetDate*(year: INTEGER; VAR day, month: INTEGER);
	(* Source: Knuth, The Art of Computer Programming, Vol. I,p.155, Algorithm E *)
		VAR g, c, x, z, d, e, n: INTEGER;
	BEGIN
		IF year <= 1582 THEN HALT(99) END;
		g := year MOD 19 + 1;
		c := year DIV 100 + 1;
		x := 3*c DIV 4 - 12; z := (8*c+5) DIV 25 - 5;
		d := 5*year DIV 4 - x - 10;
		e := (11*g+20+z-x) MOD 30;
		IF ((e=25) & (g>11)) OR (e=24) THEN INC(e) END;
		n := 44-e; IF n<21 THEN n := n+30 END;
		n := n+7-((d+n) MOD 7);
		IF n>31 THEN day := n-31; month := 4 ELSE day := n; month := 3 END
	END GetDate;

	PROCEDURE Of*;
		VAR text: Texts.Text; s: Texts.Scanner; beg, end, time: LONGINT; day, month: INTEGER;
	BEGIN
		Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s);
		IF (s.class = Texts.Char) & (s.line = 0) & (s.c = "^") THEN Oberon.GetSelection(text, beg, end, time);
			IF time > 0 THEN Texts.OpenScanner(s, text, beg); Texts.Scan(s) END
		END;
		WHILE (s.class = Texts.Int) & (s.i >= 1583) & (s.i <= 2299) DO GetDate(SHORT(s.i), day, month);
			Texts.WriteInt(w, day, 0);
			IF month = 3 THEN Texts.WriteString(w, " March ") ELSE Texts.WriteString(w, " April ") END;
			Texts.WriteInt(w, s.i, 0); Texts.WriteLn(w);
			Texts.Scan(s)
		END;
		Texts.Append(Oberon.Log, w.buf)
	END Of;

BEGIN Texts.OpenWriter(w);
END Easter.

Easter.Of 2001 2002 2003 2004 2005 ~
