  Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  5   5  (*-----------------------------------------------------
Counts lines, statements and characters in an Oberon-2 module

Count.Lines			(^ | * | filename {filename})
Count.Statements	(^ | * | filename {filename})
Count.Chars			(^ | * | filename {filename})
-----------------------------------------------------*)Syntax10i.Scn.Fnt  
    8     Syntax10b.Scn.Fnt      |       x   
       z  MODULE Count;
Documentation

IMPORT Oberon, Texts, TextFrames, Viewers, Out;

PROCEDURE Open(VAR t: Texts.Text; VAR s: Texts.Scanner);
	VAR v: Viewers.Viewer; beg, end, time: LONGINT;
BEGIN
	Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s);
	IF (s.class = Texts.Char) & (s.c = "^") THEN
		Oberon.GetSelection(t, beg, end, time);
		IF time >= 0 THEN
			Texts.OpenScanner(s, t, beg); Texts.Scan(s)
		END
	END;
	IF (s.class = Texts.Char) & (s.c = "*") THEN
		v := Viewers.This(Oberon.Pointer.X, Oberon.Pointer.Y);
		t := v.dsc.next(TextFrames.Frame).text
	ELSE t := NIL
	END
END Open;

PROCEDURE L(t: Texts.Text): LONGINT;
	VAR r: Texts.Reader; ch: CHAR; lines: LONGINT;
BEGIN
	Texts.OpenReader(r, t, 0); Texts.Read(r, ch); lines := 0;
	WHILE ch # 0X DO
		IF ch = 0DX THEN INC(lines) END;
		Texts.Read(r, ch)
	END;
	RETURN lines
END L;

PROCEDURE S(t: Texts.Text): LONGINT;
	VAR s: Texts.Scanner; n: INTEGER; count, empty: BOOLEAN;
BEGIN
	Texts.OpenScanner(s, t, 0); Texts.Scan(s); n := 0; count := FALSE;
	WHILE ~ s.eot DO
		IF (s.class = Texts.Char) & (s.c = ";") & count THEN
			INC(n); Texts.Scan(s);
			IF (s.class = Texts.Name) & ((s.s = "END") OR (s.s = "ELSE") OR (s.s = "ELSIF") OR (s.s = "UNTIL")) THEN DEC(n) END
		ELSIF (s.class = Texts.Name) & (s.s = "BEGIN") THEN
			Texts.Scan(s); count := s.s # "END"
		ELSIF (s.class = Texts.Name) & (s.s = "END") THEN
			IF count THEN INC(n) END;
			Texts.Scan(s);
			IF (s.class = Texts.Name) & (s.s # "END") & (s.s # "ELSE") & (s.s # "ELSIF") & (s.s # "UNTIL") THEN count := FALSE END
		ELSIF (s.class = Texts.Name) & ((s.s = "ELSE") OR (s.s = "ELSIF") OR (s.s = "UNTIL")) THEN
			IF count THEN INC(n) END;
			Texts.Scan(s)
		ELSE Texts.Scan(s)
		END
	END ;
	RETURN n
END S;

PROCEDURE Chars*;
	VAR s: Texts.Scanner; chars: LONGINT; t: Texts.Text; total: LONGINT;
BEGIN
	Open(t, s);
	IF t # NIL THEN
		Out.F("# chars$", t.len)
	ELSE
		total := 0; NEW(t);
		WHILE s.class = Texts.Name DO
			NEW(t); Texts.Open(t, s.s); INC(total, t.len);
			Out.String(s.s); Out.F("  # chars$", t.len);
			Texts.Scan(s)
		END ;
		Out.F("Total: # chars$", total)
	END
END Chars;

PROCEDURE Lines*;
	VAR s: Texts.Scanner; t: Texts.Text; lines, total: LONGINT;
BEGIN
	Open(t, s);
	IF t # NIL THEN
		Out.F("# lines$", L(t))
	ELSE
		total := 0; NEW(t);
		WHILE s.class = Texts.Name DO
			Texts.Open(t, s.s); lines := L(t); INC(total, lines);
			Out.String(s.s); Out.F(" # lines$", lines);
			Texts.Scan(s)
		END ;
		Out.F("Total: # lines$", total)
	END
END Lines;

PROCEDURE Statements*;
	VAR t: Texts.Text; s: Texts.Scanner; stats, total: LONGINT;
BEGIN
	Open(t, s);
	IF t # NIL THEN
		Out.F("# statements$", S(t))
	ELSE
		total := 0; NEW(t);
		WHILE s.class = Texts.Name DO
			Texts.Open(t, s.s); stats := S(t); INC(total, stats);
			Out.String(s.s); Out.F(" # statements$", stats);
			Texts.Scan(s)
		END ;
		Out.F("Total: # statements$", total)
	END
END Statements;

END Count.Lines *
