	  Syntax10.Scn.Fnt      H  InfoElems Alloc  V   Syntax10.Scn.Fnt  1   z  StampElems Alloc 21 Jan 98  0    b  "Title": BulletElems
"Author": Andreas Krumenacker
"Abstract":
	BulletElems is basicly a part of the Oberon-Web-Browser.
	It is imported by the module HTML and used there for the
	bullets of unordered lists. A bullet elem is printable.
"Keywords": bullets
"Version": no version
"From": 10 Apr 97
"Until": 
"Changes": no changes so far
"Hints": no hints
       BalloonElems Alloc  E  Syntax10.Scn.Fnt        BulletElems Alloc    =        =        P   Syntax10i.Scn.Fnt                                                                       +        #                 
                "        
        ,                                                                     -  "BulletElems"
	BulletElems is basicly a part of the Oberon-Web-Browser.
	It is imported by the module HTML and used there for the
	bullets of unordered lists. A bullet elem is printable.

"disc"
One of three shapes an Elem can have.
Appearance: 

"circle"
One of three shapes an Elem can have.
Appearance: 

"square"
One of three shapes an Elem can have.
Appearance: 

"Elem"
A printable bullet elem.

"shape"
The shape of a bullet Elem.
Possible shapes are:
	 disc 
	 circle
	 square

"Insert"
BulletElems.Insert	^ | shape
	Inserts a bullet elem with the specified shape
	at the caret position.
	Possible shapes are:
		 'disc'
		 'circle'
		 'square'

"New"
BulletElems.New (shape : INTEGER) : Elem;
	Returns a bullet elem with the specified shape.
	Possible shapes are:
		 disc 
		 circle
		 square
 ^    8  FoldElems New     Syntax10.Scn.Fnt  c   Syntax10b.Scn.Fnt                      
   Syntax10i.Scn.Fnt                     
	pixel = LONG(TextFrames.Unit);
	dispW = 12 * pixel; dispH = 11 * pixel;
	printSize = 7 * pixel;
	disc* = 0; circle* = 1; square* = 2;	(* shapes for bullets *)
	lastBullet = 2;	(* nr of last bullet *)
	 8       8     Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt          r8  FoldElems New  Q   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                  >   
	ElemDesc* = RECORD (Texts.ElemDesc)
		shape*: INTEGER;
	END; 8       #   
	Elem* = POINTER TO ElemDesc;	
	 8       w8   C   Syntax10.Scn.Fnt  '   Syntax10i.Scn.Fnt          G   
	icon: ARRAY 3 OF Display.Pattern;	(* x = 0, y = 3, w = 12, h = 8 *)
	 8   J    8   #   Syntax10.Scn.Fnt         
	VAR
		p: TextFrames.Parc;
		dsr, beg: LONGINT;
BEGIN
	IF t = NIL THEN
		IF fnt = NIL THEN dsr := 0 ELSE dsr := - fnt.minY * pixel END
	ELSE
		TextFrames.ParcBefore(t, pos, p, beg);
		dsr := p.dsr
	END;
	RETURN dsr
END Dsr; 8   M    8   #   Syntax10.Scn.Fnt         
	VAR
		center, offs: LONGINT;
BEGIN
	offs := Dsr(t, pos, fnt);
	IF fnt # NIL THEN
		center := ((fnt.height + fnt.minY) * pixel ) DIV 2;
		INC(offs, center - printSize DIV 2);
	END;
	RETURN SHORT(offs DIV TextPrinter.Unit)
END OffSet; 8   4    38   #   Syntax10.Scn.Fnt       
	VAR
		s, r, r1: INTEGER;
BEGIN
	s := printSize DIV TextPrinter.Unit; r := s DIV 2;
	INC(y0, offs);
	CASE e.shape OF
		disc :
			r1 := r; WHILE r1 > 0 DO Printer.Circle(x0+r, y0+r, r1); DEC(r1) END;
		| circle :
			Printer.Circle(x0+r, y0+r, r);
		| square :
			Printer.Line(x0, y0, x0+s, y0);
			Printer.Line(x0, y0, x0, y0+s);
			Printer.Line(x0+s, y0, x0+s, y0+s);
			Printer.Line(x0, y0+s, x0+s, y0+s)
	ELSE END
END Print; 8      Syntax10b.Scn.Fnt      )    N8   C   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt         p  
	VAR
		e1: Elem;
		dsr: INTEGER;
BEGIN
	WITH e: Elem DO
		WITH m: Texts.FileMsg DO
			IF m.id = Texts.load THEN Files.ReadInt(m.r, e.shape)
			ELSE	(* Texts.store *)
				Files.WriteInt(m.r, e.shape)
			END
		| m: Texts.CopyMsg DO
			NEW(e1); Texts.CopyElem(e, e1); e1.shape := e.shape; m.e := e1
		| m: Texts.IdentifyMsg DO
			m.mod := "BulletElems"; m.proc := "Alloc"
		| m: TextFrames.DisplayMsg DO
			IF ~m.prepare THEN
				IF m.frame = NIL THEN
					dsr := SHORT(Dsr(NIL, m.pos, m.fnt) DIV pixel)
				ELSE
					dsr := SHORT(Dsr(m.frame(TextFrames.Frame).text, m.pos, m.fnt) DIV pixel)
				END;
				Display.CopyPattern(m.col, icon[e.shape], m.X0, m.Y0+dsr, Display.paint)
			END
		| m: TextPrinter.PrintMsg DO
			IF m.prepare THEN e.W := printSize
			ELSE
				e.W := dispW;
				Print(e, m.X0, m.Y0, OffSet(Texts.ElemBase(e), m.pos, m.fnt))
			END
		ELSE
		END
	END
END Handle; 8               58   #   Syntax10.Scn.Fnt         
	VAR
		e: Elem;
BEGIN
	NEW(e); e.W := dispW; e.H := dispH; e.handle := Handle;
	IF shape > lastBullet THEN shape := lastBullet END;
	e.shape := shape; RETURN e
END New; 8               8   #   Syntax10.Scn.Fnt  M    M   
	VAR
		e: Elem;
BEGIN
	NEW(e); e.handle := Handle; Texts.new := e
END Alloc; 8              Syntax10i.Scn.Fnt  %        8   #   Syntax10.Scn.Fnt  ,   ,  
	VAR
		name : ARRAY 8 OF CHAR;
		shape: INTEGER;
		m: TextFrames.InsertElemMsg;
BEGIN
	shape := disc;
	In.Open; In.Name(name);
	IF In.Done THEN
		IF (name = "circle") THEN shape := circle
		ELSIF (name = "square") THEN shape := square
		END
	END;
	m.e := New(shape); Viewers.Broadcast(m)
END Insert; 8       88   #   Syntax10.Scn.Fnt       
	VAR
		line: ARRAY 9 OF SET;
BEGIN
	line[1] := {4..7};
	line[2] := {3..8};
	line[3] := {2..9};
	line[4] := {2..9};
	line[5] := {2..9};
	line[6] := {2..9};
	line[7] := {3..8};
	line[8] := {4..7};
	icon[disc] := Display.NewPattern(line, 12, 8);
	line[1] := {4..7};
	line[2] := {3, 8};
	line[3] := {2, 9};
	line[4] := {2, 9};
	line[5] := {2, 9};
	line[6] := {2, 9};
	line[7] := {3, 8};
	line[8] := {4..7};
	icon[circle] := Display.NewPattern(line, 12, 8);
	line[1] := {2..9};
	line[2] := {2, 9};
	line[3] := {2, 9};
	line[4] := {2, 9};
	line[5] := {2, 9};
	line[6] := {2, 9};
	line[7] := {2, 9};
	line[8] := {2..9};
	icon[square] := Display.NewPattern(line, 12, 8);
END InitIcons; 8       8   #   Syntax10.Scn.Fnt         
	InitIcons 8       O  MODULE BulletElems;		

IMPORT
	Files, Fonts, Display, Viewers, Texts, TextFrames, TextPrinter, Printer, In;

CONST	

TYPE	

VAR	

PROCEDURE Dsr (t: Texts.Text; pos: LONGINT; fnt: Fonts.Font) : LONGINT;	

PROCEDURE OffSet (t: Texts.Text; pos: LONGINT; fnt: Fonts.Font) : INTEGER;	

PROCEDURE Print (e: Elem; x0, y0, offs: INTEGER);	

PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);	

PROCEDURE New* (shape : INTEGER): Elem;	

PROCEDURE Alloc*;	

PROCEDURE Insert*;	(* "^" |  ("disc" | "circle" | "square") *)	

PROCEDURE InitIcons;	

BEGIN	
END BulletElems.