J  Syntax10.Scn.Fnt  )      StampElems Alloc 11 Dec 95    Syntax10b.Scn.Fnt              t   Syntax10i.Scn.Fnt            MarkElems Alloc       P           j                              &   
  MODULE AutoMenuElems; (* mah 18 Nov 94 / *)
(*------------------------------------------------------------------------------------
Automatically installs a TextFrame handler that searches for AutoMenuElems throughout its text and adds
these to its menu.
------------------------------------------------------------------------------------*)
IMPORT Display, Viewers, Texts, TextFrames, PopupElems, HandlerElems, MenuViewers;

CONST
	left =2; middle = 1; right = 0;
	cancel = {left, middle, right};

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (PopupElems.ElemDesc) done: BOOLEAN END ;

VAR
	SuperHandle: Display.Handler;
	w: Texts.Writer;

(*----- AutoMenu Elements -----*)

PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);
	VAR e1: Elem;
BEGIN
	WITH e: Elem DO
		WITH m: Texts.CopyMsg DO
			IF m.e = NIL THEN NEW(e1); e1.done := TRUE; m.e := e1 END ;
			PopupElems.Handle(e, m)
		| m: Texts.IdentifyMsg DO
			m.mod := "AutoMenuElems"; m.proc := "Alloc"
		ELSE PopupElems.Handle(e, m)
		END
	END
END Handle;

PROCEDURE Alloc*;
	VAR e: Elem;
BEGIN
	NEW(e); e.handle := Handle; e.done := FALSE; Texts.new := e
END Alloc;

PROCEDURE Insert*;
	VAR e: Elem; insert: TextFrames.InsertElemMsg;
BEGIN
	NEW(e); e.handle := Handle; e.name := "AutoMenu"; e.small := TRUE; e.done := TRUE;
	e.menu := TextFrames.Text(""); PopupElems.MeasureMenu(e);
	insert.e := e; Viewers.Broadcast(insert)
END Insert;

(*----- Frame -----*)

PROCEDURE CreateMenu (f: TextFrames.Frame; VAR r: Texts.Reader);
VAR written: BOOLEAN; copy: Texts.CopyMsg; e1: Elem; menu: Texts.Text; v: Viewers.Viewer; ch: CHAR;
BEGIN written := FALSE;
	REPEAT
		IF (r.elem IS Elem) & (~r.elem(Elem).done) THEN
			NEW(e1); copy.e := e1; PopupElems.Handle (r.elem, copy);
			Texts.WriteElem (w, e1);
			r.elem(Elem).done := TRUE;
			written := TRUE
		END ;
		Texts.ReadElem (r)
	UNTIL r.elem = NIL;
	IF written THEN
		v := Viewers.This (f.X, f.Y);
		menu := v.dsc(TextFrames.Frame).text;
		Texts.OpenReader(r, menu, menu.len - 1); Texts.Read(r, ch);
		IF ch = '!' THEN Texts.Insert (menu, menu.len-1, w.buf) ELSE Texts.Append (menu, w.buf) END
	END
END CreateMenu;

PROCEDURE FrameHandler* (f: Display.Frame; VAR m: Display.FrameMsg);
VAR r: Texts.Reader;
BEGIN
	WITH f: TextFrames.Frame DO
		WITH m: MenuViewers.ModifyMsg DO
			SuperHandle (f, m);
			Texts.OpenReader (r, f.text, 0); Texts.ReadElem (r);
			WHILE (r.elem # NIL) & ~(r.elem IS Elem) DO Texts.ReadElem (r) END ;
			IF (r.elem # NIL) & (r.elem(Elem).done = FALSE) THEN CreateMenu (f, r) END
		ELSE SuperHandle(f, m)
		END
	END
END FrameHandler;

BEGIN
	HandlerElems.SetHandler("AutoMenuElems.FrameHandler", FrameHandler, SuperHandle);
	Texts.OpenWriter(w)
END AutoMenuElems.