/  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt       I StampElems Alloc 17 Dec 98         Syntax10b.Scn.Fnt        MarkElems Alloc H  
    T    8  FoldElems New  }   8             +%      1    8      8  #   Syntax10.Scn.Fnt          outside AreaButton  >    8      8             K      )    8           v   8             ^5          8   ^    8             L          8   B    8             M          8   L   8       
  MODULE AreaButtonElems; (* CE  *)

IMPORT Elems, PanelElems, GU := GUtils, TextFrames, Display, Oberon, Texts, Viewers, Fonts, Input;

CONST
	ML = 2; MM = 1; MR = 0;
	DUnit = TextFrames.Unit;

PROCEDURE DrawPanel* (p : PanelElems.Panel; x, y, color: INTEGER; pressed : BOOLEAN; f : Display.Frame);
VAR h, w, X, Y, W, H : INTEGER;
BEGIN
	h := GU.Unit(p.H, TRUE); w := GU.Unit(p.W, TRUE);
	
	GU.Area(f, color, 12, x, y, w, h, GU.Unit(p.border, FALSE), TRUE, pressed);
	IF f # NIL THEN PanelElems.TruncateFrame(f(PanelElems.Frame), X, Y, W, H) END;
	PanelElems.DrawContents(p, f, x, y);
	IF f # NIL THEN PanelElems.SetFrameCoords(f(PanelElems.Frame), X, Y, W, H) END
END DrawPanel;

PROCEDURE FrameHandle* (f : Display.Frame; VAR msg : Display.FrameMsg);
VAR keysum : SET; fnt : Fonts.Font; col : SHORTINT; exec : Elems.ExecMsg; pressed : BOOLEAN;
X, Y : INTEGER;
BEGIN
	WITH f : PanelElems.Frame DO
		WITH msg : Oberon.InputMsg DO
			IF f.p.locked THEN
				IF (msg.id = Oberon.track) & (msg.keys = {MM}) THEN
					pressed := FALSE;
					keysum := msg.keys;
					Elems.GetLook(f.p, fnt, col);

					REPEAT
						Input.Mouse(msg.keys, X, Y); keysum := keysum + msg.keys;
						Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, X, Y);
						IF  (X < f.X) OR (X > f.X + f.W) OR (Y < f.Y) OR (Y > f.Y + f.H)  THEN
							IF pressed THEN
								pressed := FALSE; DrawPanel(f.p, f.x, f.y, col, FALSE, f)
							END
						ELSIF ~pressed THEN
							pressed := TRUE; DrawPanel(f.p, f.x, f.y, col, TRUE, f)
						END
					UNTIL msg.keys = {};
					
					DrawPanel(f.p, f.x, f.y, col, FALSE, f);
					IF pressed & ~(MR IN keysum) THEN
						exec.e := f.p;
						exec.x := msg.X; exec.y := msg.Y;
						exec.unload := ML IN keysum;
						exec.f := f;
						f.p.handle(f.p, exec)
					END
				ELSE
					PanelElems.FrameHandle(f, msg)
				END
			ELSE
				PanelElems.FrameHandle(f, msg)
			END
		ELSE
			PanelElems.FrameHandle(f, msg)
		END
	END
END FrameHandle;

PROCEDURE Handle* (p: Texts.Elem; VAR msg: Texts.ElemMsg);
VAR exec : Elems.ExecMsg;
BEGIN
	WITH p : PanelElems.Panel DO
		WITH msg : TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				p.sel := NIL;
				msg.elemFrame := PanelElems.OpenFrame(p, msg.frame, FrameHandle, msg.X0, msg.Y0,
																			SHORT(p.W DIV DUnit), SHORT(p.H DIV DUnit));
				DrawPanel(p, msg.X0, msg.Y0, msg.col, FALSE, msg.elemFrame)
			END
		| msg : Elems.ExecMsg DO
			IF msg.x >= 0 THEN Elems.Handle(p, msg) END; (* forget init cmd of a panel *)
		| msg : Texts.IdentifyMsg DO msg.mod := "AreaButtonElems"; msg.proc := "New"
		| msg : TextFrames.TrackMsg DO
			IF msg.frame = NIL THEN
				exec.e := p;
				exec.x := msg.X; exec.y := msg.Y;
				exec.unload := ML IN msg.keys;
				exec.f := NIL;
				p.handle(p, exec)
			ELSE
				PanelElems.Handle(p, msg)
			END
		ELSE
			PanelElems.Handle(p, msg)
		END
	END
END Handle;

PROCEDURE Init* (p : PanelElems.Panel);
BEGIN
	p.handle := Handle;
	p.border := 1;
	p.W := 100 * DUnit;
	p.H := 50 * DUnit;
END Init;

PROCEDURE New*; 
BEGIN PanelElems.New; Init(Texts.new(PanelElems.Panel));
END New;

PROCEDURE Insert*;
VAR m: TextFrames.InsertElemMsg; pos : LONGINT; t : Texts.Text; s : Texts.Scanner;
BEGIN
	New;
	Elems.GetPar(Texts.new(Elems.Elem), s);
	m.e := Texts.new; Viewers.Broadcast(m);
	t := Texts.ElemBase(Texts.new);
	IF t # NIL THEN pos := Texts.ElemPos(m.e); Texts.ChangeLooks(t, pos, pos + 1, {1}, Fonts.Default, 13, 0) END
END Insert;

END AreaButtonElems.