  Syntax10.Scn.Fnt       S I StampElems Alloc 11 Dec 95  y   Syntax10b.Scn.Fnt          8  FoldElems New     8              Syntax10i.Scn.Fnt  V        8       8      8   (    8       8   N    8       8   0    8       8   u   8               8      8               8      8               8      8               8      8               8      8   3            8   C   8               8      8         MODULE Util; (**)

IMPORT Display, Viewers, MenuViewers, TextFrames, Oberon, Texts, Strings, In, Out;

VAR
	w: Texts.Writer;

PROCEDURE FindChar*;	(*finds invisible characters*)
	VAR r: Texts.Reader; v: Viewers.Viewer; f: TextFrames.Frame; ch: CHAR; m: Oberon.ControlMsg; pos, len: LONGINT;
BEGIN
	v := Oberon.FocusViewer;
	IF (v # NIL) & (v IS MenuViewers.Viewer) THEN
		f := v.dsc.next(TextFrames.Frame); pos := f.carloc.pos; len := f.text.len;
		Texts.OpenReader(r, f.text, pos);
		WHILE pos < len DO
			Texts.Read(r, ch); INC(pos);
			IF ((ch < " ") & (ch # 0DX) & (ch # 9X)) OR (ch = 7FX) OR (ch > 85X) THEN
				Texts.WriteInt(w, ORD(ch), 0); Texts.WriteLn(w); Texts.Append(Oberon.Log, w.buf);
				m.id := Oberon.neutralize; f.handle(f, m); TextFrames.Show(f, pos-50); TextFrames.SetCaret(f, pos);
				RETURN
			END
		END ;
		TextFrames.RemoveCaret(f)
	END
END FindChar;

PROCEDURE ExtractLines*;	(** [ patternName | patternString | "^"] -- removes lines with pattern from marked viewer *)	
	VAR t: Texts.Text; r: Texts.Reader; pat, line: ARRAY 128 OF CHAR; ll: INTEGER;
		v: Viewers.Viewer; x, y: INTEGER; eof: BOOLEAN; out: TextFrames.Frame; pos: LONGINT;

	PROCEDURE GetPattern(VAR pat: ARRAY OF CHAR);	
		VAR s: Texts.Scanner; t: Texts.Text; beg, end, time: LONGINT;
	BEGIN
		Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s);
		IF (s.class = Texts.Char) & (s.c = "^") THEN
			Oberon.GetSelection(t, beg, end, time);
			IF time >= 0 THEN Texts.OpenScanner(s, t, beg); Texts.Scan(s) END
		END ;
		IF (s.class = Texts.Name) OR (s.class = Texts.String) THEN COPY(s.s, pat) ELSE pat[0] := 0X END
	END GetPattern;

	PROCEDURE GetText(VAR t: Texts.Text);	
	BEGIN
		v := Oberon.MarkedViewer();
		IF (v # NIL) & (v.dsc.next IS TextFrames.Frame) THEN t := v.dsc.next(TextFrames.Frame).text
		ELSE t := NIL
		END
	END GetText;

	PROCEDURE GetLine(VAR s: ARRAY OF CHAR; VAR ll: INTEGER; VAR eof: BOOLEAN);	
		VAR i: INTEGER; ch: CHAR;
	BEGIN i := 0;
		IF ~ eof THEN
			LOOP
				Texts.Read(r, ch); IF (ch = 0DX) OR (ch = 0X) THEN EXIT END ;
				s[i] := ch; INC(i)
			END ;
			eof := ch = 0X
		END ;
		s[i] := 0X; ll := i
	END GetLine;

	PROCEDURE WriteString (VAR s: ARRAY OF CHAR);	
		VAR i: INTEGER; ch: CHAR;
	BEGIN
		i := 0; ch := s[0];
		WHILE ch # 0X DO Texts.Write(w, ch); INC(i); ch := s[i] END
	END WriteString;


BEGIN
	GetPattern(pat); GetText(t);
	IF (pat # "") & (t # NIL) THEN
		out := TextFrames.NewText(TextFrames.Text(""), 0);
		Texts.OpenReader(r, t, 0); pos := 0; eof := FALSE;
		LOOP
			GetLine(line, ll, eof); IF eof & (ll = 0) THEN EXIT END ;
			IF (ll > 0) & Strings.Match(line, pat) THEN
				WriteString(line); Texts.WriteLn(w);
				Texts.Delete(t, pos, pos + ll + 1); Texts.OpenReader(r, t, pos)
			ELSE pos := pos + ll +1
			END
		END ;
		Oberon.AllocateUserViewer(0, x, y);
		v := MenuViewers.New(TextFrames.NewMenu(pat, "System.Close"), out, TextFrames.menuH, x, y);
		Texts.Append(out.text, w.buf)
	END
END ExtractLines;

PROCEDURE GetSelection* (VAR F: TextFrames.Frame);	
	VAR time: LONGINT; v: Viewers.Viewer; x: INTEGER; f: TextFrames.Frame;
BEGIN
	time := -1; x := 0; F := NIL;
	WHILE x < Display.Width DO
		v := Viewers.This(x, 0);
		WHILE v.state > 1 DO
			IF v.dsc.next IS TextFrames.Frame THEN
				f := v.dsc.next(TextFrames.Frame);
				IF (f.hasSel) & (f.time > time) THEN F := f; time := f.time END ;
			END ;
			v := Viewers.Next(v)
		END ;
		x := x + v.W
	END
END GetSelection;

PROCEDURE UmlautOM*;	
	VAR v: Viewers.Viewer; t: Texts.Text; r: Texts.Reader; ch: CHAR; pos: LONGINT;
BEGIN
	v := Viewers.This(Oberon.Pointer.X, Oberon.Pointer.Y);
	t := v.dsc.next(TextFrames.Frame).text;
	pos := 0; Texts.OpenReader(r, t, pos);
	LOOP Texts.Read(r, ch); INC(pos);
		IF ch = 0X THEN EXIT END ;
		CASE ORD(ch) OF
			128:
		| 129: Texts.Write(w, CHR(133))
		| 130: Texts.Write(w, CHR(134))
		| 131: Texts.Write(w, CHR(138))
		| 132: Texts.Write(w, CHR(154))
		| 133: Texts.Write(w, CHR(159))
		ELSE
		END ;
		IF w.buf.len > 0 THEN
			Texts.Delete(t, pos-1, pos); Texts.Insert(t, pos-1, w.buf); Texts.OpenReader(r, t, pos)
		END
	END
END UmlautOM;

PROCEDURE UmlautMO*;	
	VAR v: Viewers.Viewer; t: Texts.Text; r: Texts.Reader; ch: CHAR; pos: LONGINT;
BEGIN
	v := Viewers.This(Oberon.Pointer.X, Oberon.Pointer.Y);
	t := v.dsc.next(TextFrames.Frame).text;
	pos := 0; Texts.OpenReader(r, t, pos);
	LOOP Texts.Read(r, ch); INC(pos);
		IF ch = 0X THEN EXIT END ;
		CASE ORD(ch) OF
			128:
		| 133: Texts.Write(w, CHR(129))
		| 134: Texts.Write(w, CHR(130))
		| 138: Texts.Write(w, CHR(131))
		| 154: Texts.Write(w, CHR(132))
		| 159: Texts.Write(w, CHR(133))
		| 167: Texts.WriteString(w, "ss")
		ELSE
		END ;
		IF w.buf.len > 0 THEN
			Texts.Delete(t, pos-1, pos); Texts.Insert(t, pos-1, w.buf); Texts.OpenReader(r, t, pos)
		END
	END
END UmlautMO;

PROCEDURE UmlautMA*;	
	VAR v: Viewers.Viewer; t: Texts.Text; r: Texts.Reader; ch: CHAR; pos: LONGINT;
BEGIN
	v := Viewers.This(Oberon.Pointer.X, Oberon.Pointer.Y);
	t := v.dsc.next(TextFrames.Frame).text;
	pos := 0; Texts.OpenReader(r, t, pos);
	LOOP Texts.Read(r, ch); INC(pos);
		IF ch = 0X THEN EXIT END ;
		CASE ORD(ch) OF
			128:  Texts.WriteString(w, "Ae")
		| 133: Texts.WriteString(w, "Oe")
		| 134: Texts.WriteString(w, "Ue")
		| 138: Texts.WriteString(w, "ae")
		| 154: Texts.WriteString(w, "oe")
		| 159: Texts.WriteString(w, "ue")
		| 167: Texts.WriteString(w, "ss")
		ELSE
		END ;
		IF w.buf.len > 0 THEN
			Texts.Delete(t, pos-1, pos); Texts.Insert(t, pos-1, w.buf); Texts.OpenReader(r, t, pos)
		END
	END
END UmlautMA;

PROCEDURE CopyList*;	 (*CopyList "oldprefix" "newprefix" file1 file2 ~*)
	VAR s, from, to: ARRAY 32 OF CHAR; i: INTEGER;
BEGIN
	In.Open;
	In.String(from); In.String(to);
	WHILE In.Next() = In.name DO
		In.Name(s);
		Out.String(s); Out.String(" => ");
		i := 0; WHILE (from[i] = s[i]) & (from[i] # 0X) DO INC(i) END ;
		Out.String(to); WHILE s[i] # 0X DO Out.Char(s[i]); INC(i) END ;
		Out.Ln
	END
END CopyList;


BEGIN
	Texts.OpenWriter(w)
END Util.

PROCEDURE Reply*;	(*puts e-mail reply marks in front of every selected line*)
	VAR t: Texts.Text; beg, end, time: LONGINT; r: Texts.Reader; ch: CHAR;
BEGIN
	Oberon.GetSelection(t, beg, end, time);
	IF time > 0 THEN
		LOOP
			DEC(beg);
			IF beg < 0 THEN EXIT END ;
			Texts.OpenReader(r, t, beg); Texts.Read(r, ch);
			IF ch = 0DX THEN EXIT END
		END ;
		INC(beg);
		WHILE beg < end DO
			Texts.WriteString(w, "> "); Texts.Insert(t, beg, w.buf);
			INC(beg, 2); INC(end, 2); Texts.OpenReader(r, t, beg);
			REPEAT Texts.Read(r, ch); INC(beg) UNTIL (ch = 0DX) OR (beg >= end)
		END
	END
END Reply;

PROCEDURE LineLen*;	
	VAR v: Viewers.Viewer; t: Texts.Text; r: Texts.Reader; ch: CHAR; n, max: INTEGER;
BEGIN
	v := Viewers.This(Oberon.Pointer.X, Oberon.Pointer.Y);
	t := v.dsc.next(TextFrames.Frame).text;
	Texts.OpenReader(r, t, 0); n := 0; max := 0;
	LOOP
		Texts.Read(r, ch); IF ch = 0X THEN EXIT END ;
		IF ch = 0DX THEN IF n > max THEN max := n END ; n := 0
		ELSE INC(n)
		END
	END ;
	Out.F("# characters per line$", max)
END LineLen;

