4  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt  +          InfoElems Alloc     Syntax10.Scn.Fnt  =     StampElems Alloc 2 Sep 99  
   Syntax10b.Scn.Fnt              #        '            m  "Title": Unix
"Author": JT
"Abstract": Module Unix provides a system call interface to Sun-OS.
				Naming conventions:
					Procedure and Type-names always start with a capital letter.
					error numbers as defined in Unix
					other constants start with lower case letters
"Version": 5.3.90
"From":  5.3.90
"Until": 
"Changes": 
RLI, 20-09-1996: Added LockF for Mailer.Mod. Unfortunately, LockF is flock in Linux and has only two parameters, so Mailer.Mod had to be changed as well.
RLI, 08-09-1997: Windows-Like exception handling.
RLI, 16-02-1998: Trap Handler for bootup phase added.
RLI, 09-12-1998: Glibc adaptions         vp  VersionElems AllocBeg   #   Syntax10.Scn.Fnt         LinuxLibc6
LinuxLibc5LinuxLibc6 LinuxLibc6         LinuxLibc5 $   Syntax10i.Scn.Fnt         Libc5          p  VersionElems AllocEnd      "    !   Syntax10b.Scn.Fnt                              	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        $                                                                                                                                                                $                    #                                                             !                                                                                        "                                                                                                                                                                                                                               
        !                                                                                                                                #                                                                                                                        !                                
                            '            
                    
        /            	                             %                                                '                    '                    &                    *            	        *                                        '                                	                    	        .            
                                                        	        $            
        "            	                            $                                                                                '            
        #            
        %                                                $                    	    	                    	                
    	    (                    
    	    &                	                    	                    	    !            	    	                        
    	    &            
    	    '            
    	                
    	                
    	                
    	                        	    	    #                	                            	                                                	                    	    !                	    "                	                
    	                    	        	                p    #   Syntax10.Scn.Fnt         LinuxLibc6
LinuxLibc5LinuxLibc6 LinuxLibc6         LinuxLibc5 T  Syntax10b.Scn.Fnt     Syntax10.Scn.Fnt          
        
        
                                        
        
        
                
        
        
        
        
        
                            E  Status* = RECORD
		dev*: INTEGER;
		pad1*: INTEGER;
		ino*: LONGINT;
		mode*, nlink*, uid*, gid*, rdev*: INTEGER;
		pad2*: INTEGER;
		size*: LONGINT;
		blksize*, blocks*: LONGINT;
		atime*: LONGINT;
		unused1*: LONGINT;
		mtime*: LONGINT;
		unused2*: LONGINT;
		ctime*: LONGINT;
		unused3*, unused4*, unused5*: LONGINT
	END;               
        
                                                
        
        
                
        
        
        
        
        
                                p                                                               	                                                                                            	                                    
        	                                                                                                    p    #   Syntax10.Scn.Fnt         LinuxLibc6
LinuxLibc5LinuxLibc6 LinuxLibc6         LinuxLibc5 t   Syntax10b.Scn.Fnt     Syntax10.Scn.Fnt                  
        
            ]   Dirent* = RECORD
		ino*, off*: LONGINT;
		reclen*: INTEGER;
		name*: ARRAY 256 OF CHAR
	END;                       
        
    	    
                p                                       
                                                                                            	                                                                            '                        
        
        
                                
                                                
                                                
                                                                "                                 
    B                    K        #                                        1    .                I    .                1    /            	    E    /                A    -                )                    9    $                .                    4    ,                .                    9    ,                :    2                <    *                9    3                                                        ;    L                :    (                                    /                    A    .                A    /                )                    ,            
        
        :        J                                    1                    :    -                9    '            	    ?    2                :    0                #                    .    !                <    +                        
        X                        *                    F    B                0    '            	    ,    0                        
        \                                                    
        @                    3            
    O    3            
    I    1                *                    0    !            
    E    B            
    =    9                1                    3    #                g    [                )                
    7    B                B    8                B    9            
    7    B                7    (                /                     /    &            	    6    -            
    1    *                :    '                1                    :    3                @    5            
    *    !            
    =    7            
    =    7        	        
        H        J            	        
        H        J                    
        8        H            	        
        4                =    2                8    /                )                C    9                
        _            	        
        9            
        
        :                *    '                "        '        A            8  FoldElems New  M    8       8   #   Syntax10.Scn.Fnt         
	VAR len, s, dummy: LONGINT; c: CHAR;
BEGIN
	len := 0; s := SYSTEM.ADR(str);
	SYSTEM.GET(s + len, c);
	WHILE c # 0X DO INC(len); SYSTEM.GET(s + len, c); END;
	dummy := Write(2, s, len);
END Str; 8       8   #   Syntax10.Scn.Fnt  I    I   
	VAR s: ARRAY 2 OF CHAR;
BEGIN
	s[0] := ch; s[1] := 0X;
	Str(s)
END Ch;  8       t8   #   Syntax10.Scn.Fnt  j   j  
	VAR s: ARRAY 20 OF CHAR; i1, k: LONGINT;
BEGIN
	IF i = MIN(LONGINT) THEN s := "2147483648"; k := 10
	ELSE
		i1 := ABS(i);
		s[0] := CHR(i1 MOD 10 + ORD("0")); i1 := i1 DIV 10; k := 1;
		WHILE i1 > 0 DO s[k] := CHR(i1 MOD 10 + ORD("0")); i1 := i1 DIV 10; INC(k) END
	END ;
	IF i < 0 THEN s[k] := "-"; INC(k) END ;
	WHILE k > 0 DO  DEC(k); Ch(s[k]) END
END Int;  8       8   #   Syntax10.Scn.Fnt         
BEGIN
	Ch(0AX);
END Ln; 8   `       +    8   H    8   (    8       G    >   p    #   Syntax10.Scn.Fnt         LinuxLibc6
LinuxLibc5LinuxLibc6 LinuxLibc6         LinuxLibc5           (        *        *        *        +        (    +        p       +    8       8            *        *        *        *        +        (    +    H   K        |   I           M        J    M        {   K            K            G            K            V        F    O            K            M           8       Fh  MODULE Unix; 	(* Josef Templ, 5.3.90	SVR4 system calls *)   (* Libc6 *)

IMPORT SYSTEM, Kernel;

CONST

	(* various important constants *)

	stdin* = 0; stdout* = 1; stderr* = 2;


	(* error numbers *)

	EPERM* = 1; 	(* Not super-user *)
	ENOENT* = 2; 	(* No such file or directory *)
	ESRCH* = 3; 	(* No such process *)
	EINTR* = 4; 	(* interrupted system call *)
	EIO* = 5; 	(* I/O error *)
	ENXIO* = 6; 	(* No such device or address *)
	E2BIG* = 7; 	(* Arg list too long *)
	ENOEXEC* = 8; 	(* Exec format error *)
	EBADF* = 9; 	(* Bad file number *)
	ECHILD* = 10; 	(* No children *)
	EAGAIN* = 11; 	(* No more processes *)
	ENOMEM* = 12; 	(* Not enough core *)
	EACCES* = 13; 	(* Permission denied *)
	EFAULT* = 14; 	(* Bad address *)
	ENOTBLK* = 15; 	(* Block device required *)
	EBUSY* = 16; 	(* Mount device busy *)
	EEXIST* = 17; 	(* File exists *)
	EXDEV* = 18; 	(* Cross-device link *)
	ENODEV* = 19; 	(* No such device *)
	ENOTDIR* = 20; 	(* Not a directory *)
	EISDIR* = 21; 	(* Is a directory *)
	EINVAL* = 22; 	(* Invalid argument *)
	ENFILE* = 23; 	(* File table overflow *)
	EMFILE* = 24; 	(* Too many open files *)
	ENOTTY* = 25; 	(* Inappropriate ioctl for device *)
	ETXTBSY* = 26; 	(* Text file busy *)
	EFBIG* = 27; 	(* File too large *)
	ENOSPC* = 28; 	(* No space left on device *)
	ESPIPE* = 29; 	(* Illegal seek *)
	EROFS* = 30; 	(* Read only file system *)
	EMLINK* = 31; 	(* Too many links *)
	EPIPE* = 32; 	(* Broken pipe *)
	EDOM* = 33; 	(* Math arg out of domain of func *)
	ERANGE* = 34; 	(* Math result not representable *)
	ENOMSG* = 42; 	(* No message of desired type *)
	EIDRM* = 43; 	(* Identifier removed *)
	ECHRNG* = 44; 	(* Channel number out of range *)
	EL2NSYNC = 45; 	(* Level 2 not synchronized *)
	EL3HLT* = 46; 	(* Level 3 halted *)
	EL3RST* = 47; 	(* Level 3 reset *)
	ELNRNG* = 48; 	(* Link number out of range *)
	EUNATCH* = 49; 	(* Protocol driver not attached *)
	ENOCSI* = 50; 	(* No CSI structure available *)
	EL2HLT* = 51; 	(* Level 2 halted *)
	EDEADLK* = 35; 	(* Deadlock condition. *)
	ENOLCK* = 37; 	(* No record locks available. *)

	(* Convergent Error Returns *)
	EBADE* = 52; 	(* invalid exchange *)
	EBADR* = 53; 	(* invalid request descriptor *)
	EXFULL* = 54; 	(* exchange full *)
	ENOANO* = 55; 	(* no anode *)
	EBADRQC* = 56; 	(* invalid request code *)
	EBADSLT* = 57; 	(* invalid slot *)
	EDEADLOCK* = 58; 	(* file locking deadlock error *)

	EBFONT* = 59; 	(* bad font file fmt *)

	(* stream problems *)
	ENOSTR* = 60; 	(* Device not a stream *)
	ENODATA* = 61; 	(* no data (for no delay io) *)
	ETIME* = 62; 	(* timer expired *)
	ENOSR* = 63; 	(* out of streams resources *)

	ENONET* = 64; 	(* Machine is not on the network *)
	ENOPKG* = 65; 	(* Package not installed *)
	EREMOTE* = 66; 	(* The object is remote *)
	ENOLINK* = 67; 	(* the link has been severed *)
	EADV* = 68; 	(* advertise error *)
	ESRMNT* = 69; 	(* srmount error *)

	ECOMM* = 70; 	(* Communication error on send *)
	EPROTO* = 71; 	(* Protocol error *)
	EMULTIHOP* = 72; 	(* multihop attempted *)
	EBADMSG* = 74; 	(* trying to read unreadable message *)
	ENAMETOOLONG* = 36; 	(* path name is too long *)
	EOVERFLOW* = 75; 	(* value too large to be stored in data type *)
	ENOTUNIQ* = 76; 	(* given log. name not unique *)
	EBADFD* = 77; 	(* f.d. invalid for this operation *)
	EREMCHG* = 78; 	(* Remote address changed *)

	(* shared library problems *)
	ELIBACC* = 79; 	(* Can't access a needed shared lib. *)
	ELIBBAD* = 80; 	(* Accessing a corrupted shared lib. *)
	ELIBSCN* = 81; 	(* .lib section in a.out corrupted. *)
	ELIBMAX* = 82; 	(* Attempting to link in too many libs. *)
	ELIBEXEC* = 83; 	(* Attempting to exec a shared library. *)
	EILSEQ* = 84; 	(* Illegal byte sequence. *)
	ENOSYS* = 38; 	(* Unsupported file system operation *)
	ELOOP* = 40; 	(* Symbolic link loop *)
	ERESTART* = 85; 	(* Restartable system call *)
	ESTRPIPE* = 86; 	(* if pipe/FIFO, don't sleep in stream head *)
	ENOTEMPTY* = 39; 	(* directory not empty *)
	EUSERS* = 87; 	(* Too many users (for UFS) *)

	(* BSD Networking Software *)
	(* argument errors *)
	ENOTSOCK* = 88; 	(* Socket operation on non-socket *)
	EDESTADDRREQ* = 89; 	(* Destination address required *)
	EMSGSIZE* = 90; 	(* Message too long *)
	EPROTOTYPE* = 91; 	(* Protocol wrong type for socket *)
	ENOPROTOOPT* = 92; 	(* Protocol not available *)
	EPROTONOSUPPORT* = 93; 	(* Protocol not supported *)
	ESOCKTNOSUPPORT* = 94; 	(* Socket type not supported *)
	EOPNOTSUPP* = 95; 	(* Operation not supported on socket *)
	EPFNOSUPPORT* = 96; 	(* Protocol family not supported *)
	EAFNOSUPPORT* = 97; 	(* Address family not supported by *)
	(* protocol family *)
	EADDRINUSE* = 98; 	(* Address already in use *)
	EADDRNOTAVAIL* = 99; 	(* Can't assign requested address *)
	(* operational errors *)
	ENETDOWN* = 100; 	(* Network is down *)
	ENETUNREACH* = 101; 	(* Network is unreachable *)
	ENETRESET* = 102; 	(* Network dropped connection because *)
	(* of reset *)
	ECONNABORTED* = 103; 	(* Software caused connection abort *)
	ECONNRESET* = 104; 	(* Connection reset by peer *)
	ENOBUFS* = 105; 	(* No buffer space available *)
	EISCONN* = 106; 	(* Socket is already connected *)
	ENOTCONN* = 107; 	(* Socket is not connected *)
	(* XENIX has 135 - 142 *)
	ESHUTDOWN* = 108; 	(* Can't send after socket shutdown *)
	ETOOMANYREFS* = 109; 	(* Too many references: can't splice *)
	ETIMEDOUT* = 110; 	(* Connection timed out *)
	ECONNREFUSED* = 111; 	(* Connection refused *)
	EHOSTDOWN* = 112; 	(* Host is down *)
	EHOSTUNREACH* = 113; 	(* No route to host *)
	EWOULDBLOCK* = EAGAIN;
	EALREADY* = 114; 	(* operation already in progress *)
	EINPROGRESS* = 115; 	(* operation now in progress *)

	(* SUN Network File System *)
	ESTALE* = 116; 	(* Stale NFS file handle *)

	(* Linux *)
	EDOTDOT* = 73; 	(* RFS specific error *)
	EUCLEAN* = 117; 	(* Structure needs cleaning *)
	ENOTNAM* = 118; 	(* Not a XENIX named type file *)
	ENAVAIL* = 119; 	(* No XENIX semaphore available *)
	EISNAM* = 120; 	(* is a named type file *)
	EREMOTEIO* = 121; 	(* Remote I/O error *)
	EDQUOT* = 122; 	(* Quota exceeded *)


TYPE
	(* <sys/stat.h> *)
	Status* = RECORD
		dev*, devHi*: LONGINT;
		pad1*: INTEGER;
		ino*, mode*, nlink*, uid*, gid*, rdev*, rdevHi*: LONGINT;
		pad2*: INTEGER;
		size*: LONGINT;
		blksize*, blocks*: LONGINT;
		atime*: LONGINT;
		unused1*: LONGINT;
		mtime*: LONGINT;
		unused2*: LONGINT;
		ctime*: LONGINT;
		unused3*, unused4*, unused5*: LONGINT
	END ;

	(* <linux/time.h> *)
	Timeval* = RECORD
		sec*, usec*: LONGINT
	END ;

	(* <time.h> *)
	Time* = POINTER TO TimeDesc;
	TimeDesc* = RECORD
		sec*, min*, hour*, mday*, mon*, year*, wday*, yday*, isdst*: LONGINT
	END;

	(* <linux/time.h> *)
	Timezone* = RECORD
		minuteswest*, dsttime*: LONGINT
	END ;

	(* <linux/time.h> *)
	Itimerval* = RECORD
		interval*, value*: Timeval
	END ;

	(* <linux/times.h> *)
	Tms* = RECORD
		utime*, stime*, cutime*, cstime*: LONGINT
	END ;

	(* <linux/types.h> *)
	FdSet* = ARRAY 8 OF SET;

	(* <linux/dirent.h> *)
	Dirent* = RECORD
		fileno*, off*: LONGINT;
		reclen*: INTEGER;
		filetype*: CHAR;
		name*: ARRAY 256 OF CHAR
	END ;

	(* <linux/resource.h> *)
	Rusage* = RECORD
		utime*, stime*: Timeval;
		maxrss*, ixrss*, idrss*, isrss*,
		minflt*, majflt*, nswap*, inblock*,
		oublock*, msgsnd*, msgrcv*, nsignals*,
		nvcsw*, nivcsw*: LONGINT
	END ;

	(* <sys/uio.h> *)
	Iovec* = RECORD
		base*, len*: LONGINT
	END ;

	PipeFd* = ARRAY 2 OF LONGINT;

	(* trap handling, taken from Windows *)
	ExceptionRecord* = RECORD
		code*: LONGINT;
		flags*: LONGINT;
		excRec*: LONGINT;
		addr*: LONGINT
	END ;
	ContextRecord* = RECORD
		flags*: LONGINT;
		debRegs*: ARRAY 6 OF LONGINT;
		floatSaveArea*: ARRAY 112 OF CHAR;
		SegGs*, SegFs*, SegEs*, SegDs*: LONGINT;
		Edi*, Esi*, Ebx*, Edx*, Ecx*, Eax*: LONGINT;
		Ebp*, Eip*, SegCs*, EFlags*, Esp*, SegSs*: LONGINT
	END ;
	ExceptionInfo* = POINTER TO ExceptionPointers;
	ExceptionPointers* = RECORD
		exc*: POINTER TO ExceptionRecord;
		cont*: POINTER TO ContextRecord;
		sig*: LONGINT	(* signal number that raised the exception -- specific to Linux *)
	END ;

	TrapHandler* = PROCEDURE (p: ExceptionInfo): LONGINT;

VAR
	trapHandler: TrapHandler;
	Exit-: PROCEDURE ( status : LONGINT ); 	(* void exit( int status ) *)
	Fork-: PROCEDURE ( ) : LONGINT; 	(* int fork( ) *)
	Read-: PROCEDURE ( fd, adr, n : LONGINT ) : LONGINT; 	(* int read( int fd; char* buf; int nbyte ) *)
	ReadBlk-: PROCEDURE ( fd : LONGINT; VAR blk : ARRAY OF SYSTEM.BYTE ) : LONGINT; 	(* int read( int fd; char* buf; int nbyte ) *)
	Write-: PROCEDURE ( fd, adr, n : LONGINT ) : LONGINT; 	(* int write( int fd; char* buf; int nbyte ) *)
	WriteBlk-: PROCEDURE ( fd : LONGINT; blk : ARRAY OF SYSTEM.BYTE ) : LONGINT; 	(* int write( int fd; char* buf; int nbyte ) *)
	Open-: PROCEDURE ( nameadr : LONGINT; flags, mode : SET ) : LONGINT; 	(* int open( char* path; int flags, mode ) *)
	Close-: PROCEDURE ( fd : LONGINT ) : LONGINT; 	(* int close( int fd ) *)
	Link-: PROCEDURE ( name1adr, name2adr : LONGINT ) : LONGINT; 	(* int link( char* path1, path2 ) *)
	Unlink-: PROCEDURE ( nameadr : LONGINT ) : LONGINT; 	(* int unlink( char* path ) *)
	Execv-: PROCEDURE ( nameadr, argv : LONGINT ) : LONGINT; 	(* int execv( char* path; char* argv[ ] ) *)
	Chdir-: PROCEDURE ( nameadr : LONGINT ) : LONGINT; 	(* int chdir( char* path ) *)
	Mknod-: PROCEDURE ( nameadr, mode, dev : LONGINT ) : LONGINT; 	(* int mknod( char* path; int mode, dev ) *)
	Chmod-: PROCEDURE ( nameadr : LONGINT; mode : SET ) : LONGINT; 	(* int chmod( char* path; unsigned short mode ) *)
	Chown-: PROCEDURE ( nameadr, owner, group : LONGINT ) : LONGINT; 	(* int ( char* path; int owner, group ) *)
	Lseek-: PROCEDURE ( fd, offset, origin : LONGINT ) : LONGINT; 	(* long lseek( int fd; long offset; int whence ) *)
	Getpid-: PROCEDURE ( ) : LONGINT; 	(* int getpid( ) *)
	Getuid-: PROCEDURE ( ) : LONGINT; 	(* int getuid( ) *)
	Ptrace-: PROCEDURE ( cmd, pid, addr, data : LONGINT ) : LONGINT;
	(* int ptrace( long request; int pid; char *addr; int data; char *addr2 ) *)
	Access-: PROCEDURE ( nameadr : LONGINT; mode : SET ) : LONGINT; 	(* int access( char* path; int mode ) *)
	Sync-: PROCEDURE; 	(* void sync( ) *)
	Kill-: PROCEDURE ( pid, sig : LONGINT ) : LONGINT; 	(* int kill( int pid, sig ) *)
	Stat-: PROCEDURE ( nameadr : LONGINT; statbuf : LONGINT ) : LONGINT; 	(* int stat( char* path; struct stat* buf ) *)
	Lstat-: PROCEDURE ( nameadr : LONGINT; statbuf : LONGINT ) : LONGINT; 	(* int lstat( char* path; struct stat* buf ) *)
	Dup-: PROCEDURE ( fd : LONGINT ) : LONGINT; 	(* int dup( int fd ) *)
	Pipe-: PROCEDURE ( VAR fd : PipeFd ) : LONGINT; 	(* int pipe( int fd[2] ) *)
	(*  Profil-: PROCEDURE ( bufadr, bufsize, offset, scale : LONGINT ) : LONGINT; *) (* int profil( short* buf; int bufsize; void ( *offset)( ); int scale ) *)
	Getgid-: PROCEDURE ( ) : LONGINT; 	(* int getgid( ) *)
	Acct-: PROCEDURE ( path : ARRAY OF CHAR ) : LONGINT; 	(* int acct( char* path ) *)
	Ioctl-: PROCEDURE ( fd, request, argadr : LONGINT ) : LONGINT; 	(* int ioctl( int fd, request; char* arg ) *)
	Symlink-: PROCEDURE ( name1adr, name2adr : LONGINT ) : LONGINT; 	(* int symlink( char* name1, name2 ) *)
	Readlink-: PROCEDURE ( pathadr, bufadr, bufsize : LONGINT ) : LONGINT; 	(* int readlink( char* path, *buf; int bufsiz ) *)
	Execve-: PROCEDURE ( pathadr, argv, envp : LONGINT ) : LONGINT; 	(* int execve( char* path, argv[ ], envp[ ] ) *)
	Umask-: PROCEDURE ( mask : SET ) : SET; 	(* int umask( int mask ) *)
	Chroot-: PROCEDURE ( nameadr : LONGINT ) : LONGINT; 	(* int chroot( char* dirname ) *)
	Fstat-: PROCEDURE ( fd : LONGINT; statbuf : LONGINT ) : LONGINT; 	(* int fstat( int fd; struct stat *buf ) *)
	(*
	Msync-: PROCEDURE ( addr, len, flags : LONGINT ) : LONGINT;	(* int msync( char* addr; int len, flags ) *)
	*)
	Sbrk-: PROCEDURE ( inc : LONGINT ) : LONGINT; 	(* char* sbrk( int incr ) *)
	Mmap-: PROCEDURE ( addr, len, prot, flags, fd, off : LONGINT ) : LONGINT;
	(* char* mmap( char* addr; int len, prot, flags, fd; long off ) *)
	Munmap-: PROCEDURE ( addr, len : LONGINT ) : LONGINT; 	(* int munmap( char* addr; int len ) *)
	Mprotect-: PROCEDURE ( addr, len, prot : LONGINT ); 	(* void mprotect( char* addr; int len, prot ) *)
	(*
	Madvise-: PROCEDURE ( addr, len, advise : LONGINT ) : LONGINT;	(* int madvise( char* addr; int len, advise ) *)
	*)
	Vhangup-: PROCEDURE; 	(* void vhangup( ) *)
	(*
	Mincore-: PROCEDURE ( addr, len : LONGINT; VAR vec : ARRAY OF SHORTINT ) : LONGINT;
	*)
	(* int mincore( char* addr; int len; char* vec ) *)
	Getgroups-: PROCEDURE ( gidsetlen : LONGINT; VAR gidset : ARRAY OF LONGINT ) : LONGINT;
	(* int getgroups( int gidsetlen; int gidset[ ] ) *)
	Setgroups-: PROCEDURE ( ngroups : LONGINT; gidset : ARRAY OF LONGINT ) : LONGINT; 	(* int setgroups( int ugroups; int gidset[ ] ) *)
	Getpgrp-: PROCEDURE ( pid : LONGINT ) : LONGINT; 	(* int getgrp( int pid ) *)
	Setpgrp-: PROCEDURE ( pid, pgrp : LONGINT ) : LONGINT; 	(* int setgrp( int pid, pgrp ) *)
	Setitimer-: PROCEDURE ( which : LONGINT; value, ovalue : LONGINT ) : LONGINT;
	(* int setitimer( int which; struct itimerval *value, *ovalue ) *)
	Getitimer-: PROCEDURE ( which : LONGINT; value : LONGINT ) : LONGINT; 	(* int getitimer( int which; struct itimerval *value ) *)
	Dup2-: PROCEDURE ( oldd, newd : LONGINT ) : LONGINT; 	(* int dup2( int fd1, fd2 ) *)
	Fcntl-: PROCEDURE ( fd, cmd, arg : LONGINT ) : LONGINT; 	(* int fcntl( int fd, cmd, arg ) *)
	Select-: PROCEDURE ( width : LONGINT; readfds, writefds, exceptfds : LONGINT; timeout : LONGINT ) : LONGINT;
	(* int select( int width; fdset* readfds, writefds, exceptfds; struct timeval *timeout ) *)
	Fsync-: PROCEDURE ( fd : LONGINT ) : LONGINT; 	(* int fsync( int fd ) *)
	Gettimeofday-: PROCEDURE ( tv : LONGINT; tz : LONGINT ) : LONGINT; 	(* int gettimeofday( struct timeval *tp; struct timezone *tzp ) *)
	Readv-: PROCEDURE ( d : LONGINT; VAR iov : ARRAY OF Iovec ) : LONGINT; 	(* int readv( int fd; struct iovec *iov; int iovcnt ) *)
	Writev-: PROCEDURE ( d : LONGINT; VAR iov : ARRAY OF Iovec ) : LONGINT; 	(* int writev( int fd; struct iovec *iov; int iovcnt ) *)
	Settimeofday-: PROCEDURE ( tv : LONGINT; tz : LONGINT ) : LONGINT; 	(* int settimeofday( struct timeval *tp; struct timezone *tzp ) *)
	Fchown-: PROCEDURE ( fd, owner, group : LONGINT ) : LONGINT; 	(* int fchown( int fd, owner, group ) *)
	Fchmod-: PROCEDURE ( fd, mode : LONGINT ) : LONGINT; 	(* int fchmod( int fd, mode ) *)
	Rename-: PROCEDURE ( from, to : LONGINT ) : LONGINT; 	(* int rename( char* path1, path2 ) *)
	Truncate-: PROCEDURE ( nameadr, length : LONGINT ) : LONGINT; 	(* int truncate( char* path; long length ) *)
	Ftruncate-: PROCEDURE ( fd, length : LONGINT ) : LONGINT; 	(* int ftruncate( int fd; long length ) *)
	Mkdir-: PROCEDURE ( nameadr : LONGINT; mode : SET ) : LONGINT; 	(* int mkdir( char* path; int mode ) *)
	Rmdir-: PROCEDURE ( path : ARRAY OF CHAR ) : LONGINT; 	(* int rmdir( char* path ) *)
	Utimes-: PROCEDURE ( file : LONGINT; tvp : LONGINT ) : LONGINT; 	(* int utimes( char* file; struct timeval *tvp ) *)
	Adjtime-: PROCEDURE ( delta : LONGINT; olddelta : LONGINT ) : LONGINT; 	(* int adjtime( struct timeval *delta, *olddelta ) *)
	Localtime-:  PROCEDURE ( clock : LONGINT ) : Time; 	(* struct time* ( long clock ) *)
	Getrlimit-: PROCEDURE ( resource : LONGINT; rl : LONGINT ) : LONGINT; 	(* int getrlimit( int resource; struct rlimit *rlp ) *)
	Setrlimit-: PROCEDURE ( resource : LONGINT; rl : LONGINT ) : LONGINT; 	(* int setrlimit( int resource; struct rlimit *rlp ) *)
	(* Getmsg-: PROCEDURE ( fd : LONGINT; ctlptr, dataptr : LONGINT; flags : LONGINT ) : LONGINT;
	(* int getmsg( int fd; struct strbuf *ctlptr, *dataptr; int *flags ) *) *)
	(* Putmsg-: PROCEDURE ( fd : LONGINT; ctlptr, dataptr : LONGINT; flags : LONGINT ) : LONGINT;
	(* int putmsg( int fd; struct strbuf *ctlptr, *dataptr; int *flags ) *) *)
	(* Poll-: PROCEDURE ( fds : ARRAY OF Pollfd; timeout : LONGINT ) : LONGINT;
	(* int poll( struct pollfd *fds; unsigned long nfds; int timeout ) *) *)
	(* Nfssvc-: PROCEDURE ( sock : LONGINT );	(* void nfssvc( int sock ) *) *)
	Statfs-: PROCEDURE ( pathadr : LONGINT; buf : LONGINT ) : LONGINT; 	(* int statfs( char* path; struct statfs *buf ) *)
	Fstatfs-: PROCEDURE ( fd : LONGINT; buf : LONGINT ) : LONGINT; 	(* int fstatfs( int fd; struct statfs *buf ) *)
	(* Asyncdaemon-: PROCEDURE;	(* void async_daemon( ) *) *)
	Mount-: PROCEDURE ( typeadr, diradr, flags, data : LONGINT ) : LONGINT; 	(* int mount( char* type, dir; int flags; char* data ) *)
	(* Getdents-: PROCEDURE ( fd, buf, nbytes : LONGINT ) : LONGINT;	(* int getdents( int fd; char* buf; int nbytes ) *) *)
	(* Fchdir-: PROCEDURE ( fd : LONGINT ) : LONGINT;	(* int fchdir( int fd ) *) *)
	(* Fchroot-: PROCEDURE ( fd : LONGINT ) : LONGINT;	(* int fchroot( int fd ) *) *)
	Times-: PROCEDURE (buffer: LONGINT) : LONGINT; 	(* clock_t times(struct tms *buffer) *)

	System-: PROCEDURE (cmd, len: LONGINT);
	Sysconf-: PROCEDURE (name: LONGINT): LONGINT;
	LockF-: PROCEDURE (fd, function: LONGINT);

	errp: LONGINT;

PROCEDURE Errno* (): LONGINT; 
	VAR errno: LONGINT;
BEGIN SYSTEM.GET(errp, errno); RETURN errno
END Errno; 

PROCEDURE BootTrapHandler (exInfo: ExceptionInfo): LONGINT;
	VAR pc, bp, sp, trapno: LONGINT;

PROCEDURE Str (str: ARRAY OF CHAR); 

PROCEDURE Ch (ch: CHAR); 

PROCEDURE Int (i: LONGINT); 

PROCEDURE Ln;

BEGIN
	pc := exInfo.cont.Eip; bp := exInfo.cont.Ebp; sp := exInfo.cont.Esp; trapno := exInfo.cont.Eax;
	IF pc = 0 THEN (* assume call of procedure variable with value NIL *)
		SYSTEM.GET(sp, pc) (* get return address on top of stack *)
	END;
	Str("Trap ");
	CASE exInfo.sig OF
	| 2: Str("  (INTERRUPT)");
	| 4: (* Illegal Instruction => Oberon traps *)
		Int(trapno);
		CASE trapno OF
		|  0: Str("  (ASSERT failed)");
		|  1: Str("  (Heap overflow)");
		| 15: Str("  (invalid case in WITH statement)");
		| 16: Str("  (invalid case in CASE statement)");
		| 17: Str("  (function procedure with no return value)");
		| 18: Str("  (type guard check)");
		| 19: Str("  (implicit type guard check in record assignment)");
		| 20: Str("  (integer overflow)");
		| 21: Str("  (range overflow)");
		| 22: Str("  (dimension trap)")
		ELSE
			IF trapno >= 30 THEN Str("  (programmed HALT)")
			ELSE Str("  (unknown trap)")
			END
		END;
	| 8: Str("  (ARITHMETIC EXCEPTION)");
	| 11: Str("  (SEGMENTATION VIOLATION)")
	ELSE
		Str("  (SIGNAL "); Int(exInfo.sig); Str(") ")
	END;

	Ln;
	Exit(-1);
END BootTrapHandler;

PROCEDURE InstallTrapHandler* (new: TrapHandler; VAR old: TrapHandler); 
BEGIN
	old := trapHandler;
	trapHandler := new
END InstallTrapHandler; 

PROCEDURE TrapManager (sig: LONGINT); 
	(* Gets machine state and calls installed Trap-Handler RLI, 22 Aug 97*)
	VAR p: ExceptionInfo; actbp: LONGINT; dummy: LONGINT; 
BEGIN
	NEW(p); NEW(p.cont); NEW(p.exc);
	p.sig := sig;
	SYSTEM.GETREG(5, actbp);
	SYSTEM.GET(actbp + 4 * 3, p.cont.SegGs);
	SYSTEM.GET(actbp + 4 * 4, p.cont.SegFs);
	SYSTEM.GET(actbp + 4 * 5, p.cont.SegEs);
	SYSTEM.GET(actbp + 4 * 6, p.cont.SegDs);
	SYSTEM.GET(actbp + 4 * 7, p.cont.Edi);
	SYSTEM.GET(actbp + 4 * 8, p.cont.Esi);
	SYSTEM.GET(actbp + 4 * 9, p.cont.Ebp);
	SYSTEM.GET(actbp + 4 * 11, p.cont.Ebx);
	SYSTEM.GET(actbp + 4 * 12, p.cont.Edx);
	SYSTEM.GET(actbp + 4 * 13, p.cont.Ecx);
	SYSTEM.GET(actbp + 4 * 14, p.cont.Eax);
	SYSTEM.GET(actbp + 4 * 17, p.cont.Eip);
	SYSTEM.GET(actbp + 4 * 18, p.cont.SegCs);
	SYSTEM.GET(actbp + 4 * 19, p.cont.EFlags);
	SYSTEM.GET(actbp + 4 * 20, p.cont.Esp);
	SYSTEM.GET(actbp + 4 * 21, p.cont.SegSs);
	p.exc.addr := p.cont.Eip;
	Kernel.InstallSignal(2, TrapManager); 		(* keyboard interrupt *)
	Kernel.InstallSignal(4, TrapManager); 		(* illegal instruction *)
	Kernel.InstallSignal(8, TrapManager); 		(* arithmetic error *)
	Kernel.InstallSignal(11, TrapManager);  	(* segmentation violation *)
	Kernel.InstallSignal(13, TrapManager);  	(* unconnected pipe *)
	Kernel.InstallSignal(15, TrapManager);		(* terminate, used for threads killing *)

	dummy := trapHandler (p)
END TrapManager; 

BEGIN
	(* --- new exception handling *)
	Kernel.InstallSignal(2, TrapManager); 		(* keyboard interrupt *)
	Kernel.InstallSignal(4, TrapManager); 		(* illegal instruction *)
	Kernel.InstallSignal(8, TrapManager); 		(* arithmetic error *)
	Kernel.InstallSignal(11, TrapManager);  	(* segmentation violation *)
	Kernel.InstallSignal(13, TrapManager);  	(* unconnected pipe *)
	Kernel.InstallSignal(15, TrapManager);		(* terminate, used for threads killing *)
	trapHandler := BootTrapHandler;

	Kernel.dlsym(Kernel.libc, "errno", errp);
	Kernel.dlsym( Kernel.libc, "exit", SYSTEM.VAL( LONGINT, Exit ) );
	Kernel.dlsym( Kernel.libc, "fork", SYSTEM.VAL( LONGINT, Fork ) );
	Kernel.dlsym( Kernel.libc, "read", SYSTEM.VAL( LONGINT, Read ) );
	Kernel.dlsym( Kernel.libc, "read", SYSTEM.VAL( LONGINT, ReadBlk ) );
	Kernel.dlsym( Kernel.libc, "write", SYSTEM.VAL( LONGINT, Write ) );
	Kernel.dlsym( Kernel.libc, "write", SYSTEM.VAL( LONGINT, WriteBlk ) );
	Kernel.dlsym( Kernel.libc, "open", SYSTEM.VAL( LONGINT, Open ) );
	Kernel.dlsym( Kernel.libc, "close", SYSTEM.VAL( LONGINT, Close ) );
	Kernel.dlsym( Kernel.libc, "link", SYSTEM.VAL( LONGINT, Link ) );
	Kernel.dlsym( Kernel.libc, "unlink", SYSTEM.VAL( LONGINT, Unlink ) );
	Kernel.dlsym( Kernel.libc, "execv", SYSTEM.VAL( LONGINT, Execv ) );
	Kernel.dlsym( Kernel.libc, "chdir", SYSTEM.VAL( LONGINT, Chdir ) );
	Kernel.dlsym( Kernel.libc, "mknod", SYSTEM.VAL( LONGINT, Mknod ) );
	Kernel.dlsym( Kernel.libc, "chmod", SYSTEM.VAL( LONGINT, Chmod ) );
	Kernel.dlsym( Kernel.libc, "chown", SYSTEM.VAL( LONGINT, Chown ) );
	Kernel.dlsym( Kernel.libc, "lseek", SYSTEM.VAL( LONGINT, Lseek ) );
	Kernel.dlsym( Kernel.libc, "getpid", SYSTEM.VAL( LONGINT, Getpid ) );
	Kernel.dlsym( Kernel.libc, "getuid", SYSTEM.VAL( LONGINT, Getuid ) );
	Kernel.dlsym( Kernel.libc, "ptrace", SYSTEM.VAL( LONGINT, Ptrace ) );
	Kernel.dlsym( Kernel.libc, "access", SYSTEM.VAL( LONGINT, Access ) );
	Kernel.dlsym( Kernel.libc, "sync", SYSTEM.VAL( LONGINT, Sync ) );
	Kernel.dlsym( Kernel.libc, "kill", SYSTEM.VAL( LONGINT, Kill ) );
	Kernel.dlsym( Kernel.libc, "stat", SYSTEM.VAL( LONGINT, Stat ) );
	Kernel.dlsym( Kernel.libc, "lstat", SYSTEM.VAL( LONGINT, Lstat ) );
	Kernel.dlsym( Kernel.libc, "dup", SYSTEM.VAL( LONGINT, Dup ) );
	Kernel.dlsym( Kernel.libc, "pipe", SYSTEM.VAL( LONGINT, Pipe ) );
	(* Kernel.dlsym( Kernel.libc, "profil", SYSTEM.VAL( LONGINT, Profil ) ); *)
	Kernel.dlsym( Kernel.libc, "getgid", SYSTEM.VAL( LONGINT, Getgid ) );
	Kernel.dlsym( Kernel.libc, "acct", SYSTEM.VAL( LONGINT, Acct ) );
	Kernel.dlsym( Kernel.libc, "ioctl", SYSTEM.VAL( LONGINT, Ioctl ) );
	Kernel.dlsym( Kernel.libc, "symlink", SYSTEM.VAL( LONGINT, Symlink ) );
	Kernel.dlsym( Kernel.libc, "readlink", SYSTEM.VAL( LONGINT, Readlink ) );
	Kernel.dlsym( Kernel.libc, "execve", SYSTEM.VAL( LONGINT, Execve ) );
	Kernel.dlsym( Kernel.libc, "umask", SYSTEM.VAL( LONGINT, Umask ) );
	Kernel.dlsym( Kernel.libc, "chroot", SYSTEM.VAL( LONGINT, Chroot ) );
	Kernel.dlsym( Kernel.libc, "fstat", SYSTEM.VAL( LONGINT, Fstat ) );
	(* Kernel.dlsym( Kernel.libc, "msync", SYSTEM.VAL( LONGINT, Msync ) ); *)
	Kernel.dlsym( Kernel.libc, "sbrk", SYSTEM.VAL( LONGINT, Sbrk ) );
	Kernel.dlsym( Kernel.libc, "mmap", SYSTEM.VAL( LONGINT, Mmap ) );
	Kernel.dlsym( Kernel.libc, "munmap", SYSTEM.VAL( LONGINT, Munmap ) );
	Kernel.dlsym( Kernel.libc, "mprotect", SYSTEM.VAL( LONGINT, Mprotect ) );
	(* Kernel.dlsym( Kernel.libc, "madvise", SYSTEM.VAL( LONGINT, Madvise ) ); *)
	Kernel.dlsym( Kernel.libc, "vhangup", SYSTEM.VAL( LONGINT, Vhangup ) );
	(* Kernel.dlsym( Kernel.libc, "mincore", SYSTEM.VAL( LONGINT, Mincore ) ); *)
	Kernel.dlsym( Kernel.libc, "getgroups", SYSTEM.VAL( LONGINT, Getgroups ) );
	Kernel.dlsym( Kernel.libc, "setgroups", SYSTEM.VAL( LONGINT, Setgroups ) );
	Kernel.dlsym( Kernel.libc, "getpgrp", SYSTEM.VAL( LONGINT, Getpgrp ) );
	Kernel.dlsym( Kernel.libc, "setpgrp", SYSTEM.VAL( LONGINT, Setpgrp ) );
	Kernel.dlsym( Kernel.libc, "setitimer", SYSTEM.VAL( LONGINT, Setitimer ) );
	Kernel.dlsym( Kernel.libc, "getitimer", SYSTEM.VAL( LONGINT, Getitimer ) );
	Kernel.dlsym( Kernel.libc, "dup2", SYSTEM.VAL( LONGINT, Dup2 ) );
	Kernel.dlsym( Kernel.libc, "fcntl", SYSTEM.VAL( LONGINT, Fcntl ) );
	Kernel.dlsym( Kernel.libc, "select", SYSTEM.VAL( LONGINT, Select ) );
	Kernel.dlsym( Kernel.libc, "fsync", SYSTEM.VAL( LONGINT, Fsync ) );
	Kernel.dlsym( Kernel.libc, "gettimeofday", SYSTEM.VAL( LONGINT, Gettimeofday ) );
	Kernel.dlsym( Kernel.libc, "readv", SYSTEM.VAL( LONGINT, Readv ) );
	Kernel.dlsym( Kernel.libc, "writev", SYSTEM.VAL( LONGINT, Writev ) );
	Kernel.dlsym( Kernel.libc, "settimeofday", SYSTEM.VAL( LONGINT, Settimeofday ) );
	Kernel.dlsym( Kernel.libc, "fchown", SYSTEM.VAL( LONGINT, Fchown ) );
	Kernel.dlsym( Kernel.libc, "fchmod", SYSTEM.VAL( LONGINT, Fchmod ) );
	Kernel.dlsym( Kernel.libc, "rename", SYSTEM.VAL( LONGINT, Rename ) );
	Kernel.dlsym( Kernel.libc, "truncate", SYSTEM.VAL( LONGINT, Truncate ) );
	Kernel.dlsym( Kernel.libc, "ftruncate", SYSTEM.VAL( LONGINT, Ftruncate ) );
	Kernel.dlsym( Kernel.libc, "mkdir", SYSTEM.VAL( LONGINT, Mkdir ) );
	Kernel.dlsym( Kernel.libc, "rmdir", SYSTEM.VAL( LONGINT, Rmdir ) );
	Kernel.dlsym( Kernel.libc, "utimes", SYSTEM.VAL( LONGINT, Utimes ) );
	Kernel.dlsym( Kernel.libc, "adjtime", SYSTEM.VAL( LONGINT, Adjtime ) );
	Kernel.dlsym( Kernel.libc, "localtime", SYSTEM.VAL( LONGINT, Localtime ) );
	Kernel.dlsym( Kernel.libc, "getrlimit", SYSTEM.VAL( LONGINT, Getrlimit ) );
	Kernel.dlsym( Kernel.libc, "setrlimit", SYSTEM.VAL( LONGINT, Setrlimit ) );
	(* Kernel.dlsym( Kernel.libc, "getmsg", SYSTEM.VAL( LONGINT, Getmsg ) ); *)
	(* Kernel.dlsym( Kernel.libc, "putmsg", SYSTEM.VAL( LONGINT, Putmsg ) ); *)
	(* Kernel.dlsym( Kernel.libc, "poll", SYSTEM.VAL( LONGINT, Poll ) ); *)
	(* Kernel.dlsym( Kernel.libc, "nfssvc", SYSTEM.VAL( LONGINT, Nfssvc ) ); *)
	Kernel.dlsym( Kernel.libc, "statfs", SYSTEM.VAL( LONGINT, Statfs ) );
	Kernel.dlsym( Kernel.libc, "fstatfs", SYSTEM.VAL( LONGINT, Fstatfs ) );
	(* Kernel.dlsym( Kernel.libc, "async_daemon", SYSTEM.VAL( LONGINT, Asyncdaemon ) ); *)
	Kernel.dlsym( Kernel.libc, "mount", SYSTEM.VAL( LONGINT, Mount ) );
	(* Kernel.dlsym( Kernel.libc, "getdents", SYSTEM.VAL( LONGINT, Getdents ) ); *)
	(* Kernel.dlsym( Kernel.libc, "fchdir", SYSTEM.VAL( LONGINT, Fchdir ) ); *)
	(* Kernel.dlsym( Kernel.libc, "fchroot", SYSTEM.VAL( LONGINT, Fchroot ) ); *)
	Kernel.dlsym( Kernel.libc, "times", SYSTEM.VAL( LONGINT, Times ) );
	Kernel.dlsym(Kernel.libc, "flock", SYSTEM.VAL(LONGINT, LockF));

	Kernel.dlsym( Kernel.libc, "system", SYSTEM.VAL( LONGINT, System ) );
	Kernel.dlsym( Kernel.libc, "sysconf", SYSTEM.VAL( LONGINT, Sysconf ) ); 
END Unix.
