  Syntax10.Scn.Fnt     8  FoldElems New  #   Syntax10.Scn.Fnt  1    1   
BEGIN
	t.next:= t; t.prev:= t;
END InitTreeNode; 8       
8   #   Syntax10.Scn.Fnt         
	VAR dummy: TreeNode;
BEGIN
	NEW(dummy); dummy.next:= dummy; dummy.prev:= dummy; dummy.name:= "dummy";
	t.next:= t; t.prev:= t; t.children:= dummy; dummy.parent:= t; t.notify:= NIL; t.count:= 0;
END InitTree; 8   ,    58   #   Syntax10.Scn.Fnt         
	VAR root: Tree;
BEGIN
	IF tn.parent = NIL THEN RETURN tn.parent; END;
	root:= tn.parent;
	WHILE root.parent  # NIL DO root:= root.parent END;
	RETURN root;
END getRoot 8   &    8   #   Syntax10.Scn.Fnt  O    O   
BEGIN
	IF tn.parent # NIL THEN
		tn.parent.deleteChild( tn);
	END;
END delete; 8   2    ;8   #   Syntax10.Scn.Fnt       
	VAR n: INTEGER; new: Tree;
BEGIN
	IF tn.parent # NIL THEN
		tn1.next:= tn.next;
		tn.next.prev:= tn1;
		tn1.prev:= tn;
		tn.next:= tn1;
		tn1.parent:= tn.parent;

		IF tn1 IS Tree THEN n:= tn1(Tree).count + 1; ELSE n:= 1; END;
		new:= tn.parent;
		WHILE new # NIL DO INC(new.count, n); new:= new.parent; END;
		IF tn1.parent.notify # NIL THEN tn1.parent.notify(tn1.getRoot(), tn1, NIL, insert); END;
	END;
END insert; 8   9    8   #   Syntax10.Scn.Fnt       
BEGIN
	COPY(name, tn.name);
	WITH tn: Tree DO
		IF tn.notify # NIL THEN tn.notify(tn.getRoot(), tn, tn, change); END;
	ELSE
		IF (tn.parent # NIL) & (tn.parent.notify # NIL) THEN 
			tn.parent.notify(tn.getRoot(), tn, tn, change); 
		END;
	END;
END setName; 8   3    8   #   Syntax10.Scn.Fnt         
BEGIN
	tn.elem:= e;
	WITH tn: Tree DO
		IF tn.notify # NIL THEN tn.notify(tn.getRoot(), tn, tn, change); END;
	ELSE
		IF (tn.parent # NIL) & (tn.parent.notify # NIL) THEN 
			tn.parent.notify(tn.getRoot(), tn, tn, change); 
		END;
	END;
END setElem; 8   3    8   #   Syntax10.Scn.Fnt  S    S   
BEGIN
	RETURN (tn.parent # NIL) & (tn.next = tn.parent.children);
END isLastChild; 8   0    W8   #   Syntax10.Scn.Fnt         
	VAR en: Enumerator;
BEGIN
	NEW(en);
	en.rider:= t.children.next;
	en.hasMoreElems:= en.rider # t.children;
	RETURN en;
END enumerate; 3    8   '    F8   #   Syntax10.Scn.Fnt         
	VAR root: Tree;
BEGIN
	IF t.parent = NIL THEN RETURN t END;
	root:= t;
	WHILE root.parent # NIL DO root:= root.parent; END;
	RETURN root;
END getRoot; 8   1    8   #   Syntax10.Scn.Fnt       
	VAR n: INTEGER; new: Tree;
BEGIN
	IF (tn # NIL) & (tn.parent # NIL) & (tn.parent = t) THEN
		tn.prev.next:= tn.next;
		tn.next.prev:= tn.prev;
		(* update count *)

		IF tn IS Tree THEN n:= tn(Tree).count + 1; ELSE n:= 1; END;
		new:= tn.parent;
		WHILE new # NIL DO DEC(new.count, n); new:= new.parent; END;

		IF t.notify # NIL THEN t.notify(tn.getRoot(), NIL, tn, delete); END;
		tn.parent:= NIL; tn.prev:= NIL; tn.next:= NIL;
	END;
END deleteChild; 8   .    8   #   Syntax10.Scn.Fnt  J    J   
BEGIN
	IF tn # NIL THEN
		t.children.prev.insert(tn);
	END;
END addChild; 8   (    8   #   Syntax10.Scn.Fnt  *   *  
	VAR tn: Tree;
BEGIN
	t.children.next:= t.children;
	t.children.prev:= t.children;

	(* update count *)
	tn:= t.parent;
	WHILE tn # NIL DO DEC(tn.count, t.count); tn:= tn.parent; END;
	t.count:= 0;

	IF t.notify # NIL THEN t.notify(t.getRoot(), NIL, t, deleteChildren); END;
END deleteAllChildren; 8   -    8   #   Syntax10.Scn.Fnt       
	VAR en: Enumerator; tn: TreeNode; i: INTEGER;
BEGIN
	en:= t.enumerate();
	WHILE en.hasMoreElems DO 
		tn:= en.nextElem();
		FOR i:= 0 TO depth DO Out.String("  "); END;
		Out.String(tn.name); Out.Ln;
		IF tn IS Tree THEN tn(Tree).print(depth + 1); END;
	END;
END print; 8   0    8     Syntax10.Scn.Fnt      a8  FoldElems New    Syntax10.Scn.Fnt  W    8  FoldElems New  #   Syntax10.Scn.Fnt  V   V  
			VAR M: Modules.Module; Cmd: Modules.Command; 
				org, ew, eh: LONGINT;
		BEGIN 
			Texts.new:= NIL;
			Files.ReadLInt(r, ew); Files.ReadLInt(r, eh); Files.Read(r, eno);
			IF eno > ecnt THEN 
				ecnt:= eno; 
				Files.ReadString(r, mods[eno]); Files.ReadString(r, procs[eno]) 
			END ;
			org := Files.Pos(r); M := Modules.ThisMod(mods[eno]);
			IF M # NIL THEN 
				Cmd := Modules.ThisCommand(M, procs[eno]);
				IF Cmd # NIL THEN Cmd END
			END ;
			e:= Texts.new;
			IF e # NIL THEN 
				e.W:= ew; e.H:= eh; 
				fileMsg.r:= r; e.handle(e, fileMsg); r:= fileMsg.r;
			END ;
		END LoadElem; 8   v     
		VAR isLast: BOOLEAN;
	
		PROCEDURE LoadElem (VAR r: Files.Rider; VAR e: Texts.Elem);
	BEGIN
		WHILE ~r.eof DO
			Files.Read(r, eno);
			IF eno > ecnt THEN 
				ecnt := eno; 
				Files.ReadString(r, mods[eno]); 
				Files.ReadString(r, procs[eno]) 
			END ;
			mod:= Modules.ThisMod(mods[eno]);	
			typ:= Types.This(mod, procs[eno]);	
			Types.NewObj(tn, typ); 
			Files.ReadString(r, tn.name);
			Files.ReadBool(r, isLast);
			Files.ReadBool(r, hasElem);

			IF hasElem THEN LoadElem(r, tn.elem); END;

			IF tn IS Tree THEN 
				t0:= tn(Tree);  InitTree(t0); 
				st.addChild(t0);  Load(t0);  
			ELSE 
				InitTreeNode(tn); st.addChild(tn); 
			END;
			IF isLast THEN st.notify:= n; RETURN END;
		END;
	END Load; 8       a  
	VAR fileMsg: Texts.FileMsg; typ: Types.Type; 
		mod: Modules.Module;
		tn: TreeNode; t0: Tree; n: NotifyProc; hasElem: BOOLEAN;
		ecnt, eno: SHORTINT; mods, procs: ARRAY 64, 32 OF CHAR; 

	PROCEDURE Load(st: Tree);
BEGIN
	fileMsg.id:= Texts.load; 
	ecnt:= 0;
	n:= t.notify;
	InitTree(t);
	Load(t);
	IF n # NIL THEN n(t, t, t, replace) END;
END load; 8   1    _8     Syntax10.Scn.Fnt      8  FoldElems New  P  Syntax10.Scn.Fnt  `    	8  FoldElems New  #   Syntax10.Scn.Fnt       
		BEGIN 
			tn.elem.handle(tn.elem, idMsg);
			COPY(idMsg.mod, mods[ecnt]); COPY(idMsg.proc, procs[ecnt]); eno := 1;
			WHILE (mods[eno] # idMsg.mod) OR (procs[eno] # idMsg.proc) DO INC(eno) END ;
			Files.WriteLInt(r, e.W); Files.WriteLInt(r, e.H); Files.Write(r, eno);
			IF eno = ecnt THEN 
				INC(ecnt); 
				Files.WriteString(r, idMsg.mod); 
				Files.WriteString(r, idMsg.proc) 
			END ;

			fileMsg.r:= r; e.handle(e, fileMsg);  r:= fileMsg.r;
		END StoreElem; 8        
		VAR en: Enumerator; tn: TreeNode;

		PROCEDURE StoreElem (VAR r: Files.Rider; e: Texts.Elem);
	BEGIN
		en:= st.enumerate();
		WHILE en.hasMoreElems DO
			tn:= en.nextElem();
			(* save node *)
			typ:= Types.TypeOf(tn);
			COPY(typ.module.name, mods[ecnt]); COPY(typ.name, procs[ecnt]); 
			eno := 1;
			WHILE (mods[eno] # typ.module.name) OR (procs[eno] # typ.name) DO 
				INC(eno) 
			END ;
			Files.Write(r, eno);
			IF eno = ecnt THEN 
				INC(ecnt); Files.WriteString(r, mods[eno]); 
				Files.WriteString(r, procs[eno]) 
			END ;
			Files.WriteString(r, tn.name);	
			Files.WriteBool(r, tn.isLastChild());			
			Files.WriteBool(r, tn.elem # NIL);
			IF tn.elem # NIL THEN StoreElem(r, tn.elem); END;
			IF tn IS Tree THEN Store(tn(Tree)); END;
		END;
	END Store; 8   M       
	VAR fileMsg: Texts.FileMsg; idMsg: Texts.IdentifyMsg;
		typ: Types.Type;  
		mods, procs: ARRAY 64, 32 OF CHAR;
		ecnt, eno: SHORTINT;

	PROCEDURE Store(st: Tree);	
BEGIN
	ecnt:= 1; eno:= 1;
	fileMsg.id:= Texts.store; 
	Store(t);
END store; 8   5    8   #   Syntax10.Scn.Fnt         
	VAR tn: TreeNode; 
BEGIN
	IF en.hasMoreElems THEN 
		tn:= en.rider;
		en.hasMoreElems:= ~en.rider.isLastChild();
		en.rider:= en.rider.next; 
	ELSE
		tn:= NIL;
	END;
	RETURN tn;
END nextElem; 8   :    %  MODULE Trees;	(* EK 98 *)

IMPORT Texts, Display, Files, Types, Modules, Out;

CONST
	(** update message IDs **)
	replace* = 0; insert* = 1; delete* = 2; change*= 3; deleteChildren*= 4;
	MaxNameLength*= 32;
	
TYPE
	Tree*= POINTER TO TreeDesc;
	TreeNode*= POINTER TO TreeNodeDesc;
	NotifyProc*= PROCEDURE(root: Tree; new, old: TreeNode; op: INTEGER);

	TreeNodeDesc*= RECORD
		name-: ARRAY MaxNameLength OF CHAR;
		elem-: Texts.Elem;
		next-: TreeNode;	
		prev: TreeNode;
		parent-: Tree;
	END;
	
	TreeDesc*= RECORD (TreeNodeDesc)
		notify*: NotifyProc;
		children-: TreeNode;	(* double ring chained with dummy element *)
		count-: INTEGER;	(** the total number of nodes in tree **)
	END;	

	Enumerator*= POINTER TO EnumeratorDesc;
	EnumeratorDesc*= RECORD
		hasMoreElems-: BOOLEAN;
		rider: TreeNode;
	END;

PROCEDURE^ (t: Tree) deleteChild*(tn: TreeNode);	
PROCEDURE^ (en: Enumerator) nextElem*(): TreeNode;

PROCEDURE InitTreeNode*(t: TreeNode);

PROCEDURE InitTree*(t: Tree);

PROCEDURE (tn: TreeNode) getRoot*(): Tree;;

PROCEDURE (tn: TreeNode) delete*();

PROCEDURE (tn: TreeNode) insert*(tn1: TreeNode);

PROCEDURE (tn: TreeNode) setName*(name: ARRAY OF CHAR);

PROCEDURE (tn: TreeNode) setElem*(e: Texts.Elem); 

PROCEDURE (tn: TreeNode) isLastChild*():BOOLEAN;


PROCEDURE (t: Tree) enumerate*(): Enumerator;(** enumerates children of tree t (no subtrees) **)

PROCEDURE (t: Tree) getRoot*(): Tree; 

PROCEDURE (t:Tree) deleteChild*(tn: TreeNode);

PROCEDURE (t: Tree) addChild*(tn: TreeNode);

PROCEDURE (t:Tree) deleteAllChildren*;

PROCEDURE (t: Tree) print*(depth: INTEGER);

PROCEDURE (t: Tree) load*(VAR r: Files.Rider);

PROCEDURE (t: Tree) store*(VAR r: Files.Rider); 


PROCEDURE (en: Enumerator) nextElem*(): TreeNode; 

END Trees.

View/Control see:
	Edit.Open TreeFrames.Mod