|  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt      	  StampElems Alloc 2002-Aug-14  :       Syntax10b.Scn.Fnt                  
                 	                	            E          MarkElems Alloc ` 
    :    8  FoldElems New     8         yĖ  5    8   p    8                  "    8  #   Syntax10.Scn.Fnt  ,    ,    insert parc at pos 0 with width f.W - ..... \   8                   1    8      8             
     1    8      %        8               
        8      &    /   '    i    8         r!  1    8   9    8   }   8       8      8        8       8   3    8             H      /    8   %   8             K      )    8          5           
        +    9        M    8             Dd<         8       8             L          8   =    8             M              8       8   v    "  MODULE TextAreaElems; (* CE   InsertParcs has 2 lines commented out: gh 2002-Aug-14 *)

IMPORT Texts, TextFrames, TextPrinter, Oberon, Display, Viewers, Files,
			 Fonts, Elems, GU := GUtils, MenuViewers, ParcElems, Out, HandlerElems;

CONST
	DUnit = TextFrames.Unit;
	MM = 1;

TYPE
	Elem* = POINTER TO ElemDesc;

	Frame* = POINTER TO FrameDesc;
	FrameDesc* =  RECORD(Display.FrameDesc)
		e* : Elem;
	END;

	ElemDesc* = RECORD (Elems.ElemDesc)
		txt* : Texts.Text;
		readOnly*, scrBar* : BOOLEAN;
	END;

VAR
	W : Texts.Writer;
	curElem : Elem;

PROCEDURE TextToString* (t : Texts.Text; pos : LONGINT; VAR str : ARRAY OF CHAR);
VAR
	r : Texts.Reader;	
	ch : CHAR;
	i, len : INTEGER;
BEGIN
	len := SHORT(LEN(str));
	i := 0;
	Texts.OpenReader(r, t, pos);
	
	Texts.Read(r, ch);
	WHILE ~r.eot & (ch # Elems.CR) & (i < len-1) DO
		WHILE ~r.eot & (ch = Texts.ElemChar) DO Texts.Read(r, ch) END;
		IF ~r.eot & (ch # Elems.CR) THEN
			str[i] := ch;
			INC(i);
			Texts.Read(r, ch)
		END
	END;
	str[i] := 0X
END TextToString;

PROCEDURE SetFrameCoords(src : Frame; dest : TextFrames.Frame);
BEGIN
	dest.X := src.X + 2; dest.Y := src.Y + 2;
	dest.H := src.H - 4; dest.W := src.W - 4;
END SetFrameCoords;

PROCEDURE InsertParc* (e : Elem; f : TextFrames.Frame);
VAR p : TextFrames.Parc; r : Texts.Reader; insert : BOOLEAN; fnt : Fonts.Font; col : SHORTINT; ch : CHAR;
BEGIN
	IF f.text.len = 0 THEN
		NEW(p); insert := TRUE
	ELSE
		Texts.OpenReader(r, f.text, 0); Texts.ReadElem(r);
		IF (r.elem # NIL) & (Texts.Pos(r) = 1) THEN
			IF r.elem IS TextFrames.Parc THEN
				insert := FALSE;
				p := r.elem(TextFrames.Parc);
			ELSE
				NEW(p);
				insert := TRUE
			END
		ELSE
			NEW(p); insert := TRUE
		END
	END;
	Elems.GetLook(e, fnt, col);
	IF insert THEN
		ParcElems.CopyParc(TextFrames.defParc, p);
		p.width := LONG(f.W - f.left - f.right) * DUnit;
		
		Texts.SetFont(W, fnt); Texts.SetColor(W, col);
		Texts.WriteElem(W, p);
		IF f.text.len = 0 THEN Texts.WriteLn(W) END;
		(* Texts.Insert(f.text, 0, W.buf);	gh  2002-Aug-14 *)
	ELSE
		Texts.OpenReader(r, f.text, 0); Texts.Read(r, ch);
		IF (ch = Texts.ElemChar) & (r.elem IS TextFrames.Parc) THEN
			r.elem(TextFrames.Parc).width := LONG(f.W - f.left - f.right) * DUnit;
			r.elem.W := r.elem(TextFrames.Parc).width;
		END;
		(* Texts.ChangeLooks(f.text, 0, 1, {0, 1}, fnt, col, 0)	gh  2002-Aug-14 *)
	END
END InsertParc;

PROCEDURE TextHandle* (f : Display.Frame; VAR msg : Display.FrameMsg);
VAR track : TextFrames.TrackMsg; done : BOOLEAN;
BEGIN
	WITH f : TextFrames.Frame DO
		WITH msg : Oberon.InputMsg DO
			IF (msg.id = Oberon.track) THEN
				track.X0 := f.X; track.Y0 := f.Y; track.X := msg.X; track.Y := msg.Y;
				track.keys := msg.keys; track.frame := f;
				done := FALSE;
				Elems.Track(curElem, track, done);
				IF ~done & curElem.readOnly THEN
					IF (msg.X >= f.X) & (msg.X < f.X + f.barW) THEN
						TextFrames.Handle(f, msg)
					ELSIF msg.keys # {2} THEN
						TextFrames.Handle(f, msg)
					END
				ELSIF ~done THEN
					TextFrames.Handle(f, msg)
				ELSE
					Elems.UpdateElem(curElem)
				END
			ELSIF (msg.id = Oberon.consume) & ~curElem.readOnly THEN
				TextFrames.Handle(f, msg)
			END
		ELSE
			TextFrames.Handle(f, msg)
		END
	END
END TextHandle;

PROCEDURE FrameHandle* (f : Display.Frame; VAR msg : Display.FrameMsg);
BEGIN
	WITH msg : MenuViewers.ModifyMsg DO
		SetFrameCoords(f(Frame), f.dsc(TextFrames.Frame))
	| msg : Elems.GetFrameMsg DO
		IF msg.e = f(Frame).e THEN msg.f := f.dsc END
	| msg : Elems.GetContextMsg DO
		IF (msg.p = f(Frame).e) & 
				((msg.fx >= f.X) & (msg.fx <= f.X + f.W) & (msg.fy >= f.Y) & (msg.fy <= f.Y + f.H) OR
					(msg.fx < 0) & (msg.fy < 0)) THEN
			msg.context := f; msg.p := NIL
		END
	ELSE
		IF msg IS Oberon.InputMsg THEN curElem := f(Frame).e END;
(*		f.dsc.handle(f.dsc, msg) *)
		HandlerElems.curHandle(f.dsc, msg)
	END
END FrameHandle;

PROCEDURE OpenFrame* (e : Elem; f : Display.Frame; textHandler : Display.Handler; frameHandler : Display.Handler; x, y, w, h : INTEGER) : Display.Frame;
VAR new : Frame; m : MenuViewers.ModifyMsg; tf : TextFrames.Frame;
BEGIN
	NEW(new); new.handle := frameHandler;
	new.e := e;
	new.X := x; new.Y := y; new.W := w; new.H := h;
	tf := TextFrames.NewText(e.txt, 0);
	tf.handle := textHandler;
	e.txt.notify := NIL; (* to avoid parc displaying to soon *)

	tf.right := 2; tf.top := 2; tf.bot := 0;
	IF e.scrBar THEN tf.barW := TextFrames.barW ELSE tf.barW := 0 END;
	tf.left := tf.barW + 5;
	tf.showsParcs := FALSE;

	Elems.AdjustSubFrame(f, new);
	SetFrameCoords(new, tf);
	InsertParc(e, tf);
	
	e.txt.notify := TextFrames.NotifyDisplay;

	new.dsc := tf;
	(*Elems.AdjustSubFrame(new, new.dsc);*)
	m.id := 1; m.Y := new.dsc.Y; m.H := new.dsc.H;
	new.dsc.handle(new.dsc, m);
	RETURN new;
END OpenFrame;

PROCEDURE HandleAttrMsg(e : Elem; VAR msg : Elems.AttrMsg);
BEGIN
	Elems.Done := TRUE;
	
	IF msg.id = Elems.get THEN
		IF msg.name = "Value" THEN
			msg.class := Elems.String;
			TextToString(e.txt, 0, msg.s)		
		ELSIF msg.name = "ValueT" THEN
			msg.class := Elems.Text;
			msg.t := e.txt
		ELSIF msg.name = "ReadOnly" THEN
			msg.class := Elems.Bool;
			msg.b := e.readOnly
		ELSIF msg.name = "Scrollbar" THEN
			msg.class := Elems.Bool;
			msg.b := e.scrBar
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.set THEN
		IF msg.name = "Value" THEN
			IF msg.class = Elems.String THEN
				Texts.Delete(e.txt, 0, e.txt.len);
				Texts.WriteString(W, msg.s);
				Texts.Append(e.txt, W.buf)
			END
		ELSIF msg.name = "ValueT" THEN
			IF msg.class = Elems.Text THEN e.txt := msg.t END
		ELSIF msg.name = "ReadOnly" THEN
			IF msg.class = Elems.Bool THEN e.readOnly := msg.b END
		ELSIF msg.name = "Scrollbar" THEN
			IF msg.class = Elems.Bool THEN e.scrBar := msg.b END
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.enum THEN
		Elems.Handle(e, msg);
		msg.enum("ValueT", Elems.Text);
		msg.enum("Scrollbar", Elems.Bool); msg.enum("ReadOnly", Elems.Bool) 
	ELSE Elems.Handle(e, msg)
	END
END HandleAttrMsg;

PROCEDURE Draw* (e : Elem; x, y : INTEGER; f : Display.Frame);
VAR pos : LONGINT; dx, w, h : INTEGER;
BEGIN
	GU.Area(f, 0, 12, x, y, GU.Unit(e.W, TRUE), GU.Unit(e.H, TRUE), GU.Unit(2, FALSE), FALSE, TRUE);
	IF GU.device = GU.printer THEN
		dx := 0; pos := 0;
		IF e.scrBar THEN
			dx := GU.Unit(TextFrames.barW, FALSE);
			GU.ReplConst(f, 0, x + dx, y, GU.Unit(1, FALSE), GU.Unit(e.H, TRUE), Display.paint)
		END;
		w := GU.Unit(e.W, TRUE) - dx - GU.Unit(2, FALSE);
		h := GU.Unit(e.H, TRUE) - GU.Unit(2, FALSE);
	
		TextPrinter.PlaceBody(x + dx + GU.Unit(2, FALSE), y, w, h, e.txt, pos, 0, TRUE)
	END
END Draw;

PROCEDURE Handle* (E: Texts.Elem; VAR msg: Texts.ElemMsg);
VAR copy : Elem; ch : CHAR;
BEGIN
	WITH E : Elem DO
		WITH msg: TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				msg.elemFrame := OpenFrame(E, msg.frame, TextHandle, FrameHandle, msg.X0, msg.Y0, 
															SHORT(E.W DIV DUnit), SHORT(E.H DIV DUnit));
				Draw(E, msg.X0, msg.Y0, msg.elemFrame)
			END
		| msg : TextPrinter.PrintMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.printer);
				Draw(E, msg.X0, msg.Y0, NIL);
				GU.SetDevice(GU.display)
			END
		| msg : TextFrames.TrackMsg DO (* send to his frame *)
			Elems.Handle(E, msg);
			IF msg.keys = {MM} THEN Elems.ToFrame(E, msg) END
		| msg : Texts.CopyMsg DO
			IF msg.e = NIL THEN NEW(copy); msg.e := copy ELSE copy := msg.e(Elem) END;
			Elems.CopyElem(E, copy);
			copy.txt := Elems.CopyText(E.txt);
			copy.locked := E.locked;
			copy.scrBar := E.scrBar;
			msg.e := copy
		| msg : Texts.IdentifyMsg DO
			msg.mod := "TextAreaElems"; msg.proc := "New"
		| msg : Elems.AttrMsg DO
			HandleAttrMsg(E, msg)
		| msg : Texts.FileMsg DO
			Elems.Handle(E, msg);
			IF msg.id = Texts.load THEN
				Files.Read(msg.r, ch); (* version -> not yet used *)
				Files.ReadBool(msg.r, E.locked);
				Files.ReadBool(msg.r, E.scrBar);
				Texts.Load(msg.r, E.txt);
			ELSIF msg.id = Texts.store THEN
				Files.Write(msg.r, 0X); (* version *)
				Files.WriteBool(msg.r, E.locked);
				Files.WriteBool(msg.r, E.scrBar);
				Texts.Store(msg.r, E.txt)
			END
		| msg : TextFrames.FocusMsg DO (* set caret while activating his frame *)
			curElem := E;
			msg.elemFrame := msg.elemFrame.dsc; (* set to textframe *)
			Elems.Focusing(msg)
		ELSE
			Elems.Handle(E, msg)
		END
	END
END Handle;

PROCEDURE Init* (e : Elem);
BEGIN
	Elems.Init(e);
	e.handle := Handle;
	e.txt := TextFrames.Text("");
	e.readOnly := FALSE;
	e.scrBar := TRUE;
	e.H := 50 * DUnit;
	e.W := 70 * DUnit;
END Init;

PROCEDURE New*;
VAR e : Elem;
BEGIN NEW(e); Init(e); Texts.new := e
END New;

PROCEDURE Insert*; (** Name Cmd Par W H *)
VAR e : Elem; m : TextFrames.InsertElemMsg; s : Texts.Scanner;
BEGIN
	NEW(e); Init(e);
	Elems.GetPar(e, s);
	m.e := e;
	Viewers.Broadcast(m)
END Insert;

BEGIN Texts.OpenWriter(W)
END TextAreaElems.

System.Free TextAreaElems ~

TextAreaElems.Insert alf System.Time "" ~