   Syntax10.Scn.Fnt  x   Syntax10b.Scn.Fnt              6           Syntax10i.Scn.Fnt          a       !  MODULE RandomNumbers;

IMPORT In, Oberon, Out;

TYPE RandArr = POINTER TO ARRAY OF LONGINT;

VAR z: LONGINT;

PROCEDURE Uniform* (): REAL;
	CONST A = 16807; M = 2147483647; Q = M DIV A; R = M MOD A;
	VAR gamma: LONGINT;
BEGIN
	gamma := A * (z MOD Q) - R * (z DIV Q);
	IF gamma > 0 THEN z := gamma ELSE z := gamma + M END;
	RETURN z * (1.0 / M)
END Uniform;

PROCEDURE InitSeed*;
BEGIN z := Oberon.Time ()
END InitSeed;

PROCEDURE Do*; (** n m [- d] *)
(** prints n random numbers between 0 and m. With the option -d you will get different numbers *)
	VAR end, n, nr, max, new, i: LONGINT; dif, cond: BOOLEAN; randArr: RandArr; ch: CHAR;
BEGIN
	In.Open; In.LongInt (n); dif := FALSE;
	IF In.Done THEN In.LongInt (max) ELSE RETURN END;
	IF ~ In.Done THEN RETURN END;
	In.Char (ch); 
	IF In.Done  & (ch = "-") THEN 
		In.Char (ch); IF In.Done & (ch = "d") THEN dif := TRUE END
	END;
	IF dif & (n > max) THEN n := max END;
	NEW (randArr, n); nr := 1;
	WHILE nr <= n DO
		new := ENTIER (Uniform () * max); INC (new); cond := FALSE; 
		IF dif THEN
			FOR i := 1 TO nr - 1 DO
				IF randArr [i - 1] = new THEN cond := TRUE END
			END
		END;	
		IF ~cond OR ~dif THEN randArr [nr - 1] := new; INC (nr) END;
	END;
	FOR i := 1 TO n DO
		Out.Ln; Out.Int (randArr [i - 1], 5);
	END;
END Do;

BEGIN InitSeed;
END RandomNumbers.