  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt       I StampElems Alloc 17 Dec 98         Syntax10b.Scn.Fnt          	                        
                  MarkElems Alloc H  2    8  FoldElems New  8   8             | 
        8  #   Syntax10.Scn.Fnt  9    9    iterate over base text and send UpdateMsg to every elem     8         D$  &    8           H    8         r!  1    8   9    8       8       8      8        8   Z    8   3    8         F +    8   u   8             K      +    8              
    O   8             L         8       8             L          8   =    8             M          #    8   T   8         MODULE RadioButtonElems; (* CE  *)

IMPORT Texts, TextFrames, TextPrinter, Oberon, Display, Viewers, Files, Fonts, Elems,
				GU := GUtils, Input;
			 	
CONST
	DUnit = TextFrames.Unit; 

	MR = 0; MM = 1; ML = 2;

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (Elems.ElemDesc)
		value*, myval* : ARRAY 64 OF CHAR
	END;
	
	UpdateMsg* = RECORD (Texts.ElemMsg) e* : Elem; END;
	
PROCEDURE Draw(e : Elem; x, y : INTEGER; f : Display.Frame);
VAR h, w, one : INTEGER;
BEGIN
	h := GU.Unit(e.H, TRUE); w := GU.Unit(e.W, TRUE);
	one := GU.Unit(1, FALSE);
	GU.Area(f, 12, 0, x, y, w, h, GU.Unit(1, FALSE), TRUE, TRUE);
	IF (e.value = e.myval) THEN
		GU.Area(f, 13, 0, x + 3*one, y + 3*one, w - 6*one, h - 6*one, GU.Unit(1, FALSE), TRUE, FALSE)
	END
END Draw;

PROCEDURE UpdateAll* (e : Elem);
VAR r : Texts.Reader; update : UpdateMsg;
BEGIN
	IF Texts.ElemBase(e) # NIL THEN
		update.e := e;
		Texts.OpenReader(r, Texts.ElemBase(e), 0);
		Texts.ReadElem(r);
		WHILE ~r.eot & (r.elem # NIL) DO
			r.elem.handle(r.elem, update);
			Texts.ReadElem(r);
		END
	END
END UpdateAll;

PROCEDURE Update (e : Elem; update : UpdateMsg);
VAR name1, name2 : ARRAY 256 OF CHAR;
BEGIN
	Elems.GetString(e, "Name", name1);
	Elems.GetString(update.e, "Name", name2);
	IF (name1 = "") OR (name2 = "") THEN RETURN END;

	IF (name1 = name2) THEN (* same group *)
		COPY(update.e.value, e.value);
		Elems.UpdateElem(e)
	END
END Update;

PROCEDURE HandleAttrMsg(e : Elem; VAR msg : Elems.AttrMsg);
BEGIN
	Elems.Done := TRUE;
	
	IF msg.id = Elems.get THEN
		IF msg.name= "Value" THEN
			msg.class := Elems.String;
			COPY(e.value, msg.s)
		ELSIF msg.name = "MyValue" THEN
			msg.class := Elems.String;
			COPY(e.myval, msg.s)
		ELSE
			Elems.Handle(e, msg);
		END;
	ELSIF msg.id = Elems.set THEN
		IF msg.name = "Value" THEN
			IF msg.class = Elems.String THEN
				COPY(msg.s, e.value);
				UpdateAll(e)
			END
		ELSIF msg.name = "MyValue" THEN
			IF msg.class = Elems.String THEN
				COPY(msg.s, e.myval);
				UpdateAll(e)
			END
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.enum THEN
		Elems.Handle(e, msg);
		msg.enum("Value", Elems.Int);
		msg.enum("MyValue", Elems.Int);
	ELSE Elems.Handle(e, msg)
	END
END HandleAttrMsg;

PROCEDURE Track(e : Elem; msg : TextFrames.TrackMsg);
VAR X, Y, w, h : INTEGER; keysum : SET; isin : BOOLEAN; exec : Elems.ExecMsg;
BEGIN
	keysum := {};
	w := SHORT(e.W DIV DUnit); h := SHORT(e.H DIV DUnit);
	isin := TRUE;

	REPEAT
		Input.Mouse(msg.keys, X, Y); keysum := keysum + msg.keys;
		Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, X, Y);
		isin := (X >= msg.X0) & (X <= msg.X0 + w) & (Y >= msg.Y0) & (Y <= msg.Y0 + h)
	UNTIL (msg.keys = {}) OR (MR IN msg.keys);

	IF isin & (msg.keys = {}) THEN
		COPY(e.myval, e.value);
		UpdateAll(e);
		exec.e := e; exec.x := msg.X0; exec.y := msg.Y0; exec.f := msg.frame; exec.unload := ML IN keysum;
		e.handle(e, exec)
	END
END Track;

PROCEDURE Handle* (e : Texts.Elem; VAR msg : Texts.ElemMsg);
VAR copy: Elem; ch: CHAR;
BEGIN
	WITH e : Elem DO
		WITH msg: TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				Draw(e, msg.X0, msg.Y0, msg.frame)
			END
		| msg : TextPrinter.PrintMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.printer);
				Draw(e, msg.X0, msg.Y0, NIL);
				GU.SetDevice(GU.display)
			END
		| msg : Texts.CopyMsg DO
			IF msg.e = NIL THEN NEW(copy); msg.e := copy ELSE copy := msg.e(Elem) END;
			Elems.CopyElem(e, copy);
			copy.value := e.value;
			copy.myval := e.myval;
			msg.e := copy;
		| msg: Texts.IdentifyMsg DO msg.mod := "RadioButtonElems"; msg.proc := "New"
		| msg: Texts.FileMsg DO
			Elems.Handle(e, msg);
			IF msg.id = Texts.load THEN
				Files.Read(msg.r, ch); (* version -> not yet used *)
				Files.ReadString(msg.r, e.value);
				Files.ReadString(msg.r, e.myval);
			ELSIF msg.id = Texts.store THEN
				Files.Write(msg.r, 0X); (* version *)
				Files.WriteString(msg.r, e.value);
				Files.WriteString(msg.r, e.myval);
			END
		| msg : Elems.AttrMsg DO
			HandleAttrMsg(e, msg)
		| msg : UpdateMsg DO
			Update(e, msg)
		| msg : TextFrames.TrackMsg DO
			Elems.Handle(e, msg);
			IF msg.keys = {MM} THEN Track(e, msg) END
		ELSE
			Elems.Handle(e, msg)
		END
	END
END Handle;

PROCEDURE Init* (e : Elem);
BEGIN
	Elems.Init(e);
	e.handle := Handle;
	e.value := ""; e.myval := "";
	e.H :=  LONG(Fonts.Default.maxY - Fonts.Default.minY) * DUnit;
	e.W := e.H	
END Init;

PROCEDURE New*;
VAR e : Elem;
BEGIN NEW(e); Init(e); Texts.new := e
END New;

PROCEDURE Insert*; (** Name Cmd Par W H MyVal Value *)
VAR e : Elem; m : TextFrames.InsertElemMsg; s : Texts.Scanner;
BEGIN
	NEW(e); Init(e);
	Elems.GetPar(e, s);
	IF ~s.eot & (s.class IN {Texts.String, Texts.Name}) THEN
		COPY(s.s, e.myval);
	END;
	Texts.Scan(s);
	IF ~s.eot & (s.class IN {Texts.String, Texts.Name}) THEN
		COPY(s.s, e.value)
	END;
	m.e := e; Viewers.Broadcast(m);
END Insert;

END RadioButtonElems.

System.Free RadioButtonElems ~

Batch.Start
RadioButtonElems.Insert "x" "" "" 0 0 eins eins ~
RadioButtonElems.Insert "x" "" "" 0 0 zwei eins ~
RadioButtonElems.Insert "x" "" "" 0 0 drei eins ~
~
