  Syntax10.Scn.Fnt        LinkElems Alloc Printer.Mod _  H   8  FoldElems New  [    8   g    8      8   4    8   8    8   .    8   :    8   7    8   :    8   B    8   8    8   5    8   C    8   @    8   A    8   *    8   3    8   .    8   8    8   -    8   4    8   3    8   >    8   L    8   ?    8   (    8   /    8   ?    8       8         MarkElems Alloc _      8      8       8   U    8         MODULE Printer;  (*UNIX version: JT 11.5.90, RC 2.7.93,  JS 13.10.94 *)
(* RLI 06 Mar 1997: Color Printing taken from HP-Oberon mixed with Close-Command from original ETH Oberon *)

IMPORT SYSTEM, PrinterDriver, Modules, Files, Unix, Console;

VAR
	res*: INTEGER; (*0 = done, 1 = not done*)
	PageWidth*, PageHeight*: INTEGER;
	outProc: ARRAY 32 OF CHAR;
	arg: ARRAY 64 OF CHAR;
	tmpFileName: ARRAY 64 OF CHAR;

(* -- Error handling -- *)

PROCEDURE Error (s0, s1: ARRAY OF CHAR); 
	VAR error, f: ARRAY 32 OF CHAR;
BEGIN
	COPY(s0, error); COPY(s1, f); HALT(99)
END Error; 

(* -- Exported Procedures -- *)

PROCEDURE Open* (VAR name, user: ARRAY OF CHAR; password: LONGINT); 
	VAR driver: ARRAY 32 OF CHAR; driverModule: Modules.Module; i, j: INTEGER; driverInit: Modules.Command;
	n: LONGINT; buf: ARRAY 64 OF CHAR;
BEGIN
	res := 1;
	i := 0; j := 0;
	driver := ""; outProc := ""; arg := "";
	WHILE (name[i] # 0X) & (name[i] # ".") DO driver[j] := name[i]; INC(i); INC(j) END; driver[j] := 0X;
	IF name[i] # 0X THEN INC(i) END;
	j := 0;
	WHILE (name[i] # 0X) & (name[i] # ".") DO outProc[j] := name[i]; INC(i); INC(j) END; outProc[j] := 0X;
	IF name[i] # 0X THEN INC(i) END;
	j := 0;
	WHILE (name[i] # 0X) DO arg[j] := name[i]; INC(i); INC(j) END; arg[j] := 0X;
	driverModule := Modules.ThisMod(driver);
	IF driverModule = NIL THEN Error(driver, "not found") END;
	driverInit := Modules.ThisCommand(driverModule, "Init");
	IF driverInit = NIL THEN Error(driver, "Init not found") END;
	driverInit;
	i := 0; j := 0;
	(* n := Unix.Getcwd(SYSTEM.ADR(buf), LEN(buf)); *)
	buf := ".tmp."; WHILE buf[j] # 0X DO tmpFileName[i] := buf[j]; INC(i); INC(j) END;
	n := SHORT(Unix.Getpid()); j := 0;
	WHILE n > 0 DO buf[j] := CHR(n MOD 10 + ORD("0"));  n := n DIV 10; INC(j) END;
	WHILE j > 0 DO
		DEC(j); tmpFileName[i] := buf[j]; INC(i)
	END;
	buf := ".print"; j := 0; WHILE buf[j] # 0X DO tmpFileName[i] := buf[j]; INC(i); INC(j) END;
	tmpFileName[i] := 0X;
	PrinterDriver.Open(tmpFileName);
	res := PrinterDriver.res;
	IF PrinterDriver.err THEN
		Error(PrinterDriver.errMsg, PrinterDriver.f)
	END;
END Open; 

PROCEDURE UseListFont* (VAR name: ARRAY OF CHAR); 
BEGIN PrinterDriver.UseListFont(name)
END UseListFont; 

PROCEDURE ReplConst* (x, y, w, h: INTEGER); 
BEGIN PrinterDriver.ReplConst(x, y, w, h)
END ReplConst; 

PROCEDURE ContString* (VAR s, fname: ARRAY OF CHAR); 
BEGIN PrinterDriver.ContString(s, fname)
END ContString; 

PROCEDURE String* (x, y: INTEGER; VAR s, fname: ARRAY OF CHAR); 
BEGIN PrinterDriver.String(x, y, s, fname)
END String; 

PROCEDURE ReplPattern* (x, y, w, h, col: INTEGER); 
BEGIN PrinterDriver.ReplPattern(x, y, w, h, col)
END ReplPattern; 

PROCEDURE Picture* (x, y, w, h, mode: INTEGER; adr: LONGINT); 
BEGIN PrinterDriver.Picture(x, y, w, h, mode, adr)
END Picture; 

PROCEDURE Circle* (x0, y0, r: INTEGER); 
BEGIN PrinterDriver.Circle(x0, y0, r)
END Circle; 

PROCEDURE Ellipse* (x0, y0, a, b: INTEGER); 
BEGIN PrinterDriver.Ellipse(x0, y0, a, b)
END Ellipse; 

PROCEDURE Line* (x0, y0, x1, y1: INTEGER); 
BEGIN PrinterDriver.Line(x0, y0, x1, y1)
END Line; 

PROCEDURE UseColor* (red, green, blue: INTEGER); 
BEGIN PrinterDriver.UseColor(red, green, blue)
END UseColor; 

PROCEDURE Spline* (x0, y0, n, open: INTEGER; VAR X, Y: ARRAY OF INTEGER); 
BEGIN PrinterDriver.Spline(x0, y0, n, open, X, Y)
END Spline; 

PROCEDURE Page* (nofcopies: INTEGER); 
BEGIN PrinterDriver.Page(nofcopies)
END Page; 

PROCEDURE Append (VAR s1: ARRAY OF CHAR; s2: ARRAY OF CHAR); 
	VAR i, j: INTEGER; ch: CHAR;
BEGIN i := 0; j := 0;
	WHILE s1[i] # 0X DO INC(i) END ;
	REPEAT ch := s2[j]; s1[i] := ch; INC(i); INC(j) UNTIL ch = 0X
END Append; 

PROCEDURE Close*; 
CONST bufSize = 4*1024;
VAR
	cmd: ARRAY 256 OF CHAR; i: INTEGER;
	printF: Files.File; printR, srcR: Files.Rider; ch: CHAR; buffer: ARRAY bufSize OF SYSTEM.BYTE;
BEGIN
	PrinterDriver.Close;
	IF outProc = "Print" THEN
		cmd := "lpr -P"; Append(cmd, arg); Append(cmd, " "); Append(cmd, tmpFileName);
		(* g.haynes 2003-March-6 Unix.System(SYSTEM.ADR(cmd), LEN(cmd)); *)
		Files.Delete(tmpFileName, res)
	ELSIF outProc = "File" THEN
		Files.Rename(tmpFileName, arg, res)
	ELSE
		Error(outProc, "not defined")
	END;
END Close; 

BEGIN
	Console.Str("Printer loading");	Console.Ln;
	PageWidth := 2336; PageHeight := 3425 
END Printer.
