V;  Syntax10.Scn.Fnt      `= I StampElems Alloc 16 Mar 98     Syntax10i.Scn.Fnt    q InfoElems Alloc  V   Syntax10.Scn.Fnt        I StampElems Alloc 16 Mar 98         "Title": PopupEditor
"Author": Martin Rammerstorfer (MR)
"Abstract": .
"Keywords": popup, PopupElems, elems, edit
"Version": 1
"From":  23.03.97 15:14:03
"Until": 
"Changes": no changes
"Hints":     8  FoldElems New  #   Syntax10.Scn.Fnt         
	LN = 0DX;
 8       8   \  Syntax10.Scn.Fnt       8  FoldElems New  #   Syntax10.Scn.Fnt         
	PanelDesc = RECORD (Dialogs.PanelDesc)
		elemName: ARRAY 32 OF CHAR;
		text: Texts.Text;
		frame: TextFrames.Frame;
		menuF: TextFrames.Frame;
		vwr: Viewers.Viewer;
		dlgFrame: DialogFrames.Frame;
		curLine: LONGINT;
	END; 8       #   
	Panel = POINTER TO PanelDesc;	
 8       8   #   Syntax10.Scn.Fnt  5    5   
	cur: Panel;
	isOpening: BOOLEAN;
	w: Texts.Writer;
 8   0    8   #   Syntax10.Scn.Fnt  E    E   
BEGIN IF val1 < val2 THEN RETURN val1 ELSE RETURN val2 END
END Min;
 8   E    8   #   Syntax10.Scn.Fnt  4   4  
	VAR cmds: PopupElems.CmdElem;
BEGIN
	NEW (cmds); COPY (name, cmds.name); cmds.small := TRUE; cmds.menu := TextFrames.Text ("");
	cmds.handle := PopupElems.Handle;
	Texts.Delete (cmds.menu, 0, cmds.menu.len); Texts.Append (cmds.menu, w.buf);
	PopupElems.MeasureMenu (cmds);
	RETURN cmds
END CreatePopupCmd;
 8   ?    8   #   Syntax10.Scn.Fnt  .   .  
	VAR cmds: PopupElems.Elem;
BEGIN
	NEW (cmds); COPY (name, cmds.name); cmds.small := TRUE; cmds.menu := TextFrames.Text ("");
	cmds.handle := PopupElems.Handle;
	Texts.Delete (cmds.menu, 0, cmds.menu.len); Texts.Append (cmds.menu, w.buf);
	PopupElems.MeasureMenu (cmds);
	RETURN cmds
END CreatePopup;
 8   ?    8   #   Syntax10.Scn.Fnt  N   N  
	VAR i: INTEGER; h, x: LONGINT; valid: BOOLEAN;
BEGIN
	h := 1000000; i := 0; valid := FALSE;
	WHILE h # 0 DO
		x := val DIV h; val := val - h * x; valid := valid OR (x # 0);
		IF valid THEN str [i] := CHR (x + ORD ('0')); INC (i) END;
		h := h DIV 10
	END;
	IF i = 0 THEN str [i] := '0'; INC (i) END;
	str [i] := 0X
END ValToString;
 8       T8   #   Syntax10.Scn.Fnt         
BEGIN
	IF (~isOpening) & (Dialogs.cmdPanel # NIL) & (Dialogs.cmdPanel IS Panel) THEN
		cur := Dialogs.cmdPanel(Panel)
	END
END SetPanel;
 8   %    8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt         +  
	VAR r: Texts.Reader; lCnt, cCnt, lastCnt: LONGINT; beg: LONGINT; ch: CHAR;
BEGIN
	lCnt := 0; cCnt := 0; lastCnt := 0; SetPanel ();
	IF cur = NIL THEN RETURN 0 END;
	Texts.OpenReader (r, cur.text, 0); Texts.Read (r, ch); IF ch = LN THEN INC (lCnt) END;
	WHILE (~r.eot) & (lCnt < cur.curLine) DO
	 	IF ch = LN THEN lastCnt := cCnt + 1 END;
	 	Texts.Read (r, ch); INC (cCnt);
	 	IF ch = LN THEN INC (lCnt) END
	END;
	IF r.eot THEN DEC (cur.curLine); cCnt := lastCnt
	ELSIF (cur.curLine # 0) & (ch = LN) THEN INC (cCnt)
	END;
	RETURN cCnt
END GetLineStart;
 8   3    8   #   Syntax10.Scn.Fnt         
	VAR obj: Dialogs.Object; txt: Texts.Text;
BEGIN
	obj := cur.NamedObject (name);
	txt := obj(DialogTexts.Item).GetText ();
	Texts.Delete (txt, 0, txt.len); Texts.Append (txt, w.buf)
END WriteItemText;
 8   >    _8   #   Syntax10.Scn.Fnt         
	VAR obj: Dialogs.Object;
BEGIN
	obj := cur.NamedObject (name);
	obj(DialogCheckBoxes.Item).ChangeValue (on)
END SetCheckBox;
 8       58     Syntax10.Scn.Fnt      M8  FoldElems New  #   Syntax10.Scn.Fnt         obj: Dialogs.Object; str: ARRAY 10 OF CHAR; cmdElem: PopupElems.CmdElem;
		txt: Texts.Text; r: Texts.Reader; ch: CHAR; end, beg, cmdEnd: LONGINT; 8      8   #   Syntax10.Scn.Fnt  R   R  
		Texts.OpenReader (r, cmdElem.menu, 0); Texts.Read (r, ch);
		WHILE ~r.eot & (ch # LN) DO Texts.Read (r, ch) END;
		Texts.Save (cmdElem.menu, 0, Texts.Pos (r) - 1, w.buf);
		WriteItemText ("Command");
		Texts.Save (cmdElem.menu, Texts.Pos (r), cmdElem.menu.len, w.buf);
		WriteItemText ("Comment");
		SetCheckBox ("CommandCheck", TRUE);Syntax10i.Scn.Fnt      8       g8   #   Syntax10.Scn.Fnt  w    w   
		Texts.OpenBuf (w.buf);
		WriteItemText ("Command"); WriteItemText ("Comment");
		SetCheckBox ("CommandCheck", FALSE)     8       C  
	VAR 
BEGIN
	obj := cur.NamedObject ("LineTextNr");
	ValToString (cur.curLine + 1, str); obj(DialogStaticTexts.Item).SetString (str);
	Texts.Write (w, '"'); Texts.WriteString (w, cur.elemName); Texts.Write (w, '"'); WriteItemText ("Elem");
	beg := GetLineStart (); end := beg; cmdElem := NIL;
	Texts.OpenReader (r, cur.text, beg); Texts.Read (r, ch);
	WHILE (~r.eot) & (ch # LN) & ~((r.elem # NIL) & (r.elem IS PopupElems.CmdElem)) DO
		Texts.Read (r, ch); INC (end)
	END;
	IF (r.elem # NIL) & (r.elem IS PopupElems.CmdElem) THEN
		cmdElem := r.elem(PopupElems.CmdElem);
		cmdEnd := end;
		WHILE (~r.eot) & (ch # LN) DO Texts.Read (r, ch); INC (cmdEnd) END
	END;
	Texts.Save (cur.text, beg, end, w.buf); WriteItemText ("LineText");
	IF cmdElem # NIL THEN	 With command-elem 
	ELSE	 Without command-elem 
	END
END UpdateEntries;
 8   (    8   #   Syntax10.Scn.Fnt  8   8  
	VAR r: Texts.Reader; ch: CHAR; curPos, line: LONGINT;
BEGIN
	Texts.OpenReader (r, cur.text, 0); Texts.Read (r, ch);
	line := 0; curPos := 0;
	WHILE (~r.eot) & (curPos < pos) DO
		IF ch = LN THEN INC (line) END;
		Texts.Read (r, ch); INC (curPos)
	END;
	IF ~r.eot THEN cur.curLine := line END
END SetLineOfPos;
 8      Syntax10b.Scn.Fnt  
        e8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt         Y  
	VAR r: Texts.Reader; cCnt, beg, org, end: LONGINT; ch: CHAR;
BEGIN
	IF cur.frame.hasSel THEN SetLineOfPos (cur.frame.selbeg.pos) END;
	cCnt := GetLineStart ();
	IF cur.vwr.state <= 1 THEN RETURN END;
	beg := cCnt;
	Texts.OpenReader (r, cur.text, cCnt); Texts.Read (r, ch);
	WHILE (~r.eot) & (ch # LN) DO Texts.Read (r, ch); INC (cCnt) END;
	org := cur.frame.org; end := TextFrames.Pos (cur.frame, cur.frame.X + cur.frame.W, cur.frame.Y);
	IF (beg >= end) OR (beg < org) THEN TextFrames.Show (cur.frame, beg) END;
	TextFrames.SetSelection (cur.frame, beg, cCnt + 1);
	UpdateEntries ()
END SetToLine;
 8       	        -8   C   Syntax10.Scn.Fnt  0   Syntax10b.Scn.Fnt      [       
BEGIN
	SetPanel (); IF cur.vwr.state <= 1 THEN RETURN END;
	INC (cur.curLine);
	TextFrames.RemoveSelection (cur.frame); SetToLine
END NextLine;
 8       	        8   C   Syntax10.Scn.Fnt  0   Syntax10b.Scn.Fnt             
BEGIN
	SetPanel (); IF cur.vwr.state <= 1 THEN RETURN END;
	DEC (cur.curLine);
	IF cur.curLine < 0 THEN cur.curLine := 0 END;
	TextFrames.RemoveSelection (cur.frame); SetToLine
END PrevLine;
 8               8     Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt         x, y, res: INTEGER; dlgFrame: DialogFrames.Frame; p: Panel; fr: Files.Rider; file: Files.File;
		textFrame, m: TextFrames.Frame; par: Oberon.ParList; text: Texts.Text; beg, end, time: LONGINT;
		r: Texts.Scanner; ch: CHAR; v: Viewers.Viewer; 8      Syntax10b.Scn.Fnt      @   Syntax10i.Scn.Fnt  %    #   8   Q   8       8   C   Syntax10.Scn.Fnt  D   Syntax10b.Scn.Fnt          3  
		Oberon.GetSelection (text, beg, end, time);
		IF text = NIL THEN RETURN END;
		Texts.OpenReader (r, text, beg); Texts.Read (r, ch);
		IF (r.elem # NIL) & (r.elem IS PopupElems.Elem) THEN
			text := r.elem(PopupElems.Elem).menu; textFrame := NIL;
			COPY (r.elem(PopupElems.Elem).name, cur.elemName)
		END 8       A        &          
	VAR 
BEGIN
	isOpening := TRUE;
	par := Oberon.Par;
	Oberon.AllocateSystemViewer (Oberon.Mouse.X, x, y);
	file := Files.Old ("PopupEditor.Dlg");
	IF file = NIL THEN RETURN END;
	NEW (p); Files.Set (fr, file, 0); p.Load (fr); cur := p;	(* cur must be set to actual panel *)
	NEW (dlgFrame); dlgFrame.Open (DialogFrames.Handle, p);
	IF Files.Old ("Dialog.Menu.Text") = NIL THEN 
		m := TextFrames.NewMenu ("", "System.Close  System.Copy  System.Grow")
	ELSE 
		m := TextFrames.NewMenu ("", "");
		NEW (text); Texts.Open (text, "Dialog.Menu.Text");
		Texts.Save (text, 0, text.len, w.buf); Texts.Append (m.text, w.buf);
	END;
	v := MenuViewers.New (m, dlgFrame, TextFrames.menuH, x, y);
	IF p.cmd[0] # 0X THEN 
		Dialogs.cmdPanel := p; 
		Oberon.Call (p.cmd, Oberon.Par, FALSE, res)
	END;
	IF par.vwr.dsc = par.frame THEN	
		textFrame := par.frame.next(TextFrames.Frame);
		text := textFrame.text;
		Texts.OpenScanner (r, par.frame(TextFrames.Frame).text, 0); Texts.Scan (r);
		IF (r.class = Texts.Name) OR (r.class = Texts.String) THEN COPY (r.s, p.elemName)
		ELSE p.elemName := ""
		END;
		Texts.WriteString (w, p.elemName); Texts.Insert (m.text, 0, w.buf)
	ELSE HALT (99)	(*  *)
	END;
	p.curLine := 0; p.text := text; p.frame := textFrame; cur := p; p.dlgFrame := dlgFrame;
	p.vwr := par.vwr; p.menuF := par.frame(TextFrames.Frame);
	SetToLine;	(* isOpening must be TRUE => cur is not set from last cmdPanel *)
	isOpening := FALSE (* TRUE during opening a new dialog *)
END Open;
 8   3    *8   #   Syntax10.Scn.Fnt         
	VAR obj: Dialogs.Object; txt: Texts.Text;
BEGIN
	obj := cur.NamedObject (name);
	txt := obj(DialogTexts.Item).GetText ();
	Texts.Save (txt, 0, txt.len, w.buf)
END ReadItemTexts;
 8   %    8     Syntax10.Scn.Fnt      G8  FoldElems New  #   Syntax10.Scn.Fnt         obj: Dialogs.Object; str: ARRAY 10 OF CHAR; cmdElem: PopupElems.CmdElem;
		txt: Texts.Text; s: Texts.Scanner; ch: CHAR; end, beg, cmdEnd, len: LONGINT; 8        
	VAR 
BEGIN
	ReadItemTexts ("LineText"); len := w.buf.len; Texts.Insert (cur.text, pos, w.buf); INC (pos, len);
	obj := cur.NamedObject ("CommandCheck");
	IF obj(DialogCheckBoxes.Item).on THEN
		ReadItemTexts ("Command"); Texts.WriteLn (w);
		ReadItemTexts ("Comment");
		cmdElem := CreatePopupCmd ("");
		Texts.WriteElem (w, cmdElem); Texts.Insert (cur.text, pos, w.buf); INC (pos);
	END;
	Texts.WriteLn (w); Texts.Insert (cur.text, pos, w.buf)
END WriteLine;
 8               48   C   Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt      ~     
	VAR r: Texts.Reader; cCnt, beg, org, end: LONGINT; ch: CHAR;
BEGIN
	IF (Dialogs.cmdPanel IS Panel) & Dialogs.cmdPanel(Panel).frame.hasSel THEN
		SetLineOfPos (Dialogs.cmdPanel(Panel).frame.selbeg.pos)
	END;
	cCnt := GetLineStart (); IF cur.vwr.state <= 1 THEN RETURN END;
	beg := cCnt;
	Texts.OpenReader (r, cur.text, cCnt); Texts.Read (r, ch);
	WHILE (~r.eot) & (ch # LN) DO Texts.Read (r, ch); INC (cCnt) END;
	org := cur.frame.org; end := TextFrames.Pos (cur.frame, cur.frame.X + cur.frame.W, cur.frame.Y);
	Texts.Delete (cur.text, beg, cCnt + 1);
	WriteLine (beg);
	TextFrames.SetSelection (cur.frame, beg, beg + 1);
	SetToLine
END UpdateLine;
 8               :8   Y  Syntax10.Scn.Fnt      @8  FoldElems New  #   Syntax10.Scn.Fnt         
		VAR r: Texts.Reader; ch: CHAR;
	BEGIN
		Texts.OpenReader (r, txt, pos); Texts.Read (r, ch);
		IF ch # '"' THEN Texts.Write (w, '"') END;
	END CheckQuotes;
 8   =   Syntax10b.Scn.Fnt         Syntax10i.Scn.Fnt  $    f   n  
	VAR dummy, len: LONGINT; obj: Dialogs.Object; txt: Texts.Text; s: Texts.Scanner; ch: CHAR;
	PROCEDURE CheckQuotes (VAR txt: Texts.Text; pos: LONGINT);	
BEGIN
	dummy := GetLineStart (); IF cur.vwr.state <= 1 THEN RETURN END;	(* If viewer is closed: no update *)
	Oberon.Par.frame := cur.menuF;
	Oberon.Par.vwr := cur.vwr;
	obj := cur.NamedObject ("Elem"); txt := obj(DialogTexts.Item).GetText ();
	CheckQuotes (txt, 0); len := Min (txt.len, 31);
	Texts.Save (txt, 0, len, w.buf);
	Texts.OpenScanner (s, txt, 0); Texts.Scan (s);
	COPY (s.s, cur.elemName);
	CheckQuotes (txt, len - 1);
	Texts.OpenScanner (s, cur.menuF.text, 0); Texts.Scan (s);
	IF s.class = Texts.Name THEN Texts.Delete (cur.menuF.text, 0, s.len)
	ELSIF s.class = Texts.String THEN Texts.Delete (cur.menuF.text, 0, s.len + 2)
	END;
	Texts.Insert (cur.menuF.text, 0, w.buf);
	PopupElems.Update
END UpdateElem;
 8               8   "  Syntax10.Scn.Fnt      W8  FoldElems New  #   Syntax10.Scn.Fnt         cCnt: LONGINT; elem: PopupElems.Elem; r: Texts.Reader; ch: CHAR;
		txt: Texts.Text; beg, end, time, i: LONGINT; name: ARRAY 32 OF CHAR; 8      Syntax10b.Scn.Fnt      j   @  
	VAR 
BEGIN
	IF (Dialogs.cmdPanel IS Panel) & Dialogs.cmdPanel(Panel).frame.hasSel THEN
		SetLineOfPos (Dialogs.cmdPanel(Panel).frame.selbeg.pos)
	END;
	cCnt := GetLineStart (); IF cur.vwr.state <= 1 THEN RETURN END;
	Oberon.GetSelection (txt, beg, end, time);
	Texts.OpenReader (r, txt, beg);
	FOR i := 0 TO Min (end - beg, 31) - 1 DO
		Texts.Read (r, ch); name [i] := ch
	END;
	name [i] := 0X;
	elem := CreatePopup (name);
	Texts.WriteElem (w, elem);
	Texts.Insert (cur.text, cCnt, w.buf);
	TextFrames.SetSelection (cur.frame, cCnt, cCnt + 1);
	SetToLine
END InsertElem;
 8               8     Syntax10.Scn.Fnt      u8  FoldElems New  #   Syntax10.Scn.Fnt  i    i   cCnt: LONGINT; cmdElem: PopupElems.CmdElem; s: Texts.Scanner;
		txt: Texts.Text; beg, end, time: LONGINT; 8      Syntax10b.Scn.Fnt         ]  
	VAR 
BEGIN
	IF (Dialogs.cmdPanel IS Panel) & Dialogs.cmdPanel(Panel).frame.hasSel THEN
		SetLineOfPos (Dialogs.cmdPanel(Panel).frame.selbeg.pos)
	END;
	cCnt := GetLineStart (); IF cur.vwr.state <= 1 THEN RETURN END;
	Oberon.GetSelection (txt, beg, end, time);
	Texts.OpenScanner (s, txt, beg); Texts.Scan (s);
	IF (s.class = Texts.Name) OR (s.class = Texts.String) THEN
		cmdElem := CreatePopupCmd (s.s)
	ELSE cmdElem := CreatePopupCmd ("")
	END;
	Texts.WriteElem (w, cmdElem);
	Texts.Insert (cur.text, cCnt, w.buf);
	TextFrames.SetSelection (cur.frame, cCnt, cCnt + 1);
	SetToLine
END InsertCmdElem;
 8               J8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt          t  
	VAR cCnt: LONGINT;
BEGIN
	IF (Dialogs.cmdPanel IS Panel) & Dialogs.cmdPanel(Panel).frame.hasSel THEN
		SetLineOfPos (Dialogs.cmdPanel(Panel).frame.selbeg.pos)
	END;
	cCnt := GetLineStart (); IF cur.vwr.state <= 1 THEN RETURN END;
	Texts.WriteLn (w);
	Texts.Insert (cur.text, cCnt, w.buf);
	TextFrames.SetSelection (cur.frame, cCnt, cCnt + 1);
	SetToLine
END InsertLine;
 8       8   #   Syntax10.Scn.Fnt  '    '   
BEGIN
	Texts.OpenWriter (w)
END Init;
 8         MODULE PopupEditor;	(** MR  *)

IMPORT Dialogs, DialogFrames, Oberon, PopupElems, Files, Texts, TextFrames, Display, Viewers,
				MenuViewers, DialogStaticTexts, DialogTexts, DialogCheckBoxes, MW := MsgWindows, Strings;

CONST	
TYPE	
VAR	

PROCEDURE Min (val1, val2: LONGINT): LONGINT;	
PROCEDURE CreatePopupCmd (name: ARRAY OF CHAR): PopupElems.CmdElem;	
PROCEDURE CreatePopup (name: ARRAY OF CHAR): PopupElems.Elem;	
PROCEDURE ValToString (val: LONGINT; VAR str: ARRAY OF CHAR);	
PROCEDURE SetPanel ();	
PROCEDURE GetLineStart (): LONGINT;	
PROCEDURE WriteItemText (name: ARRAY 16 OF CHAR);	
PROCEDURE SetCheckBox (name: ARRAY 16 OF CHAR; on: BOOLEAN);	
PROCEDURE UpdateEntries ();	
PROCEDURE SetLineOfPos (pos: LONGINT);	
PROCEDURE SetToLine*;	
PROCEDURE NextLine*;	
PROCEDURE PrevLine*;	
PROCEDURE Open*;	
PROCEDURE ReadItemTexts (name: ARRAY 16 OF CHAR);	
PROCEDURE WriteLine (pos: LONGINT);	
PROCEDURE UpdateLine*;	
PROCEDURE UpdateElem*;	
PROCEDURE InsertElem*;	
PROCEDURE InsertCmdElem*;	
PROCEDURE InsertLine*;	

PROCEDURE Init ();	

BEGIN Init ()
END PopupEditor.

PopupEditor.Open
System.Free PopupEditor ~
Dialog.Open PopupEditor.Dlg ~

Dialog.Edit PopupEditor.Dlg ~