#   Syntax10.Scn.Fnt       MODULE Out;	(* HM 18 March 1994 *)

IMPORT Display, Viewers, Texts, TextFrames, MenuViewers, Oberon;

VAR
	out: Texts.Text;
	v: Viewers.Viewer;
	w: Texts.Writer;


PROCEDURE Open*;
	VAR x, y: INTEGER;
BEGIN
	Oberon.AllocateSystemViewer(0, x, y);
	out := TextFrames.Text("");
	v := MenuViewers.New(
		TextFrames.NewMenu("Standard Output",
			"^Out.Menu.Text"),
		TextFrames.NewText(out, 0),
		TextFrames.menuH, x, y)
END Open;

PROCEDURE Close*;
BEGIN
	out := Oberon.Log; v := NIL
END Close;

PROCEDURE CheckOpen;
BEGIN
	IF (out # Oberon.Log) & (v.state = 0) THEN Open END
END CheckOpen;

PROCEDURE CheckScroll (t: Texts.Text);
	VAR x: INTEGER; v: Viewers.Viewer; f: Display.Frame; f1: TextFrames.Frame; r: Texts.Reader; ch: CHAR;
BEGIN
	x := 0;
	WHILE x < Display.Width DO
		v := Viewers.This(x, 0);
		WHILE v.state > 1 DO
			f := v.dsc;
			WHILE (f # NIL) & (f IS TextFrames.Frame) DO
				f1 := f(TextFrames.Frame);
				IF (f1.text = t) & (f1.H > 0) THEN
					WHILE t.len > TextFrames.Pos(f1, f1.X + f1.W - 1, f1.Y + 1) DO
						Texts.OpenReader(r, t, f1.org);
						REPEAT Texts.Read(r, ch) UNTIL r.eot OR (ch = 0DX);
						TextFrames.Show(f1, Texts.Pos(r));
					END
				END ;
				f := f.next
			END ;
			v := Viewers.Next(v)
		END ;
		x := x + v.W
	END
END CheckScroll;


(*commands*)

PROCEDURE Char* (ch: CHAR);
BEGIN
	CheckOpen; Texts.Write(w, ch); Texts.Append(out, w.buf)
END Char;

PROCEDURE Int* (i, n: LONGINT);
BEGIN
	CheckOpen; Texts.WriteInt(w, i, n); Texts.Append(out, w.buf)
END Int;

PROCEDURE Real* (r: REAL; n: INTEGER);
BEGIN
	CheckOpen; Texts.WriteReal(w, r, n); Texts.Append(out, w.buf)
END Real;

PROCEDURE LongReal* (r: LONGREAL; n: INTEGER);
BEGIN
	CheckOpen; Texts.WriteLongReal(w, r, n); Texts.Append(out, w.buf)
END LongReal;

PROCEDURE Ln*;
	VAR f: TextFrames.Frame;
BEGIN
	CheckOpen; Texts.WriteLn(w); Texts.Append(out, w.buf);
	CheckScroll(out)
END Ln;

PROCEDURE String* (s: ARRAY OF CHAR);
	VAR i: INTEGER;
BEGIN
	CheckOpen; i := 0;
	WHILE s[i] # 0X DO
		IF s[i] = "$" THEN Ln ELSE Texts.Write(w, s[i]) END ;
		INC(i)
	END ;
	Texts.Append(out, w.buf)
END String;

PROCEDURE F0 (s: ARRAY OF CHAR; x: ARRAY OF LONGINT);
	VAR i, j: INTEGER;
BEGIN
	CheckOpen; i := 0; j := 0;
	WHILE s[i] # 0X DO
		IF s[i] = "$" THEN Ln
		ELSIF s[i] = "#" THEN Int(x[j], 0); INC(j)
		ELSE Texts.Write(w, s[i])
		END ;
		INC(i)
	END ;
	Texts.Append(out, w.buf)
END F0;

PROCEDURE F* (s: ARRAY OF CHAR; x: LONGINT);
	VAR a: ARRAY 4 OF LONGINT;
BEGIN
	a[0] := x; F0(s, a)
END F;

PROCEDURE F2* (s: ARRAY OF CHAR; x, y: LONGINT);
	VAR a: ARRAY 4 OF LONGINT;
BEGIN
	a[0] := x; a[1] := y; F0(s, a)
END F2;

PROCEDURE F3* (s: ARRAY OF CHAR; x, y, z: LONGINT);
	VAR a: ARRAY 4 OF LONGINT;
BEGIN
	a[0] := x; a[1] := y; a[2] := z; F0(s, a)
END F3;

PROCEDURE F4* (s: ARRAY OF CHAR; x, y, z, u: LONGINT);
	VAR a: ARRAY 4 OF LONGINT;
BEGIN
	a[0] := x; a[1] := y; a[2] := z; a[3] := u; F0(s, a)
END F4;

BEGIN
	Texts.OpenWriter(w); out := Oberon.Log; v := NIL
END Out.
