  Syntax10.Scn.Fnt      @ I StampElems Alloc 11 Dec 95    Syntax10b.Scn.Fnt              (            
    %           Syntax10i.Scn.Fnt      %            8  FoldElems New  #   Syntax10.Scn.Fnt  4    4   
BEGIN
	t.Read^(r); Files.ReadNum(r, t.n)
END Read;
 8               8   #   Syntax10.Scn.Fnt  7    7   
BEGIN
	t.Write^(r); Files.WriteNum(r, t.n)
END Write;
 8           )            8   #   Syntax10.Scn.Fnt  6    6   
BEGIN
	b.Read^(r); Files.ReadNum(r, b.key)
END Read;
 8               8   #   Syntax10.Scn.Fnt  9    9   
BEGIN
	b.Write^(r); Files.WriteNum(r, b.key)
END Write;
 8               8   #   Syntax10.Scn.Fnt  L   L  
	VAR a, b, c, d, u, v, z, x, y, w, h, i: INTEGER;
BEGIN
	IF but.cmd = "^" THEN
		x := but.p[0].x; IF but.p[1].x < x THEN x := but.p[1].x END;
		y := but.p[0].y; IF but.p[1].y < y THEN y := but.p[1].y END;
		w := ABS(but.p[1].x - but.p[0].x); h := ABS(but.p[0].y - but.p[1].y);
		i := w DIV 5; a := x + i; b := a + i; d := x + w - i; c := d - i;
		i := h DIV 6; u := y + i; v := y + 3*i; z := y + h - i;
		p.DrawLine(b, u, c, u, Display.white, Display.replace);
		p.DrawLine(c, u, c, v, Display.white, Display.replace);
		p.DrawLine(c, v, d, v, Display.white, Display.replace);
		p.DrawLine(d, v, (b+c) DIV 2, z, Display.white, Display.replace);
		p.DrawLine(a, v, (b+c) DIV 2, z, Display.white, Display.replace);
		p.DrawLine(a, v, b, v, Display.white, Display.replace);
		p.DrawLine(b, v, b, u, Display.white, Display.replace)
	END
END Draw;
 8               $8   #   Syntax10.Scn.Fnt         
BEGIN
	IF keys = {MM} THEN
		LinkElems.FollowLink(b.par, b.key, NIL, NIL)
	ELSIF keys = {MM, MR} THEN
		Out.String(b.par); Out.String("  "); Out.Int(b.key, 0); Out.Ln
	END
END Execute;
 8           Q    E8   C   Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt      Z    y  
	VAR x: INTEGER; s: Texts.Scanner;
BEGIN
	x := 0;
	WHILE x < Display.Width DO
		v := Viewers.This(x, 0);
		WHILE v.state > 1 DO
			IF (v.dsc # NIL) & (v.dsc IS TextFrames.Frame) THEN
				Texts.OpenScanner(s, v.dsc(TextFrames.Frame).text, 0); Texts.Scan(s);
				IF s.s = name THEN RETURN END
			END;
			v := Viewers.Next(v)
		END;
		x := x + v.W
	END;
	v := NIL
END GetViewer;
 8   K    8   #   Syntax10.Scn.Fnt  	   	  
	VAR v: Viewers.Viewer; f: Display.Frame; s: Texts.Scanner; x: INTEGER; 
BEGIN
	x := 0;
	WHILE x < Display.Width DO
		v := Viewers.This(x, 0);
		WHILE v.state > 1 DO
			f := v.dsc.next;
			IF (f # NIL) & (f IS KeplerFrames.Frame) & (f(KeplerFrames.Frame).G = g) THEN
				Texts.OpenScanner(s, v.dsc(TextFrames.Frame).text, 0); Texts.Scan(s);
				IF s.class IN {Texts.Name, Texts.String} THEN COPY(s.s, name) ELSE name[0] := 0X END;
				RETURN
			END;
			v := Viewers.Next(v)
		END;
		x := x + v.W
	END
END GetViewerName;
 8   G    8   #   Syntax10.Scn.Fnt       
	VAR v: Viewers.Viewer; f: Display.Frame; s: Texts.Scanner; x: INTEGER; 
BEGIN
	x := 0;
	WHILE x < Display.Width DO
		v := Viewers.This(x, 0);
		WHILE v.state > 1 DO
			f := v.dsc.next;
			IF (f # NIL) & (f IS TextFrames.Frame) & (f(TextFrames.Frame).text = t) THEN
				Texts.OpenScanner(s, v.dsc(TextFrames.Frame).text, 0); Texts.Scan(s);
				IF s.class IN {Texts.Name, Texts.String} THEN COPY(s.s, name) ELSE name[0] := 0X END;
				RETURN
			END;
			v := Viewers.Next(v)
		END;
		x := x + v.W
	END
END GetTextViewerName;
 8   ;    8   C   Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt      ,      
	VAR v: Viewers.Viewer; g: KeplerGraphs.Graph; f: KeplerFrames.Frame; x, y: INTEGER; c: KeplerGraphs.Constellation; i: INTEGER;
BEGIN
	GetViewer(file, v);
	IF v = NIL THEN
		g := KeplerGraphs.Old(file);
		IF g = NIL THEN NEW(g) END;
		f := KeplerFrames.New(g);
		Oberon.AllocateUserViewer(Oberon.Mouse.X, x, y);
		v := MenuViewers.New(TextFrames.NewMenu(file, keplerMenu), f, TextFrames.menuH, x, y)
	ELSE f := v.dsc.next(KeplerFrames.Frame)
	END;
	g := f.G; f.Neutralize;
	c := g.cons;
	WHILE c # NIL DO
		IF (c IS Target) & (c(Target).n = key) THEN
			FOR i := 0 TO c.nofpts-1 DO
				IF ~c.p[i].sel THEN g.FlipSelection(c.p[i]) END
			END;
			RETURN
		END;
		c := c.next
	END;
END FollowLink;
 8           )    8   #   Syntax10.Scn.Fnt  N   N  
	VAR e1: LinkElem;
BEGIN
	WITH e: LinkElem DO
		WITH m: Texts.CopyMsg DO
			IF m.e = NIL THEN NEW(e1); m.e := e1 END;
			LinkElems.Handle(e, m)
		|m: Texts.IdentifyMsg DO
			m.mod := "KeplerLinks"; m.proc := "Alloc"
		| m: LinkElems.FollowMsg DO
			FollowLink(e.file, e.key)
		ELSE LinkElems.Handle(e, m)
		END
	END
END LinkHandler;
 8                       8   #   Syntax10.Scn.Fnt  U    U   
	VAR e: LinkElem;
BEGIN
	NEW(e); e.handle := LinkHandler; Texts.new := e
END Alloc;
 8               U8   _   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt                          M  
	VAR g: KeplerGraphs.Graph; c, sel: KeplerGraphs.Constellation; targ: Target; i: INTEGER; m: TextFrames.InsertElemMsg;
		name: ARRAY 32 OF CHAR; link: LinkElem;
BEGIN
	g := KeplerFrames.Focus;
	(*--- find selected constellation*)
	c := g.cons; sel := NIL;
	WHILE (c # NIL) & (sel = NIL) DO
		IF c.State() > 0 THEN sel := c END;
		c := c.next
	END;
	IF sel = NIL THEN Out.String("-- no constellation selected$"); RETURN END;
	(*--- allocate target constellation*)
	NEW(targ); targ.n := Oberon.Time();
	targ.nofpts := sel.nofpts;
	FOR i := 0 TO sel.nofpts-1 DO targ.p[i] := sel.p[i]; INC(targ.p[i].refcnt) END;
	g.Append(targ);
	(*--- create link element*)
	NEW(link); link.W := 10 * pixel; link.H := 11 * pixel; link.handle := LinkHandler; GetViewerName(g, link.file); link.key := targ.n;
	m.e := link; Viewers.Broadcast(m);
END TextToGraphics;
 8               18   #   Syntax10.Scn.Fnt       
	VAR link: LinkButton; mark: MarkElems.Elem; t: Texts.Text; beg, end, time: LONGINT; r: Texts.Reader; ch: CHAR;
		g: KeplerGraphs.Graph; s: ARRAY 32 OF CHAR;
BEGIN
	Oberon.GetSelection(t, beg, end, time);
	IF KeplerFrames.nofpts >= 2 THEN
		IF time > 0 THEN
			g := KeplerFrames.Focus;
			NEW(link); link.nofpts := 2;
			KeplerFrames.ConsumePoint(link.p[0]); KeplerFrames.ConsumePoint(link.p[1]);
			In.Open; In.Name(s);
			IF In.Done & (s = "arrow") THEN link.cmd := "^" END;
			GetTextViewerName(t, link.par);
			Texts.OpenReader(r, t, beg); Texts.Read(r, ch);
			IF (ch = Texts.ElemChar) & (r.elem IS MarkElems.Elem) THEN
				link.key := r.elem(MarkElems.Elem).key
			ELSE
				mark := MarkElems.New(); link.key := mark.key;
				Texts.WriteElem(w, mark); Texts.Insert(t, beg, w.buf)
			END;
			g.Append(link)
		ELSE Out.String("-- no target point selected$")
		END
	ELSE Out.String("-- 2 focus points required$")
	END
END GraphicsToText;
 8   .    i  MODULE KeplerLinks;	(* HM  *)
IMPORT Display, Files, Viewers, Texts, TextFrames, MenuViewers, Oberon,
	KeplerPorts, KeplerGraphs, KeplerFrames, LinkElems, MarkElems, In, Out;

CONST
	ML = 2; MM = 1; MR = 0;
	pixel = LONG(10000);
	keplerMenu = "System.Close  System.Copy  System.Grow  Kepler.Store ";

TYPE
	LinkElem* = POINTER TO LinkDesc;
	LinkDesc* = RECORD (LinkElems.ElemDesc) END ;

	Target* = POINTER TO TargetDesc;
	TargetDesc* = RECORD (KeplerGraphs.ConsDesc)
		n*: LONGINT
	END ;

	LinkButton = POINTER TO LinkButtonDesc;
	LinkButtonDesc = RECORD (KeplerFrames.ButtonDesc)
		(*field par is used for the file name*)
		key: LONGINT
	END ;

VAR
	w: Texts.Writer;

(*---------- Target methods ----------*)

PROCEDURE (t: Target) Read* (VAR r: Files.Rider);	
PROCEDURE (t: Target) Write* (VAR r: Files.Rider);	

(*---------- LinkButton methods ----------*)

PROCEDURE (b: LinkButton) Read* (VAR r: Files.Rider);	
PROCEDURE (b: LinkButton) Write* (VAR r: Files.Rider);	
PROCEDURE (but: LinkButton) Draw* (p: KeplerPorts.Port);	
PROCEDURE (b: LinkButton) Execute* (keys: SET);	

(*---------- Auxiliaries ----------*)

PROCEDURE GetViewer (name: ARRAY OF CHAR; VAR v: Viewers.Viewer);	
PROCEDURE GetViewerName (g: KeplerGraphs.Graph; VAR name: ARRAY OF CHAR);	
PROCEDURE GetTextViewerName (t: Texts.Text; VAR name: ARRAY OF CHAR);	
PROCEDURE FollowLink (file: ARRAY OF CHAR; key: LONGINT);	
PROCEDURE LinkHandler* (e: Texts.Elem; VAR m: Texts.ElemMsg);	

(*---------- Commands ----------*)

PROCEDURE Alloc*;	
PROCEDURE TextToGraphics*;	
PROCEDURE GraphicsToText*;	

BEGIN
	Texts.OpenWriter(w)
END KeplerLinks.
