  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt  	      StampElems Alloc 10 Jun 97      u            Syntax10b.Scn.Fnt                  8  FoldElems New  #   Syntax10.Scn.Fnt         
END NoNotify;
 8   >    ^8   #   Syntax10.Scn.Fnt         
	VAR a: MarkElem;
BEGIN
	IF m IS Texts.CopyMsg THEN NEW(a); Texts.CopyElem(e, a); m(Texts.CopyMsg).e := a END
END MarkHandler;
 8   *    8   #   Syntax10.Scn.Fnt  (    (   
BEGIN
	RETURN e IS MarkElem
END Check;
 8   ,    8   #   Syntax10.Scn.Fnt         
BEGIN
	IF (Oberon.FocusViewer # NIL) & (Oberon.FocusViewer.dsc.next IS TextFrames.Frame) THEN
		RETURN Oberon.FocusViewer.dsc.next(TextFrames.Frame)
	ELSE Out.String("-- there is no focus viewer$"); RETURN NIL
	END
END FocusFrame;
 8   M    ^8   #   Syntax10.Scn.Fnt       
	VAR r: Texts.Reader; ch: CHAR; s: Texts.Scanner;
BEGIN
	color := -1;
	Texts.OpenReader(r, t, 0); Texts.Read(r, ch);
	WHILE (ch # 0X) & (r.col # markColor) DO Texts.Read(r, ch) END;
	IF ch # 0X THEN
		pos := Texts.Pos(r) - 1;
		Texts.OpenScanner(s, t, pos); Texts.Scan(s);
		IF (s.class = Texts.Int) & (s.i > 15) & (s.i < 128) THEN color := SHORT(SHORT(s.i)) END
	END
END GetOldCol;
 8   I    8   #   Syntax10.Scn.Fnt         
	VAR s: Texts.Scanner;
BEGIN
	color := -1;
	Texts.OpenScanner(s, t, pos); Texts.Scan(s);
	IF (s.class = Texts.Int) & (s.i > 15) & (s.i < 128) THEN color := SHORT(SHORT(s.i)) END
END GetNewCol;
 8   ;    +8   #   Syntax10.Scn.Fnt         
	VAR r: Texts.Reader; ch: CHAR;
BEGIN
	Texts.OpenReader(r, t, beg); Texts.Read(r, ch); 
	WHILE (ch # 0X) & (ch # 0DX) DO Texts.Read(r, ch) END;
	RETURN Texts.Pos(r)
END LineEnd;
 8   7    B8   #   Syntax10.Scn.Fnt       
	VAR r: Texts.Reader; beg, end, pos: LONGINT; ch: CHAR;
BEGIN
	Texts.OpenReader(r, t, 0);
	Texts.Read(r, ch); pos := 1;
	WHILE ch # 0X DO
		WHILE (ch # 0X) & (r.col # from) DO Texts.Read(r, ch); INC(pos) END;
		beg := pos - 1; 
		WHILE (ch # 0X) & (r.col = from) DO Texts.Read(r, ch); INC(pos) END;
		end := pos - 1;
		IF end > beg THEN
			Texts.ChangeLooks(t, beg, end, {1}, NIL, to, 0)
		END
	END
END Change;
 8   C    %8   #   Syntax10.Scn.Fnt       
	VAR oldColor, newColor: SHORTINT; oldPos: LONGINT; notify: Texts.Notifier;
BEGIN
	GetOldCol(e.menu, oldPos, oldColor); GetNewCol(e.menu, newPos, newColor);
	notify := f.text.notify; f.text.notify := NoNotify;
	FoldElems.ExpandAll(f.text, 0, TRUE);
	IF oldColor > 0 THEN
		Change(f.text, markColor, oldColor);
		Texts.ChangeLooks(e.menu, oldPos, LineEnd(e.menu, oldPos), {1}, NIL, 15, 0)
	END;
	IF newColor > 0 THEN
		Change(f.text, newColor, markColor);
		Texts.ChangeLooks(e.menu, newPos, LineEnd(e.menu, newPos), {1}, NIL, markColor, 0)
	END;
	FoldElems.CollapseAll(f.text, {FoldElems.tempLeft});
	f.text.notify := notify;
	f.text.notify(f.text, TextFrames.replace, 0, f.text.len)
END Switch;
 8   5    8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      G       
	VAR end, delta: LONGINT;
BEGIN delta := 200;
	LOOP end := TextFrames.Pos(f, f.X + f.W, f.Y);
		IF (f.org <= pos) & (pos < end) OR (f.org = end) THEN EXIT END;
		TextFrames.Show(f, pos - delta); DEC(delta, 20)
	END
END Show;
 8           )    8   #   Syntax10.Scn.Fnt  V   V  
	VAR e1: Elem;
BEGIN
	WITH e: Elem DO
		WITH m: Texts.CopyMsg DO
			IF m.e = NIL THEN NEW(e1); m.e := e1 END;
			PopupElems.Handle(e, m)
		| m: Texts.IdentifyMsg DO
			m.mod := "HistoryElems"; m.proc := "New";
		| m: PopupElems.ExecMsg DO Switch(e, m.pos, m.frame(TextFrames.Frame))
			
		ELSE PopupElems.Handle(e, m)
		END
	END
END Handle;
 8               8   #   Syntax10.Scn.Fnt  K    K   
	VAR e: Elem;
BEGIN
	NEW(e); e.handle := Handle; Texts.new := e;
END New;
 8               E8   #   Syntax10.Scn.Fnt       
	VAR e: Elem; insert: TextFrames.InsertElemMsg; f: TextFrames.Frame; r: Texts.Reader;
BEGIN
	f := FocusFrame();
	IF f # NIL THEN
		Texts.OpenReader(r, f.text, 0);
		REPEAT Texts.ReadElem(r) UNTIL r.eot OR (r.elem IS Elem);
		IF r.eot THEN
			NEW(e); e.handle := Handle; e.name := "History"; e.small := TRUE;
			e.menu := TextFrames.Text("");
			Texts.WriteInt(w, 16, 0); Texts.WriteString(w, ": "); Texts.Append(e.menu, w.buf);
			Texts.ChangeLooks(e.menu, 0, e.menu.len, {1}, NIL, markColor, 0);
			PopupElems.MeasureMenu(e);
			insert.e := e; Viewers.Broadcast(insert)
		ELSE Out.String("-- there is already a color element in the text$")
		END
	END
END Insert;
 8               8   Q   Syntax10.Scn.Fnt    Syntax10i.Scn.Fnt                  ,  
	VAR f: TextFrames.Frame; pos: LONGINT; r: Texts.Reader; ch: CHAR; old: Texts.Notifier; e: MarkElem; e0: Texts.Elem;
BEGIN
	f := FocusFrame();
	IF f # NIL THEN
		IF f.hasCar THEN pos := f.carloc.pos ELSE pos := 0 END;
		old := f.text.notify; f.text.notify := NoNotify;
		FoldElems.ExpandAll(f.text, pos, TRUE);
		Texts.OpenReader(r, f.text, pos); Texts.Read(r, ch);
		WHILE (ch # 0X) & (r.col = markColor) DO Texts.Read(r, ch) END; (*skip this text stretch*)
		WHILE (ch # 0X) & (r.col # markColor) DO Texts.Read(r, ch) END;
		IF ch # 0X THEN
			NEW(e); e.W := 0; e.H := 0; e.handle := MarkHandler;
			Texts.WriteElem(w, e); Texts.Insert(f.text, Texts.Pos(r)-1, w.buf)
		END;
		FoldElems.CollapseAll(f.text, {FoldElems.tempLeft});
		f.text.notify := old;
		IF ch # 0X THEN
			FoldElems.FindElem(f.text, pos, Check, e0);
			pos := Texts.ElemPos(e0);
			IF e0 = e (*FindElem did not expand anything*) THEN f.text.notify := NoNotify END;
			Texts.Delete(f.text, pos, pos+1);
			f.text.notify := old;
			Show(f, pos); TextFrames.SetCaret(f, pos)
		END
	END
END ShowMark;
 8               8   #   Syntax10.Scn.Fnt  ^   ^  
	VAR v: Viewers.Viewer; f: TextFrames.Frame; old, new: INTEGER; notify: Texts.Notifier; r: Texts.Reader;
BEGIN
	In.Open; In.Int(old); In.Int(new);
	v := Oberon.MarkedViewer();
	IF In.Done & (old > 0) & (old < 16) & (new > 0) & (new < 16) & (v # NIL) & (v.dsc.next IS TextFrames.Frame) THEN
		f := v.dsc.next(TextFrames.Frame);
		(*--- change color in text*)
		notify := f.text.notify; f.text.notify := NoNotify;
		FoldElems.ExpandAll(f.text, 0, TRUE);
		Change(f.text, SHORT(old), SHORT(new));
		FoldElems.CollapseAll(f.text, {FoldElems.tempLeft});
		f.text.notify := notify;
		f.text.notify(f.text, TextFrames.replace, 0, f.text.len);
		(*--- chage color in element*)
		Texts.OpenReader(r, f.text, 0);
		REPEAT Texts.ReadElem(r) UNTIL r.eot OR (r.elem IS Elem);
		IF ~r.eot THEN
			Change(r.elem(Elem).menu, SHORT(old), SHORT(new))
		END
	END
END ChangeColor;
 8                                                                      	        
                        
             2    g  MODULE HistoryElems;	(** HM /  **)
IMPORT Display, Files, Viewers, Texts, TextFrames, Oberon, PopupElems, FoldElems, In, Out;

CONST
	markColor = 1;	(*red*)
	pixel = LONG(10000);

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (PopupElems.ElemDesc)
	END;
	MarkElem = POINTER TO MarkElemDesc;
	MarkElemDesc = RECORD (Texts.ElemDesc) END;
	
VAR
	icon: Display.Pattern;
	w: Texts.Writer;

PROCEDURE NoNotify (t: Texts.Text; op: INTEGER; beg, end: LONGINT);	
PROCEDURE MarkHandler (e: Texts.Elem; VAR m: Texts.ElemMsg);	
PROCEDURE Check(e: Texts.Elem): BOOLEAN;	
PROCEDURE FocusFrame (): TextFrames.Frame;	
PROCEDURE GetOldCol (t: Texts.Text; VAR pos: LONGINT; VAR color: SHORTINT);	
PROCEDURE GetNewCol (t: Texts.Text; pos: LONGINT; VAR color: SHORTINT);	
PROCEDURE LineEnd (t: Texts.Text; beg: LONGINT): LONGINT;	
PROCEDURE Change (t: Texts.Text; from, to: SHORTINT);	
PROCEDURE Switch (e: Elem; newPos: LONGINT; f: TextFrames.Frame);	
PROCEDURE Show (f: TextFrames.Frame; pos: LONGINT);	
PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);	

PROCEDURE New*;	
PROCEDURE Insert*;	
PROCEDURE ShowMark*;	
PROCEDURE ChangeColor*;	

BEGIN
	Texts.OpenWriter(w)
END HistoryElems.

HistoryElems.Insert
HistoryElems.ShowMark
HistoryElems.ChangeColor ^	1 3	3 1	1 2	2 1
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15

System.Free HistoryElems ~
System.SetColor 1
