  Syntax10.Scn.Fnt  '    @ I StampElems Alloc 16 Oct 98  J   Syntax10b.Scn.Fnt              R   Syntax10i.Scn.Fnt  ?    "    
    %    	    |   
       
                           Y        w   
  MODULE HandlerElems; (* HM 13 Oct 94 / *)
IMPORT Display, Viewers, Texts, TextFrames, Oberon, PopupElems;

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (PopupElems.ElemDesc) END;

VAR
	handle: ARRAY 8 OF Display.Handler; (*handle[cur] is installed in all frames whose menu contains Elem*)
	hName: ARRAY 8, 32 OF CHAR; (*handler names*)
	cur: INTEGER;
	w: Texts.Writer;
	curHandle-: Display.Handler;

PROCEDURE UpdateFrames;
	VAR x: INTEGER; v: Viewers.Viewer; r: Texts.Reader; f : Display.Frame;
BEGIN
	x := 0;
	WHILE x < Display.Width DO
		v := Viewers.This(x, 0);
		WHILE v.state > 1 DO
			IF (v.dsc # NIL) & (v.dsc IS TextFrames.Frame) THEN
				Texts.OpenReader(r, v.dsc(TextFrames.Frame).text, 0);
				REPEAT Texts.ReadElem(r) UNTIL r.eot OR (r.elem IS Elem);
				IF ~r.eot THEN
					f := v.dsc.next;
					WHILE f # NIL DO
						IF f IS TextFrames.Frame THEN f.handle := handle[cur] END;
						f := f.next
					END
				END
			END;
			v := Viewers.Next(v)
		END;
		x := x + v.W
	END
END UpdateFrames;

PROCEDURE SetHandler* (name: ARRAY OF CHAR; new: Display.Handler; VAR old: Display.Handler);
	VAR i: INTEGER;
BEGIN
	i := 0;
	WHILE (i <= cur) & (handle[i] # new) DO INC(i) END;
	IF i > cur THEN
		old := handle[cur]; INC(cur); handle[cur] := new; COPY(name, hName[cur])
	ELSIF i > 0 THEN cur := i; old := handle[cur-1]
	ELSE cur := 0; old := TextFrames.Handle
	END;
	curHandle := handle[cur];
	UpdateFrames
END SetHandler;

PROCEDURE ResetHandlers*;
BEGIN
	curHandle := TextFrames.Handle;
	handle[0] := TextFrames.Handle; hName[0] := "TextFrames.Handle"; cur := 0; UpdateFrames
END ResetHandlers;

PROCEDURE ListHandlers*;
	VAR i: INTEGER;
BEGIN
	FOR i := 0 TO cur DO
		Texts.WriteString(w, hName[i]); Texts.WriteLn(w)
	END;
	Texts.Append(Oberon.Log, w.buf)
END ListHandlers;

PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);
	VAR e1: Elem; f: Display.Frame;
BEGIN
	WITH m: Texts.CopyMsg DO
		IF m.e = NIL THEN NEW(e1); m.e := e1 END;
		PopupElems.Handle(e, m)
	| m: Texts.IdentifyMsg DO
		m.mod := "HandlerElems"; m.proc := "Alloc"
	| m: TextFrames.DisplayMsg DO
		PopupElems.Handle(e, m);
		IF ~m.prepare THEN 
			f := m.frame.next;
			WHILE f # NIL DO
				IF f IS TextFrames.Frame THEN f.handle := handle[cur] END;
				f := f.next
			END
		END
	ELSE PopupElems.Handle(e, m)
	END
END Handle;

PROCEDURE Alloc*;
	VAR e: Elem;
BEGIN
	NEW(e); e.handle := Handle; Texts.new := e
END Alloc;

PROCEDURE Insert*;
	VAR e: Elem; insert: TextFrames.InsertElemMsg;
BEGIN
	NEW(e); e.handle := Handle; e.name := "H"; e.small := TRUE;
	e.menu := TextFrames.Text("");
	Texts.WriteString(w, "This is a HandlerElems.Elem"); Texts.Append(e.menu, w.buf);
	PopupElems.MeasureMenu(e);
	insert.e := e; Viewers.Broadcast(insert)
END Insert;

BEGIN
	ResetHandlers; Texts.OpenWriter(w)
END HandlerElems.