F  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt        StampElems Alloc 22 Jul 99         Syntax10b.Scn.Fnt          	                  MarkElems Alloc H  8    8  FoldElems New      8         r!  1    8      
        8         %q 7    8   >   8             K      +    8          b    
        8             GS         8   f    8             L          8   >    8             M          #    8       8   S      MODULE FrameElems; (* CE  *)

IMPORT Texts, TextFrames, TextPrinter, Display, Viewers, Files, Elems, PanelElems, GU := GUtils;
			 	
CONST
	DUnit = TextFrames.Unit; 

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (Elems.ElemDesc)
		is3D* : BOOLEAN;
	END;

PROCEDURE Draw(e : Elem; x, y, color: INTEGER; f : Display.Frame);
VAR h, w : INTEGER;
BEGIN
	h := GU.Unit(e.H, TRUE); w := GU.Unit(e.W, TRUE);
	IF ~e.is3D THEN
		GU.Frame(f, color, x, y, w, h, GU.Unit(1, FALSE), Display.paint)
	ELSE
		GU.Frame3(f, x, y, w, h)
	END
END Draw;

PROCEDURE HandleAttrMsg(e : Elem; VAR msg : Elems.AttrMsg);
BEGIN
	Elems.Done := TRUE;
	IF msg.id = Elems.get THEN
		IF msg.name = "3D" THEN msg.class := Elems.Bool; msg.b := e.is3D
		ELSIF msg.name = Elems.special THEN msg.set := {Elems.back, Elems.overlap}
		ELSE Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.set THEN
		IF msg.name = "3D" THEN IF msg.class = Elems.Bool THEN e.is3D := msg.b END
		ELSIF (msg.name = "Cmd") OR (msg.name = "Par") THEN (* ignore *)
		ELSE Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.enum THEN
		Elems.Handle(e, msg); msg.enum("3D", Elems.Bool)
	ELSE
		Elems.Handle(e, msg)
	END
END HandleAttrMsg;

PROCEDURE HandleOverlapMsg(e : Elem; VAR msg : Elems.OverlapMsg);
VAR d : INTEGER;	tmp: BOOLEAN;
BEGIN
	IF e.is3D THEN d := 2 ELSE d := 1 END;
	tmp := ~PanelElems.InArea(msg.ex + d, msg.ey + d, msg.ew - 2 * d, msg.eh - 2 * d, msg.x, msg.y, msg.w, msg.h);
	msg.overlaps := PanelElems.OverlapsArea(msg.ex, msg.ey, msg.ew, msg.eh, msg.x, msg.y, msg.w, msg.h) & tmp
END HandleOverlapMsg;

PROCEDURE Handle* (e : Texts.Elem; VAR msg : Texts.ElemMsg);
VAR copy : Elem; ch : CHAR;
BEGIN
	WITH e : Elem DO
		WITH msg: TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				Draw(e, msg.X0, msg.Y0, msg.col, msg.frame)
			END
		| msg : TextPrinter.PrintMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.printer);
				Draw(e, msg.X0, msg.Y0, msg.col, NIL);
				GU.SetDevice(GU.display)
			END
		| msg : Texts.CopyMsg DO
			IF msg.e = NIL THEN NEW(copy); msg.e := copy ELSE copy := msg.e(Elem) END;
			Elems.CopyElem(e, copy);
			copy.is3D := e.is3D;
			msg.e := copy
		| msg: Texts.IdentifyMsg DO msg.mod := "FrameElems"; msg.proc := "New"
		| msg: Texts.FileMsg DO
			Elems.Handle(e, msg);
			IF msg.id = Texts.load THEN
				Files.Read(msg.r, ch); (* version -> not yet used *)
				Files.ReadBool(msg.r, e.is3D)
			ELSIF msg.id = Texts.store THEN
				Files.Write(msg.r, 0X); (* version *)
				Files.WriteBool(msg.r, e.is3D)
			END
		| msg : Elems.AttrMsg DO HandleAttrMsg(e, msg)
		| msg : Elems.OverlapMsg DO HandleOverlapMsg(e, msg)
		ELSE
			Elems.Handle(e, msg)
		END
	END
END Handle;

PROCEDURE Init* (e : Elem);
BEGIN
	Elems.Init(e);
	e.handle := Handle;
	e.is3D := TRUE;
	e.H := 30 * DUnit;
	e.W := e.H
END Init;

PROCEDURE New*;
VAR e : Elem;
BEGIN NEW(e); Init(e); Texts.new := e;
END New;

PROCEDURE Insert*; (** Name Cmd Par W H ("3D" | "") *)
VAR e : Elem; m : TextFrames.InsertElemMsg; s : Texts.Scanner;
BEGIN
	NEW(e); Init(e);
	Elems.GetPar(e, s);
	IF ~s.eot & (s.class IN {Texts.Name, Texts.String}) THEN
		e.is3D := CAP(s.s[0]) = "Y"
	END;
	m.e := e; Viewers.Broadcast(m)
END Insert;

END FrameElems.

System.Free FrameElems ~

FrameElems.Insert "" "" "" 0 0  "" ~

