9Y  Syntax10.Scn.Fnt      pd I StampElems Alloc 11 Dec 95      8  q InfoElems Alloc  #   Syntax10.Scn.Fnt       "Title": Film
"Author": H. Moessenboeck
"Abstract": Allows the creation of interactive graphics.
While drawing a Kepler graphic the user can split the drawing
into a couple of sequences (films) that can be played forwards
and backwards.
	Film.Reset resets the film to it s beginning
	Film.Next shows the next sequence
	Film.Prev removes the last sequences from the screen
For a full documentation see Film.Text.
"Changes":
95-03-27	Handling of planets
95-03-28	Buttons for branches
95-03-30	Film sequences textually editable
95-04-03	Sliders added. (auxiliaries: DependsOn, Mov, DrawSlider)
95-04-19	IO of stars which are not in the star list corrected
95-04-27	CutPoint and Slider have a star in order to be selectable
95-04-27	Select and GetInfo added
95-04-27	Buttons removed and replaced by cut points with alternative branches
95-05-05	Hiders and Markers added
95-05-10	Error in Move and Hide removed
95-05-11	DeleteBranch added    Syntax10i.Scn.Fnt  #    
   Syntax10b.Scn.Fnt              %                            
                            %                             
    %                        +    
                    %                        '            	    %        
            .    0        M        S    w8  FoldElems New  #   Syntax10.Scn.Fnt  g   g  
	VAR p: KeplerGraphs.Star; c: KeplerGraphs.Constellation; i: INTEGER;
BEGIN
	INC(s.refcnt);
	p := g.stars;
	WHILE (p # NIL) & (p # s) DO p := p.next END;
	IF p  = NIL THEN
		s.sel := FALSE;
		g.Append(s);
		IF s IS KeplerGraphs.Planet THEN
			c := s(KeplerGraphs.Planet).c;
			FOR i := 0 TO c.nofpts-1 DO AppendStar(g, c.p[i]) END
		END
	END
END AppendStar;
 8   F    8   #   Syntax10.Scn.Fnt       
	VAR c: KeplerGraphs.Constellation; i: INTEGER;
BEGIN
	g.Delete(s); c := s.c;
	FOR i := 0 TO c.nofpts-1 DO
		IF c.p[i].refcnt = 0 THEN
			IF c.p[i] IS KeplerGraphs.Planet THEN DelPlanet(g, c.p[i](KeplerGraphs.Planet))
			ELSE g.Delete(c.p[i])
			END
		END
	END
END DelPlanet;
 8   G    -8   	  Syntax10.Scn.Fnt      8  FoldElems New  C   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt             (*
				A recursive traversal is not possible since the deletion of a hider may insert another
				constellation in the list which is not on the recursion stack then.*) 8   $   68   #   Syntax10.Scn.Fnt         c1 := g.cons; WHILE (c1 # NIL) & (~(c1 IS Marker) OR (c1(Marker).n # c.n)) DO c1 := c1.next END;
			ASSERT((c1 # NIL) & (c1.next # NIL));
			m := c1(Marker); c1 := m.c;Syntax10i.Scn.Fnt  4    8   s    s8   #   Syntax10.Scn.Fnt  k    k   NEW(port); KeplerPorts.InitBalloon(port);
			c1.Draw(port);
			g.notify(KeplerGraphs.restore, g, NIL, port)     8   /      
	VAR head, c1: KeplerGraphs.Constellation; m: Marker; port: KeplerPorts.BalloonPort; i: INTEGER;
BEGIN
	IF c # NIL THEN
		head := c;
		REPEAT
			c := head; WHILE c.next # NIL DO c := c.next END; 
			g.Delete(c); c.next := g.cons(Head).cons; g.cons(Head).cons := c;
			FOR i := 0 TO c.nofpts-1 DO
				IF (c.p[i] IS KeplerGraphs.Planet) & (c.p[i].refcnt = 0) THEN DelPlanet(g, c.p[i](KeplerGraphs.Planet)) END
			END;
			WITH c: Slider DO
				c.Slide(g, -c.dx, -c.dy)
			| c: Hider DO
				m := corresponding mark; c1 := hidden constellation;
				c1.next := m.next; m.next := c1; m.c := NIL;
				FOR i := 0 TO c1.nofpts-1 DO AppendStar(g, c1.p[i]) END;
				draw c1
			ELSE
			END
		UNTIL c = head
	END
END Del;
 8   9    [8   #   Syntax10.Scn.Fnt         
	VAR s: KeplerGraphs.Star;
BEGIN
	NEW(s); s.x := MIN(INTEGER); s.y := MIN(INTEGER);
	c.nofpts := 1; c.p[0] := s
END SetDummyStar;
 8   A    8   Q   Syntax10.Scn.Fnt  O   Syntax10i.Scn.Fnt  B    \             
	VAR c: KeplerGraphs.Constellation; i: INTEGER;
BEGIN
	IF s.refcnt = 0 THEN (*this star is not in the star list so it must be written explicitly*)
		i := 0; WHILE (i < tabSize) & (tab[i] # s) DO INC(i) END;
		Files.WriteNum(r, i);
		IF i = tabSize THEN
			tab[tabSize] := s; INC(tabSize);
			KeplerGraphs.WriteObj(r, s);
			IF s IS KeplerGraphs.Planet THEN
				c := s(KeplerGraphs.Planet).c;
				FOR i := 0 TO c.nofpts-1 DO WriteStar(r, c.p[i]) END
			END
		END
	ELSE Files.WriteNum(r, -1) (*write dummy*)
	END
END WriteStar;
 8   D    8   #   Syntax10.Scn.Fnt       
	VAR ref, i: LONGINT; o: KeplerGraphs.Object; x: KeplerGraphs.Star; c: KeplerGraphs.Constellation;
BEGIN
	Files.ReadNum(r, ref);
	IF ref = -1 THEN s := NIL
	ELSIF ref < tabSize THEN s := tab[ref]
	ELSE
		KeplerGraphs.ReadObj(r, o); s := o(KeplerGraphs.Star);
		tab[tabSize] := s; INC(tabSize); 
		IF s IS KeplerGraphs.Planet THEN
			c := s(KeplerGraphs.Planet).c;
			FOR i := 0 TO c.nofpts-1 DO
				ReadStar(r, x); IF x # NIL THEN DEC(c.p[i].refcnt); c.p[i] := x END
			END
		END
	END
END ReadStar;
 8   M    8   #   Syntax10.Scn.Fnt         
	VAR i, n: INTEGER; c: KeplerGraphs.Constellation;
BEGIN
	c := list;
	WHILE c # NIL DO
		KeplerGraphs.WriteObj(r, c);
		FOR i := 0 TO c.nofpts-1 DO WriteStar(r, c.p[i]) END;
		c := c.next
	END;
	Files.WriteNum(r, -1)
END WriteList;
 8   P    8   #   Syntax10.Scn.Fnt       
	VAR o: KeplerGraphs.Object; c, last: KeplerGraphs.Constellation; i: INTEGER; x: KeplerGraphs.Star;
BEGIN
	KeplerGraphs.ReadObj(r, o); list := NIL;
	WHILE o # NIL DO
		c := o(KeplerGraphs.Constellation);
		IF list = NIL THEN list := c ELSE last.next := c END;
		last := c;
		FOR i := 0 TO c.nofpts-1 DO
			ReadStar(r, x); IF x # NIL THEN DEC(c.p[i].refcnt); c.p[i] := x END
		END;
		KeplerGraphs.ReadObj(r, o)
	END;
	IF list # NIL THEN last.next := NIL END
END ReadList;
 8   9    8   #   Syntax10.Scn.Fnt  K    K   
BEGIN
	WHILE (c # NIL) & (c IS CutPoint) DO c := c.next END
END SkipCuts;
 8   P     8   #   Syntax10.Scn.Fnt         
	VAR cut: KeplerGraphs.Constellation;
BEGIN
	cut := NIL;
	IF c # NIL THEN
		WHILE c.next # NIL DO
			IF c IS CutPoint THEN cut := c END;
			c := c.next
		END
	END;
	RETURN cut
END LastCut;
 8   k    >8   #   Syntax10.Scn.Fnt         
	VAR p: KeplerGraphs.Constellation;
BEGIN
	IF c = g.cons THEN p := NIL
	ELSE p := g.cons; WHILE p.next # c DO p := p.next END
	END;
	RETURN p
END Predecessor;
 8   ;    ;8   #   Syntax10.Scn.Fnt         
	VAR c: KeplerGraphs.Constellation;
BEGIN
	c := KeplerFrames.Focus.cons;
	WHILE (c # NIL) & (SYSTEM.VAL(LONGINT, c) # n) DO c := c.next END;
	RETURN c
END Const;
 8   H    28   #   Syntax10.Scn.Fnt       
	VAR type: Types.Type; i: INTEGER;
BEGIN
	Out.String("--- "); Out.String(s); Out.Ln;
	WHILE c # NIL DO
		Out.Int(SYSTEM.VAL(LONGINT, c), 8); Out.String("   ");
		type := Types.TypeOf(c); Out.String(type.name); Out.String(":  ");
		FOR i := 0 TO c.nofpts-1 DO Out.F2("(#,#) ", c.p[i].x, c.p[i].y) END;
		WITH c: CutPoint DO Out.Char('"'); Out.String(c.name); Out.Char('"') ELSE END;
		Out.Ln;
		c := c.next
	END;
END ListConst;
 8   '    28   #   Syntax10.Scn.Fnt         
BEGIN
	IF c.alt # NIL THEN
		Out.Ln;
		REPEAT
			Out.String('Film.Go "'); Out.String(c.name); Out.Char('"'); Out.Ln;
			c := c.alt;
		UNTIL c = NIL
	END
END ListBranches;
 8   -    48   #   Syntax10.Scn.Fnt         
	VAR kind: INTEGER;
BEGIN
	In.Open; kind := In.Next();
	IF kind = In.string THEN In.String(s)
	ELSIF kind = In.name THEN In.Name(s)
	ELSE s[0] := 0X
	END
END GetString;
 8   ;    8   #   Syntax10.Scn.Fnt         
	VAR r: Texts.Reader; ch: CHAR;
BEGIN
	ch := " ";
	WHILE (pos > 0) & (ch # CR) DO
		DEC(pos); Texts.OpenReader(r, t, pos); Texts.Read(r, ch)
	END;
	IF ch = CR THEN INC(pos) END
END GetLineStart;
 8   T     8   #   Syntax10.Scn.Fnt       
	VAR s: Texts.Scanner; ch: CHAR; time: LONGINT; p: Node;
BEGIN
	t := NIL; list := NIL; beg := 0; end := 0;
	Oberon.GetSelection(t, beg, end, time);
	IF time >= 0 THEN
		GetLineStart(t, beg);
		Texts.OpenScanner(s, t, beg);
		REPEAT
			Texts.Scan(s);
			NEW(p); p.c := Const(s.i); p.next := list; list := p;
			REPEAT Texts.Read(s, ch) UNTIL (ch = CR) OR s.eot
		UNTIL s.eot OR (Texts.Pos(s) >= end);
		end := Texts.Pos(s)
	END
END GetSelection;
 8   O    .8   #   Syntax10.Scn.Fnt       
	VAR v: Viewers.Viewer; f: TextFrames.Frame; s: Texts.Scanner;
BEGIN
	v := Oberon.FocusViewer; c := NIL; pos := -1;
	IF (v # NIL) & (v.dsc.next # NIL) & (v.dsc.next IS TextFrames.Frame) THEN
		f := v.dsc.next(TextFrames.Frame);
		IF f.hasCar THEN
			pos := f.carloc.pos; GetLineStart(f.text, pos);
			Texts.OpenScanner(s, f.text, pos); Texts.Scan(s);
			IF s.class = Texts.Int THEN c := Const(s.i) END
		END
	END
END GetInsertPos;
 8   ,     8   #   Syntax10.Scn.Fnt       
	VAR h: Head; s: KeplerGraphs.Star; i: INTEGER;
BEGIN
	IF tabSize > 0 THEN
		FOR i := 0 TO tabSize - 1 DO tab[i] := NIL END;
		tabSize := 0
	END;
	IF (g.cons = NIL) OR ~(g.cons IS Head) THEN
		NEW(h); h.cons := NIL;
		IF g.cons = NIL THEN g.Append(h) ELSE h.next := g.cons; g.cons := h END
	END;
	IF (g.stars = NIL) OR (g.stars.x # MAX(INTEGER)) THEN
		NEW(s); s.x := MAX(INTEGER);
		IF g.stars = NIL THEN g.Append(s) ELSE s.next := g.stars; g.stars := s END
	END
END Prepare;
 8   U    8   #   Syntax10.Scn.Fnt       
	VAR i: INTEGER; p: KeplerGraphs.Star;
BEGIN i := 0;
	WHILE i < c.nofpts DO p := c.p[i];
		IF p = s THEN RETURN TRUE
		ELSIF (p IS KeplerGraphs.Planet) & DependsOn(p(KeplerGraphs.Planet).c, s) THEN RETURN TRUE
		END ;
		INC(i)
	END;
	RETURN FALSE
END DependsOn;
 8   g    P8   #   Syntax10.Scn.Fnt       
	VAR p: KeplerGraphs.Star; c: KeplerGraphs.Constellation;
BEGIN
	c := g.cons;
	WHILE c # NIL DO
		IF DependsOn(c, s) THEN c.Draw(port) END;
		c := c.next
	END;
	p := s^.next;
	WHILE p # NIL DO
		IF (p IS KeplerGraphs.Planet) & DependsOn(p(KeplerGraphs.Planet).c, s) THEN p.Draw(port) END;
		p := p.next
	END;
	s.Draw(port); INC(s.x, dx); INC(s.y, dy); s.Draw(port);
	p := s^.next;
	WHILE p # NIL DO
		IF (p IS KeplerGraphs.Planet) & DependsOn(p(KeplerGraphs.Planet).c, s) THEN
			p(KeplerGraphs.Planet).Calc; p.Draw(port)
		END;
		p := p.next
	END;
	c := g.cons;
	WHILE c # NIL DO
		IF DependsOn(c, s) THEN c.Draw(port) END;
		c := c.next
	END
END Mov;
 8   :    8   #   Syntax10.Scn.Fnt  \   \  
	VAR i, dx, dy, n: INTEGER; delay, j: LONGINT;
BEGIN
	n := ABS(s.dx); IF ABS(s.dy) > n THEN n := ABS(s.dy) END;
	n := n DIV 10;
	IF n # 0 THEN dx := s.dx DIV n; dy := s.dy DIV n END;
	delay := 400000-LEN(s.s^)*5000;
	FOR i := 1 TO n DO
		s.Slide(g, dx, dy);
		FOR j := 1 TO delay DO END
	END;
	s.Slide(g, s.dx - n*dx, s.dy - n*dy)
END DrawSlider;
 8           #            8   #   Syntax10.Scn.Fnt  C    C   
BEGIN
	h.Write^(r); tabSize := 0; WriteList(r, h.cons)
END Write;
 8               8   #   Syntax10.Scn.Fnt  @    @   
BEGIN
	h.Read^(r); tabSize := 0; ReadList(r, h.cons)
END Read;
 8           '            8   #   Syntax10.Scn.Fnt         
BEGIN
	c.Write^(r); Files.WriteBool(r, c.first); Files.WriteString(r, c.name);
	IF ~c.first THEN WriteList(r, c.next) END;
	IF c.alt = NIL THEN Files.WriteNum(r, 0)
	ELSE Files.WriteNum(r, 1); KeplerGraphs.WriteObj(r, c.alt)
	END
END Write;
 8               8   #   Syntax10.Scn.Fnt       
	VAR x: LONGINT; o: KeplerGraphs.Object;
BEGIN
	c.Read^(r); Files.ReadBool(r, c.first); Files.ReadString(r, c.name);
	IF ~c.first THEN ReadList(r, c.next) END;
	Files.ReadNum(r, x);
	IF x = 1 THEN
		KeplerGraphs.ReadObj(r, o); c.alt := o(CutPoint)
	END
END Read;
 8           &            >8   C   Syntax10.Scn.Fnt    Syntax10i.Scn.Fnt      m      
	VAR i, j: LONGINT; s: KeplerGraphs.Star;
BEGIN
	sl.Write^(r);
	Files.WriteNum(r, sl.dx); Files.WriteNum(r, sl.dy);
	Files.WriteNum(r, LEN(sl.s^));
	FOR i := 0 TO LEN(sl.s^)-1 DO
		s := sl.s[i];
		IF s.refcnt = 0 THEN Files.WriteNum(r, 0); WriteStar(r, s) (*not in star list*)
		ELSE
			j := 0; WHILE s # NIL DO INC(j); s := s.next END;
			Files.WriteNum(r, j)
		END
	END
END Write;
 8               8   C   Syntax10.Scn.Fnt  o  Syntax10i.Scn.Fnt            
	VAR i, j, n, x, y, stars: LONGINT; s: KeplerGraphs.Star;
BEGIN
	sl.Read^(r);
	Files.ReadNum(r, x); sl.dx := SHORT(x); Files.ReadNum(r, y); sl.dy := SHORT(y);
	Files.ReadNum(r, n); NEW(sl.s, n);
	s := KeplerGraphs.loading.stars; stars := 0;
	WHILE s # NIL DO INC(stars); s := s.next END;
	FOR i := 0 TO n-1 DO
		Files.ReadNum(r, x);
		IF x = 0 THEN ReadStar(r, s)	(*not in star list*)
		ELSE
			s := KeplerGraphs.loading.stars;
			FOR j := 1 TO stars - x DO s := s.next END
		END;
		ASSERT(s # NIL); sl.s[i] := s
	END
END Read;
 8           ,    8   #   Syntax10.Scn.Fnt         
	VAR port: KeplerPorts.BalloonPort; i, j: LONGINT;
BEGIN
	NEW(port); KeplerPorts.InitBalloon(port);
	FOR i := 0 TO LEN(sl.s^)-1 DO
		Mov(g, sl.s[i], port, dx, dy)
	END;
	g.notify(KeplerGraphs.restore, g, NIL, port)
END Slide;
 8           %            8   #   Syntax10.Scn.Fnt  J    J   
BEGIN
	m.Write^(r); Files.WriteNum(r, m.n); WriteList(r, m.c)
END Write;
 8               {8   #   Syntax10.Scn.Fnt  c    c   
	VAR o: KeplerGraphs.Object;
BEGIN
	m.Read^(r); Files.ReadNum(r, m.n); ReadList(r, m.c)
END Read;
 8       
    $            8   #   Syntax10.Scn.Fnt  7    7   
BEGIN
	h.Write^(r); Files.WriteNum(r, h.n)
END Write;
 8               8   #   Syntax10.Scn.Fnt  4    4   
BEGIN
	h.Read^(r); Files.ReadNum(r, h.n)
END Read;
 8                       8   #   Syntax10.Scn.Fnt       
	VAR c: CutPoint; g: KeplerGraphs.Graph; x: KeplerGraphs.Constellation;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		Prepare(g);
		NEW(c); c.first := TRUE;
		x := g.cons; WHILE x.next # NIL DO x := x.next END;
		SetDummyStar(c);
		g.Append(c)
	END
END Cut;
 8               \8   #   Syntax10.Scn.Fnt         
	VAR g: KeplerGraphs.Graph;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		Prepare(g);
		Del(g, g.cons.next)
	END
END Reset;
 8               8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; c, c1, next: KeplerGraphs.Constellation; m: Marker; i: INTEGER;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		Prepare(g);
		c := g.cons(Head).cons; SkipCuts(c);
		WHILE (c # NIL) & ~(c IS CutPoint) DO
			next := c.next;
			FOR i := 0 TO c.nofpts-1 DO AppendStar(g, c.p[i]) END;
			g.Append(c);
			WITH c: Slider DO
				DrawSlider(g, c)
			| c: Hider DO
				c1 := g.cons; WHILE (c1 # NIL) & (~(c1 IS Marker) OR (c1(Marker).n # c.n)) DO c1 := c1.next END;
				ASSERT(c1 # NIL);
				m := c1(Marker); c1 := c1.next;
				g.Delete(c1); m.c := c1
			ELSE
			END;
			c := next
		END;
		IF c # NIL THEN
			ListBranches(c(CutPoint));
			next := c.next; AppendStar(g, c.p[0]); g.Append(c(CutPoint)); c := next; SkipCuts(c)
		END;
		g.cons(Head).cons := c
	END
END Next;
 8               8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; c, cut: KeplerGraphs.Constellation;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		Prepare(g);
		cut := LastCut(g.cons);
		IF cut = NIL THEN Del(g, g.cons.next) ELSE Del(g, cut.next); ListBranches(cut(CutPoint)) END
	END
END Prev;
 8               8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; c, c2: KeplerGraphs.Constellation; c1: CutPoint; s: ARRAY 32 OF CHAR;
BEGIN
	In.Open; GetString(s);
	g := KeplerFrames.Focus;
	c := g.cons; WHILE c.next # NIL DO c := c.next END;
	WITH c: CutPoint DO
		c1 := c;
		WHILE (c1 # NIL) & (c1.name # s) DO c1 := c1.alt END;
		IF c1 # NIL THEN
			c2 := g.cons(Head).cons; g.cons(Head).cons := c1.next; c1.next := c2;
			COPY(c.name, c1.name); COPY(s, c.name);
			Next
		END
	ELSE
	END
END Go;
 8               8      Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  [    [   s := g.stars; i := 0;
		WHILE s # NIL DO
			IF s.sel THEN INC(i) END;
			s := s.next
		END;Syntax10i.Scn.Fnt      8   o   U  
	VAR g: KeplerGraphs.Graph; a, b, s: KeplerGraphs.Star; slider: Slider; i: INTEGER; port: KeplerPorts.BalloonPort;
BEGIN
	g := KeplerFrames.Focus;
	IF (g # NIL) & (KeplerFrames.nofpts >= 2) THEN
		i := number of selected points
		IF i > 0 THEN
			KeplerFrames.GetPoint(a); KeplerFrames.GetPoint(b);
			NEW(slider); slider.dx := b.x - a.x; slider.dy := b.y - a.y;
			NEW(slider.s, i);
			s := g.stars; i := 0;
			WHILE s # NIL DO
				IF s.sel THEN slider.s[i] := s; INC(i) END;
				s := s.next
			END;
			SetDummyStar(slider);
			g.Append(slider);
			DrawSlider(g, slider)
		END
	END
END Slide;
 8               8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; c, prev: KeplerGraphs.Constellation; h: Hider; m: Marker;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		Prepare(g);
		c := g.cons;
		WHILE c # NIL DO
			IF c.State() = fullySel THEN
				g.Delete(c);
				NEW(m); m.n := SYSTEM.VAL(LONGINT, m); m.c := c; SetDummyStar(m);
				m.next := prev.next; prev.next := m;
				NEW(h); h.n := m.n; SetDummyStar(h);
				g.Append(h);
				prev := m; c := m.next
			ELSE prev := c; c := c.next
			END
		END
	END
END Hide;
 8       	        8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; c: KeplerGraphs.Constellation; c1: CutPoint; s: ARRAY 32 OF CHAR;
BEGIN
	In.Open; GetString(s);
	g := KeplerFrames.Focus;
	c := g.cons; WHILE c.next # NIL DO c := c.next END;
	WITH c: CutPoint DO
		NEW(c1); c1^ := c^; c1.first := FALSE; COPY(s, c.name);
		c1.alt := c.alt; c.alt := c1;
		c1.next := g.cons(Head).cons; g.cons(Head).cons := NIL;
		Out.String("Now draw the new branch: "); Out.String(s); Out.Ln
	ELSE
	END
END NewBranch;
 8               8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; cut: CutPoint; cutPrev, c, prev: KeplerGraphs.Constellation;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		prev := NIL; cut := NIL; c := g.cons;
		WHILE c # NIL DO
			IF c IS CutPoint THEN cut := c(CutPoint); cutPrev := prev END;
			prev := c; c := c.next
		END;
		IF (cut # NIL) & (cut.next = NIL) & (cut.alt # NIL) THEN
			cut.name := cut.alt.name;
			g.cons(Head).cons := cut.alt.next;
			cut.next := NIL; cut.alt := cut.alt.alt; Next
		END
	END
END DeleteBranch;
 8               '8   #   Syntax10.Scn.Fnt         
	VAR g: KeplerGraphs.Graph; c: KeplerGraphs.Constellation; type: Types.Type; i: INTEGER;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN ListConst("graphics", g.cons) END
END List;
 8               8   #   Syntax10.Scn.Fnt       
	VAR sentinel, c, insPos, prev: KeplerGraphs.Constellation; g: KeplerGraphs.Graph;
		t: Texts.Text; buf: Texts.Buffer; beg, end, pos: LONGINT; list: Node;
BEGIN
	g := KeplerFrames.Focus;
	NEW(sentinel); g.Append(sentinel);
	GetSelection(t, beg, end, list);
	GetInsertPos(pos, c); IF c = NIL THEN c := sentinel END;
	IF (t # NIL) & (pos >= 0) & ((pos < beg) OR (pos > end)) THEN
		insPos := Predecessor(g, c);
		WHILE list # NIL DO
			c := list.c;
			prev := Predecessor(g, c); prev.next := c.next;
			IF insPos = NIL THEN c.next := g.cons; g.cons := c ELSE c.next := insPos.next; insPos.next := c END;
			list := list.next
		END;
		Texts.Delete(t, beg, end); Texts.Recall(buf);
		IF pos > end THEN DEC(pos, buf.len) END;
		Texts.Insert(t, pos, buf)
	END;
	g.Delete(sentinel)
END Move;
 8               8   #   Syntax10.Scn.Fnt  
   
  
	VAR g: KeplerGraphs.Graph; t: Texts.Text; beg, end: LONGINT; list: Node;
BEGIN
	g := KeplerFrames.Focus;
	GetSelection(t, beg, end, list);
	IF t # NIL THEN
		WHILE list # NIL DO g.Delete(list.c); list := list.next END;
		Texts.Delete(t, beg, end)
	END
END Delete;
 8               8   #   Syntax10.Scn.Fnt  P   P  
	VAR g: KeplerGraphs.Graph; c: KeplerGraphs.Constellation; t: Texts.Text; beg, end, i: LONGINT; list: Node;
BEGIN
	g := KeplerFrames.Focus;
	GetSelection(t, beg, end, list);
	WHILE list # NIL DO
		c := list.c;
		FOR i := 0 TO c.nofpts-1 DO
			IF ~c.p[i].sel THEN g.FlipSelection(c.p[i]) END
		END;
		list := list.next
	END
END Select;
 8               E8   #   Syntax10.Scn.Fnt       
	VAR g: KeplerGraphs.Graph; c: KeplerGraphs.Constellation; t: Texts.Text; beg, end, i: LONGINT; list: Node;
BEGIN
	GetSelection(t, beg, end, list);
	IF list # NIL THEN
		c := list.c;
		WITH c: Slider DO
			Out.F2("slider (dx=#, dy=#) defined on the following stars:$", c.dx, c.dy);
			FOR i := 0 TO LEN(c.s^)-1 DO Out.F2("(#,#)$", c.s[i].x, c.s[i].y) END;
		| c: CutPoint DO
			Out.String(c.name); Out.Ln
		| c: Head DO
			g := KeplerFrames.Focus;
			IF g # NIL THEN ListConst("yet unplayed film", g.cons(Head).cons) END
		| c: Marker DO Out.F("mark.n = #$", c.n); ListConst("hidden", c.c)
		| c: Hider DO Out.F("hider.n = #$", c.n)
		ELSE
		END
	END
END GetInfo;
 8       
        8   #   Syntax10.Scn.Fnt         
	VAR s: ARRAY 32 OF CHAR; t: Texts.Text; beg, end: LONGINT; list: Node;
BEGIN
	In.Open; GetString(s);
	GetSelection(t, beg, end, list);
	IF (list # NIL) & (list.c IS CutPoint) THEN COPY(s, list.c(CutPoint).name) END
END SetBranchName;
 8       	        8   #   Syntax10.Scn.Fnt         
	VAR g: KeplerGraphs.Graph; s: KeplerGraphs.Star;
BEGIN
	g := KeplerFrames.Focus;
	IF g # NIL THEN
		s := g.stars;
		WHILE s # NIL DO
			IF s.x # MIN(INTEGER) THEN Out.F3("(#, #) #$", s.x, s.y, s.refcnt) END;
			s := s.next
		END
	END
END DumpStars;
 8         MODULE Film;	(* HM 23 Mar 95 /   *)
IMPORT Files, Oberon, Viewers, KeplerPorts, KeplerGraphs, KeplerFrames, Types, Texts, TextFrames, In, Out, SYSTEM;

CONST
	ML = 2; MM = 1; MR = 0;
	CR = 0DX;
	unselected = 0; partiallySel = 1; fullySel = 2;	(*selection states of a constellation*)

TYPE
	CutPoint* = POINTER TO CutPointDesc;
	CutPointDesc* = RECORD (KeplerGraphs.ConsDesc)
		alt*: CutPoint;	(*alternative branch*)
		first*: BOOLEAN;	(*first branch?*)
		name*: ARRAY 32 OF CHAR
	END ;

	Head* = POINTER TO HeadDesc;
	HeadDesc* = RECORD (KeplerGraphs.ConsDesc)
		cons*: KeplerGraphs.Constellation	(*unplayed part of the film*)
	END ;

	Slider* = POINTER TO SliderDesc;
	SliderDesc* = RECORD (KeplerGraphs.ConsDesc)
		dx*, dy*: INTEGER;
		s*: POINTER TO ARRAY OF KeplerGraphs.Star	(*stars to move*)
	END ;

	Marker* = POINTER TO MarkDesc;
	MarkDesc* = RECORD (KeplerGraphs.ConsDesc)
		n*: LONGINT;  (*for linking it to a Hider*)
		c*: KeplerGraphs.Constellation
	END ;

	Hider* = POINTER TO HiderDesc;
	HiderDesc* = RECORD (KeplerGraphs.ConsDesc)
		n*: LONGINT	(*for linking it to a marker*)
	END ;

	Node = POINTER TO NodeDesc;
	NodeDesc = RECORD
		c: KeplerGraphs.Constellation;
		next: Node
	END ;

VAR
	tab: ARRAY 256 OF KeplerGraphs.Star;	(*for IO of stars which are not in the star list*)
	tabSize: INTEGER;


PROCEDURE^ (sl: Slider) Slide* (g: KeplerGraphs.Graph; dx, dy: INTEGER);
PROCEDURE^ Next*;


(*---------- auxiliary procedures ----------*)

PROCEDURE AppendStar (g: KeplerGraphs.Graph; s: KeplerGraphs.Star);	
PROCEDURE DelPlanet (g: KeplerGraphs.Graph; s: KeplerGraphs.Planet);	
PROCEDURE Del (g: KeplerGraphs.Graph; c: KeplerGraphs.Constellation);	
PROCEDURE SetDummyStar (c: KeplerGraphs.Constellation);	
PROCEDURE WriteStar (VAR r: Files.Rider; s: KeplerGraphs.Star);	
PROCEDURE ReadStar (VAR r: Files.Rider; VAR s: KeplerGraphs.Star);	
PROCEDURE WriteList (VAR r: Files.Rider; list: KeplerGraphs.Constellation);	
PROCEDURE ReadList (VAR r: Files.Rider; VAR list: KeplerGraphs.Constellation);	
PROCEDURE SkipCuts (VAR c: KeplerGraphs.Constellation);	
PROCEDURE LastCut (c: KeplerGraphs.Constellation): KeplerGraphs.Constellation;	
PROCEDURE Predecessor (g: KeplerGraphs.Graph; c: KeplerGraphs.Constellation): KeplerGraphs.Constellation;	
PROCEDURE Const (n: LONGINT): KeplerGraphs.Constellation;	
PROCEDURE ListConst (s: ARRAY OF CHAR; c: KeplerGraphs.Constellation);	
PROCEDURE ListBranches (c: CutPoint);	
PROCEDURE GetString (VAR s: ARRAY OF CHAR);	
PROCEDURE GetLineStart (t: Texts.Text; VAR pos: LONGINT);	
PROCEDURE GetSelection (VAR t: Texts.Text; VAR beg, end: LONGINT; VAR list: Node);	
PROCEDURE GetInsertPos (VAR pos: LONGINT; VAR c: KeplerGraphs.Constellation);	
PROCEDURE Prepare (g: KeplerGraphs.Graph);	
PROCEDURE DependsOn (c: KeplerGraphs.Constellation; s: KeplerGraphs.Star): BOOLEAN;	
PROCEDURE Mov (g: KeplerGraphs.Graph; s: KeplerGraphs.Star; port: KeplerPorts.Port; dx, dy: INTEGER);	
PROCEDURE DrawSlider (g: KeplerGraphs.Graph; s: Slider);	

(*---------- head methods ----------*)

PROCEDURE (h: Head) Write* (VAR r: Files.Rider);	
PROCEDURE (h: Head) Read* (VAR r: Files.Rider);	

(*---------- cut point methods ----------*)

PROCEDURE (c: CutPoint) Write* (VAR r: Files.Rider);	
PROCEDURE (c: CutPoint) Read* (VAR r: Files.Rider);	

(*---------- slider methods ----------*)

PROCEDURE (sl: Slider) Write* (VAR r: Files.Rider);	
PROCEDURE (sl: Slider) Read* (VAR r: Files.Rider);	
PROCEDURE (sl: Slider) Slide* (g: KeplerGraphs.Graph; dx, dy: INTEGER);	

(*---------- marker methods ----------*)

PROCEDURE (m: Marker) Write* (VAR r: Files.Rider);	
PROCEDURE (m: Marker) Read* (VAR r: Files.Rider);	

(*---------- hider methods ----------*)

PROCEDURE (h: Hider) Write* (VAR r: Files.Rider);	
PROCEDURE (h: Hider) Read* (VAR r: Files.Rider);	

(*---------- commands ----------*)

PROCEDURE Cut*;	

PROCEDURE Reset*;	
PROCEDURE Next*;	
PROCEDURE Prev*;	
PROCEDURE Go*;	

PROCEDURE Slide*;	
PROCEDURE Hide*;	
PROCEDURE NewBranch*;	
PROCEDURE DeleteBranch*;	

PROCEDURE List*;	
PROCEDURE Move*;	
PROCEDURE Delete*;	
PROCEDURE Select*;	
PROCEDURE GetInfo*;	
PROCEDURE SetBranchName*;	

PROCEDURE DumpStars*;	

BEGIN
	tabSize := 0
END Film.