   Syntax10.Scn.Fnt      09
  StampElems Alloc 2002-Nov-01     Syntax10i.Scn.Fnt         Syntax10b.Scn.Fnt                     H       Y        @   
  MODULE DirElems;	(** HM  (mah auto-update)*)
IMPORT Viewers, Texts, TextFrames, Oberon, OpenElems, PopupElems, Directories, Display;

CONST dirLen = 32;	(* gh 2002-Nov-01 *)
TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (OpenElems.OpenElemDesc)
	END;
	NotifyMsg = RECORD(Display.FrameMsg) END;
	Frame = POINTER TO RECORD(Display.FrameDesc) elem: Elem END;

VAR
	oldDirNotify: Directories.Notifier;
	curDirName: ARRAY dirLen OF CHAR;
	
PROCEDURE SetDirName;
	VAR i, j: INTEGER; name: ARRAY 256 OF CHAR; d, d0: Directories.Directory;
BEGIN
	d := Directories.Current(); d0 := Directories.Startup();
	i := 0; WHILE (d0.path[i] # 0X) & (CAP(d0.path[i]) = CAP(d.path[i])) DO INC(i) END;
	IF (d0.path[i] = 0X) & ((d.path[i] = 0X) OR (d.path[i] = Directories.delimiter)) THEN
		IF d.path[i] = Directories.delimiter THEN
			name[0] := "$"; j := 0; INC (i);
			REPEAT INC(j); name[j] := d.path[i]; INC(i) UNTIL name[j] = 0X
		ELSE name := "$"
		END
	ELSE
		COPY(d.path, name)
	END;
	i := 0; WHILE name[i] # 0X DO INC(i) END;
	IF i < dirLen THEN COPY(name, curDirName)
	ELSE curDirName[dirLen-1] := 0X; j := 31;
		REPEAT DEC(i); DEC(j); curDirName[j] := name[i] UNTIL j = 1;
		curDirName[0] := "*"
	END
END SetDirName;

PROCEDURE DirNotify (op: INTEGER; path, name: ARRAY OF CHAR);
VAR msg: NotifyMsg;
BEGIN
	IF op = Directories.change THEN SetDirName; Viewers.Broadcast (msg) END;
	oldDirNotify (op, path, name)
END DirNotify;

PROCEDURE HandleFrame(f: Display.Frame; VAR msg: Display.FrameMsg);
	VAR m: TextFrames.UpdateMsg; t: Texts.Text;
BEGIN
	IF msg IS NotifyMsg THEN
		WITH f: Frame DO
			t := Texts.ElemBase(f.elem);
			t.notify (t, TextFrames.replace, Texts.ElemPos(f.elem), Texts.ElemPos(f.elem)+1)
		END
	END
END HandleFrame;

PROCEDURE Handle* (e: Texts.Elem; VAR m: Texts.ElemMsg);
	VAR e1: Elem; f: Frame;
BEGIN
	WITH e: Elem DO
		COPY (curDirName, e.name);
		WITH m: Texts.CopyMsg DO
			IF m.e = NIL THEN NEW(e1); m.e := e1 END ;
			OpenElems.Handle(e, m)
		|  m: Texts.IdentifyMsg DO m.mod := "DirElems"; m.proc := "Alloc"
		|  m: TextFrames.DisplayMsg DO
			IF ~m.prepare THEN
				NEW (f); f.X := m.X0; f.Y := m.Y0; f.W := 1; f.H := 1;	(* trick (c) mah/cs *)
				f.handle := HandleFrame; f.elem := e;
				m.elemFrame := f
			END;
			OpenElems.Handle (e, m)
		ELSE OpenElems.Handle(e, m)
		END
	END
END Handle;

PROCEDURE Alloc*;
	VAR e: Elem;
BEGIN
	NEW(e); e.handle := Handle; Texts.new := e
END Alloc;

PROCEDURE Insert*;
	VAR e: Elem; insert: TextFrames.InsertElemMsg;
BEGIN
	NEW(e); e.handle := Handle; e.small := FALSE;
	e.menu := TextFrames.Text(""); PopupElems.MeasureMenu(e);
	insert.e := e; Viewers.Broadcast(insert)
END Insert;

BEGIN
	SetDirName;
	oldDirNotify := Directories.notify; Directories.notify := DirNotify
END DirElems.
