   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt      ^   Syntax10b.Scn.Fnt          '       #        *    J   1    N   $    ]          9	  MODULE DayDif;
	(* MK 1994-10-28 *)
	
	IMPORT In, Out;
	
	TYPE 
		Date = RECORD
			day, mon, year: INTEGER;
		END;
		
	PROCEDURE DayDif*;
		VAR date1, date2, a: Date; i, y, dif, mon1: INTEGER;  
	BEGIN
		In.Open; 
		In.Int (date1.day); In.Int (date1.mon); In.Int (date1.year); In.Int (date2.day); In.Int (date2.mon); In.Int (date2.year);
		IF In.Done THEN
			(* --- make sure that date1 <= date2 *)
			IF (date1.year > date2.year) OR 
				((date1.year = date2.year) & ((date1.mon > date2.mon) OR ((date1.mon = date2.mon) & (date1.day > date2.day)))) THEN
				a := date1; date1 := date2; date2 := a
			END;
			
			dif := 0;
			IF date1.year # date2.year THEN
				(* --- differences between years *)
				dif := (date2.year - date1.year - 1) * 365; (* full years *)	
				FOR i := date1.year + 1 TO date2.year -1 DO  
					IF (i MOD 4 = 0) & ((i MOD 100 # 0) OR ((i DIV 100) MOD 4 = 0)) THEN INC (dif) END
				END; (* leap years *)
	
				(* --- months from date1 to end of year *)
				mon1 := date1.mon; y := date1.year;
				WHILE mon1 <= 12 DO
					IF mon1 IN {1, 3, 5, 7, 8, 10, 12} THEN INC (dif, 31)
					ELSIF (mon1 = 2) & (y MOD 4 = 0) & ((y MOD 100 # 0) OR ((y DIV 100) MOD 4 = 0)) THEN INC (dif, 29)
					ELSIF mon1 = 2 THEN INC (dif, 28)
					ELSE INC (dif, 30)
					END;
					INC (mon1)
				END;
				(* --- months from beginning of year to date 2 *)
				i := 1; mon1 := date2.mon - 1; y := date2.year;
				WHILE i <= mon1 DO
					IF i IN {1, 3, 5, 7, 8, 10, 12} THEN INC (dif, 31)
					ELSIF (i = 2) & (y MOD 4 = 0) & ((y MOD 100 # 0) OR ((y DIV 100) MOD 4 = 0)) THEN INC (dif, 29)
					ELSIF i = 2 THEN INC (dif, 28)
					ELSE INC (dif, 30)
					END;
					INC (i)
				END;
			ELSE (* --- months from date1 to date 2 *) 
				i := date1.mon; mon1 := date2.mon - 1; y := date1.year;
				WHILE i <= mon1 DO
					IF i IN {1, 3, 5, 7, 8, 10, 12} THEN INC (dif, 31)
					ELSIF (i = 2) & (y MOD 4 = 0) & ((y MOD 100 # 0) OR ((y DIV 100) MOD 4 = 0)) THEN INC (dif, 29)
					ELSIF i = 2 THEN INC (dif, 28)
					ELSE INC (dif, 30)
					END;
					INC (i)
				END;
			END;
			
			(* --- days *)
			DEC (dif, date1.day); INC (dif, date2.day);
			
			Out.F3 ("Difference between #.#.# and ", date1.day, date1.mon, date1.year);
			Out.F4 ("#.#.# is: #$", date2.day, date2.mon, date2.year, dif); 
		END
	END DayDif;

BEGIN Out.Open	
END DayDif.DayDif 20 9 2002  20 9 2003