  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt        StampElems Alloc 17 Jul 95      ,   Syntax10b.Scn.Fnt          	                
        
            3                
    8  FoldElems New      
        	            6    8           .    8       8           3    8   8   8               8       8   
        2    8      8           2    8      8               8   ;   8       m  MODULE DAFiles;  (* mah 10 Jan 95, MK  *)

IMPORT Files, S := SYSTEM, Out;

	CONST
		readOnly* = 1; readWrite* = 2;
	
		ok* = 0; errAccessMode* = 1; errIllegalKey* = 2; errDiskFull* = 3;
		
		deleted = 0X;
		valid = 1X;
		
	TYPE
		File* = POINTER TO FileDesc;
		FileDesc* = RECORD
			numEntries-: LONGINT;
			entrySize-: INTEGER;
			status-: INTEGER;
			mode: INTEGER;
			f: Files.File;
		END;
	
	PROCEDURE Open* (name: ARRAY OF CHAR; mode: INTEGER) : File;
		VAR f: File; r: Files.Rider;
	BEGIN
		NEW (f); f.f := Files.Old (name); f.mode := mode; f.status := ok;
		IF f.f = NIL THEN RETURN NIL END;
		Files.Set (r, f.f, 0); Files.ReadLInt (r, f.numEntries); Files.ReadInt (r, f.entrySize);
		RETURN f
	END Open;
	
	PROCEDURE Create* (name: ARRAY OF CHAR; entrySize: INTEGER) : File;
		VAR f: File; r: Files.Rider;
	BEGIN
		NEW (f); f.f := Files.New (name); f.mode := readWrite; 
		f.entrySize := entrySize; f.numEntries := 0; f.status := ok;
		IF f.f = NIL THEN RETURN NIL END;
		Files.Set (r, f.f, 0); Files.WriteLInt (r, f.numEntries); Files.WriteInt (r, f.entrySize);
		RETURN f
	END Create;
	
	PROCEDURE Close* (f: File);
		VAR r: Files.Rider;
	BEGIN
		IF f.mode = readWrite THEN 
			Files.Set (r, f.f, 0); Files.WriteLInt (r, f.numEntries); Files.WriteInt (r, f.entrySize);
			Files.Register (f.f)
		END;
	END Close;

	PROCEDURE Read* (f: File; key: LONGINT; VAR x: ARRAY OF S.BYTE);
		VAR r: Files.Rider; ch: CHAR;
	BEGIN
		IF f.numEntries <= key THEN f.status := errIllegalKey; RETURN END;
		Files.Set (r, f.f, SIZE (LONGINT) + SIZE (INTEGER) + key * (f.entrySize + 1));
		Files.Read (r, ch); IF ch = deleted THEN f.status := errIllegalKey; RETURN END;
		IF LEN (x) < f.entrySize THEN Files.ReadBytes (r, x, LEN (x)) ELSE Files.ReadBytes (r, x, f.entrySize) END;
		f.status := ok
	END Read;
	
	PROCEDURE Write* (f: File; key: LONGINT; VAR x: ARRAY OF S.BYTE);
		VAR r: Files.Rider; arr: POINTER TO ARRAY OF S.BYTE;
	BEGIN
		IF f.mode # readWrite THEN f.status := errAccessMode; RETURN END;
		IF f.numEntries <= key THEN
			NEW (arr, f.entrySize + 1); arr[0] := deleted;
			Files.Set (r, f.f, SIZE (LONGINT) + SIZE (INTEGER) + f.numEntries * (f.entrySize + 1));
			WHILE f.numEntries <= key DO
				Files.WriteBytes (r, arr^, f.entrySize + 1);
				INC (f.numEntries)
			END
		END;
		Files.Set (r, f.f, SIZE (LONGINT) + SIZE (INTEGER) + key * (f.entrySize + 1));
		Files.Write (r, valid); 
		IF LEN (x) < f.entrySize THEN Files.WriteBytes (r, x, LEN (x)) ELSE Files.WriteBytes (r, x, f.entrySize) END;
		f.status := ok
	END Write;
	
	PROCEDURE Delete* (f: File; key: LONGINT);
		VAR r: Files.Rider; ch: CHAR;
	BEGIN
		IF f.mode # readWrite THEN f.status := errAccessMode; RETURN END;
		IF f.numEntries <= key THEN f.status := errIllegalKey; RETURN END;
		Files.Set (r, f.f, SIZE (LONGINT) + SIZE (INTEGER) + key * (f.entrySize + 1));
		Files.Write (r, deleted);
		f.status := ok
	END Delete;

END DAFiles.