  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt       I StampElems Alloc 17 Dec 98         Syntax10b.Scn.Fnt          	                  MarkElems Alloc H  8    8  FoldElems New                      8         r!  1    8   8    8   r    8       8      8       8         F +    8   {   8             K      )    8          c    
        8             f(J         8       8             L          8   >    8             M          #    8       8   e      MODULE CheckBoxElems; (* CE  *)

IMPORT Texts, TextFrames, TextPrinter, Oberon, Display, Viewers, Files, Fonts, Elems,
				GU := GUtils, Input;
			 	
CONST
	DUnit = TextFrames.Unit;

	MR = 0; MM = 1; ML = 2;

TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (Elems.ElemDesc)
		value* : BOOLEAN;
	END;
	
PROCEDURE Draw(e : Elem; x, y, color: INTEGER; f : Display.Frame);
VAR h, w : INTEGER; i, one : INTEGER;
BEGIN
	h := GU.Unit(e.H, TRUE); w := GU.Unit(e.W, TRUE);
	one := GU.Unit(1, FALSE);
	
	GU.Area(f, 13, 0, x, y, w, h, GU.Unit(1, FALSE), TRUE, TRUE);
	IF e.value THEN
		FOR i := 1 TO 2 DO
			(* / *)
			GU.Line(f, color, x + i + one, y + 2 * one, x + w - 3 * one, y + h - 2 * one - i, Display.paint);
			GU.Line(f, color, x + 2 * one, y + i + one, x + w - 2 * one - i, y + h - 3 * one, Display.paint);
			(* \ *)
			GU.Line(f, color, x + 2*one, y + h - 2*one - i, x + w - 2*one - i, y + 2*one, Display.paint);
			GU.Line(f, color, x + i + one, y + h - 3*one, x + w - 3*one, y + i + one, Display.paint)
		END
	END
END Draw;

PROCEDURE HandleAttrMsg(e : Elem; VAR msg : Elems.AttrMsg);
BEGIN
	Elems.Done := TRUE;	
	IF msg.id = Elems.get THEN
		IF msg.name = "Value" THEN
			msg.class := Elems.Bool;
			msg.b := e.value
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.set THEN
		IF msg.name = "Value" THEN
			IF msg.class = Elems.Bool THEN
				e.value := msg.b
			ELSIF msg.class = Elems.String THEN
				IF (CAP(msg.s[0]) = "Y") OR (CAP(msg.s[0]) = "T") THEN
					e.value := TRUE
				ELSIF (CAP(msg.s[0]) = "N") OR (CAP(msg.s[0]) = "F") THEN
					e.value := FALSE
				ELSIF CAP(msg.s[0]) = "S" THEN
					e.value := ~e.value
				END
			END
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.enum THEN
		Elems.Handle(e, msg);
		msg.enum("Value", Elems.Bool);
	ELSE
		Elems.Handle(e, msg)
	END
END HandleAttrMsg;

PROCEDURE Track(e : Elem; msg : TextFrames.TrackMsg);
VAR X, Y, w, h : INTEGER; keysum : SET; isin : BOOLEAN; exec : Elems.ExecMsg;
BEGIN
	keysum := {};
	w := SHORT(e.W DIV DUnit); h := SHORT(e.H DIV DUnit);
	isin := TRUE;
	REPEAT
		Input.Mouse(msg.keys, X, Y); keysum := keysum + msg.keys;
		Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, X, Y);
		isin := (X >= msg.X0) & (X <= msg.X0 + w) & (Y >= msg.Y0) & (Y <= msg.Y0 + h);
	UNTIL (msg.keys = {}) OR (MR IN msg.keys);

	IF isin & (msg.keys = {}) THEN
		e.value := ~e.value;
		Elems.UpdateElem(e);
		exec.e := e; exec.x := msg.X0; exec.y := msg.Y0; exec.f := msg.frame; exec.unload := ML IN keysum;		
		e.handle(e, exec)
	END
END Track;

PROCEDURE Handle* (E: Texts.Elem; VAR msg: Texts.ElemMsg);
VAR copy: Elem; ch: CHAR;
BEGIN
	WITH E : Elem DO
		WITH msg: TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				Draw(E, msg.X0, msg.Y0, msg.col, msg.frame)
			END
		| msg : TextPrinter.PrintMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.printer);
				Draw(E, msg.X0, msg.Y0, msg.col, NIL);
				GU.SetDevice(GU.display)
			END
		| msg : Texts.CopyMsg DO
			IF msg.e = NIL THEN NEW(copy); msg.e := copy ELSE copy := msg.e(Elem) END;
			Elems.CopyElem(E, copy);
			copy.value := E.value;
			msg.e := copy;
		| msg: Texts.IdentifyMsg DO msg.mod := "CheckBoxElems"; msg.proc := "New"
		| msg: Texts.FileMsg DO
			Elems.Handle(E, msg);
			IF msg.id = Texts.load THEN
				Files.Read(msg.r, ch); (* version -> not yet used *)
				Files.ReadBool(msg.r, E.value)
			ELSIF msg.id = Texts.store THEN
				Files.Write(msg.r, 0X); (* version *)
				Files.WriteBool(msg.r, E.value)
			END
		| msg : Elems.AttrMsg DO
			HandleAttrMsg(E, msg)
		| msg : TextFrames.TrackMsg DO
			Elems.Handle(E, msg);
			IF msg.keys = {MM} THEN Track(E, msg) END
		ELSE
			Elems.Handle(E, msg)
		END
	END
END Handle;

PROCEDURE Init*(e : Elem);
BEGIN
	Elems.Init(e);
	e.handle := Handle;
	e.H := LONG(Fonts.Default.maxY - Fonts.Default.minY) * DUnit;
	e.W := e.H
END Init;

PROCEDURE New*;
VAR e : Elem;
BEGIN NEW(e); Init(e); Texts.new := e;
END New;

PROCEDURE Insert*; (** Name Cmd Par W H ("Y" | "N") *)
VAR e : Elem; m : TextFrames.InsertElemMsg; s : Texts.Scanner;
BEGIN
	NEW(e); Init(e);
	Elems.GetPar(e, s);
	IF ~s.eot & (s.class IN {Texts.Name, Texts.String}) THEN
		e.value := CAP(s.s[0]) = "Y"
	END;
	m.e := e; Viewers.Broadcast(m)
END Insert;

END CheckBoxElems.

System.Free CheckBoxElems ~

CheckBoxElems.Insert "" System.Time "" 0 0  Y~



