#   Syntax10.Scn.Fnt  K   K  MODULE CRP; 
(* parser module generated by Coco-R *)

IMPORT CRS, CRT, CRA, CRX, Sets, Texts, Oberon;

CONST 
	maxP        = 42;
  maxT        = 41;
  nrSets = 20;

	setSize = 32;  nSets = (maxT DIV setSize) + 1;

TYPE
	SymbolSet = ARRAY nSets OF SET;

VAR
	sym:     INTEGER;   (* current input symbol *)
	symSet:  ARRAY nrSets OF SymbolSet;

CONST
  ident = 0; string = 1; (*symbol kind*)
  
VAR 
  str: ARRAY 32 OF CHAR;
  w:   Texts.Writer;
  genScanner: BOOLEAN;


PROCEDURE SemErr(nr: INTEGER);
BEGIN
  CRS.Error(200+nr, CRS.pos);
END SemErr;

PROCEDURE MatchLiteral(sp: INTEGER); (*store string either as token or as literal*)
  VAR sn, sn1: CRT.SymbolNode; matchedSp: INTEGER;
BEGIN
  CRT.GetSym(sp, sn);
  CRA.MatchDFA(sn.name, sp, matchedSp);
  IF matchedSp # CRT.noSym THEN
    CRT.GetSym(matchedSp, sn1); sn1.struct := CRT.classLitToken; CRT.PutSym(matchedSp, sn1);
    sn.struct := CRT.litToken
  ELSE sn.struct := CRT.classToken;
  END;
  CRT.PutSym(sp, sn)
END MatchLiteral;

PROCEDURE SetCtx(gp: INTEGER); (*set transition code to CRT.contextTrans*)
  VAR gn: CRT.GraphNode;
BEGIN
  WHILE gp > 0 DO
    CRT.GetNode(gp, gn);
    IF gn.typ IN {CRT.char, CRT.class} THEN
        gn.p2 := CRT.contextTrans; CRT.PutNode(gp, gn)
    ELSIF gn.typ IN {CRT.opt, CRT.iter} THEN SetCtx(gn.p1)
    ELSIF gn.typ = CRT.alt THEN SetCtx(gn.p1); SetCtx(gn.p2)
    END;
    gp := gn.next
  END
END SetCtx;

PROCEDURE SetDDT(s: ARRAY OF CHAR);
  VAR name: ARRAY 64 OF CHAR; i: INTEGER; ch: CHAR;
BEGIN
  i := 1;
  WHILE s[i] # 0X DO
    ch := s[i]; INC(i);
    IF (ch >= "0") & (ch <= "9") THEN CRT.ddt[ORD(ch)-ORD("0")] := TRUE END
  END
END SetDDT;

PROCEDURE FixString (VAR s: ARRAY OF CHAR; len: INTEGER);
	VAR double: BOOLEAN; i: INTEGER;
BEGIN
	double := FALSE;
	FOR i := 0 TO len-2 DO
		IF s[i] = '"' THEN double := TRUE ELSIF s[i] = " " THEN SemErr(24) END
	END;
	IF ~ double THEN s[0] := '"'; s[len-1] := '"' END
END FixString;

(*-------------------------------------------------------------------------*)


PROCEDURE Error (n: INTEGER);
BEGIN CRS.Error(n, CRS.nextPos)
END Error;

PROCEDURE Get;
BEGIN
	LOOP CRS.Get(sym);
    IF sym > maxT THEN
      IF sym = 42 THEN
         CRS.GetName(CRS.nextPos, CRS.nextLen, str); SetDDT(str) 
      END ;
      CRS.nextPos := CRS.pos;
      CRS.nextCol := CRS.col;
      CRS.nextLine := CRS.line;
      CRS.nextLen := CRS.len;
    ELSE EXIT
    END
END

END Get;

PROCEDURE Expect(n: INTEGER);
BEGIN IF sym = n THEN Get ELSE Error(n) END
END Expect;

PROCEDURE StartOf(s: INTEGER): BOOLEAN;
BEGIN RETURN (sym MOD setSize) IN symSet[s, sym DIV setSize]
END StartOf;

PROCEDURE ExpectWeak(n, follow: INTEGER);
BEGIN
	IF sym = n THEN Get
	ELSE Error(n); WHILE ~ StartOf(follow) DO Get END
	END
END ExpectWeak;

PROCEDURE WeakSeparator(n, syFol, repFol: INTEGER): BOOLEAN;
	VAR s: SymbolSet; i: INTEGER;
BEGIN
	IF sym = n THEN Get; RETURN TRUE
	ELSIF StartOf(repFol) THEN RETURN FALSE
	ELSE
		i := 0; WHILE i < nSets DO s[i] := symSet[syFol, i] + symSet[repFol, i] + symSet[0, i]; INC(i) END;
		Error(n); WHILE ~ ((sym MOD setSize) IN s[sym DIV setSize]) DO Get END;
		RETURN StartOf(syFol)
	END
END WeakSeparator;

PROCEDURE ^TokenFactor(VAR gL, gR: INTEGER);
PROCEDURE ^TokenTerm(VAR gL, gR: INTEGER);
PROCEDURE ^Factor(VAR gL, gR: INTEGER);
PROCEDURE ^Term(VAR gL, gR: INTEGER);
PROCEDURE ^Symbol(VAR name: CRT.Name; VAR kind: INTEGER);
PROCEDURE ^SimSet(VAR set: CRT.Set);
PROCEDURE ^Set(VAR set: CRT.Set);
PROCEDURE ^TokenExpr(VAR gL, gR: INTEGER);
PROCEDURE ^TokenDecl(typ: INTEGER);
PROCEDURE ^SetDecl;
PROCEDURE ^Expression(VAR gL, gR: INTEGER);
PROCEDURE ^SemText(VAR semPos: CRT.Position);
PROCEDURE ^Attribs(VAR attrPos: CRT.Position);
PROCEDURE ^Declaration;
PROCEDURE ^CR;

PROCEDURE TokenFactor(VAR gL, gR: INTEGER);
  VAR kind, c: INTEGER; set: CRT.Set; name: CRT.Name;  
BEGIN
  gL :=0; gR := 0 ;
  IF (sym = 1) OR (sym = 2) THEN
    Symbol(name, kind);
    IF kind = ident THEN
      c := CRT.ClassWithName(name);
      IF c < 0 THEN
        SemErr(15); 
        Sets.Clear(set); c := CRT.NewClass(name, set)
      END;
      gL := CRT.NewNode(CRT.class, c, 0); gR := gL
    ELSE (*string*)
      CRT.StrToGraph(name, gL, gR)
    END ;
  ELSIF (sym = 24) THEN
    Get;
    TokenExpr(gL, gR);
    Expect(25);
  ELSIF (sym = 29) THEN
    Get;
    TokenExpr(gL, gR);
    Expect(30);
    CRT.MakeOption(gL, gR) ;
  ELSIF (sym = 31) THEN
    Get;
    TokenExpr(gL, gR);
    Expect(32);
    CRT.MakeIteration(gL, gR) ;
  ELSE Error(42)
  END ;
END TokenFactor;

PROCEDURE TokenTerm(VAR gL, gR: INTEGER);
  VAR gL2, gR2: INTEGER;  
BEGIN
  TokenFactor(gL, gR);
  WHILE StartOf(1)  DO
    TokenFactor(gL2, gR2);
    CRT.ConcatSeq(gL, gR, gL2, gR2) ;
  END ;
  IF (sym = 34) THEN
    Get;
    Expect(24);
    TokenExpr(gL2, gR2);
    SetCtx(gL2); CRT.ConcatSeq(gL, gR, gL2, gR2) ;
    Expect(25);
  END ;
END TokenTerm;

PROCEDURE Factor(VAR gL, gR: INTEGER);
  VAR sp, kind, c: INTEGER; name: CRT.Name;
      gn: CRT.GraphNode; sn: CRT.SymbolNode;
      set: CRT.Set;
      undef, weak: BOOLEAN;
      pos: CRT.Position;  
BEGIN
  gL :=0; gR := 0; weak := FALSE ;
  CASE sym OF
  | 1,2,28:     IF (sym = 28) THEN
      Get;
      weak := TRUE ;
    END ;
    Symbol(name, kind);
    sp := CRT.FindSym(name); undef := sp = CRT.noSym;
    IF undef THEN
      IF kind = ident THEN  (*forward nt*)
        sp := CRT.NewSym(CRT.nt, name, 0)
      ELSE  (*undefined string in production*)
        sp := CRT.NewSym(CRT.t, name, CRS.line);
        MatchLiteral(sp)
      END
    END;
    CRT.GetSym(sp, sn);
    IF ~(sn.typ IN {CRT.t,CRT.nt}) THEN SemErr(4) END;
    IF weak THEN 
      IF sn.typ = CRT.t THEN sn.typ := CRT.wt ELSE SemErr(23) END
    END;
    gL := CRT.NewNode(sn.typ, sp, CRS.line); gR := gL ;
    IF (sym = 35) OR (sym = 37) THEN
      Attribs(pos);
      CRT.GetNode(gL, gn); gn.pos := pos; CRT.PutNode(gL, gn);
      CRT.GetSym(sp, sn);
      IF undef THEN 
        sn.attrPos := pos; CRT.PutSym(sp, sn)
      ELSIF sn.attrPos.beg < 0 THEN SemErr(5)
      END;
      IF kind # ident THEN SemErr(3) END ;
    ELSIF StartOf(2)  THEN
      CRT.GetSym(sp, sn);
      IF sn.attrPos.beg >= 0 THEN SemErr(6) END ;
    ELSE Error(43)
    END ;
  | 24:     Get;
    Expression(gL, gR);
    Expect(25);
  | 29:     Get;
    Expression(gL, gR);
    Expect(30);
    CRT.MakeOption(gL, gR) ;
  | 31:     Get;
    Expression(gL, gR);
    Expect(32);
    CRT.MakeIteration(gL, gR) ;
  | 39:     SemText(pos);
    gL := CRT.NewNode(CRT.sem, 0, 0); 
    gR := gL;
    CRT.GetNode(gL, gn); gn.pos := pos; CRT.PutNode(gL, gn) ;
  | 26:     Get;
    Sets.Fill(set); Sets.Excl(set, CRT.eofSy);
    gL := CRT.NewNode(CRT.any, CRT.NewSet(set), 0); gR := gL ;
  | 33:     Get;
    gL := CRT.NewNode(CRT.sync, 0, 0); gR := gL ;
  ELSE Error(44)
  END ;
END Factor;

PROCEDURE Term(VAR gL, gR: INTEGER);
  VAR gL2, gR2: INTEGER;  
BEGIN
  gL := 0; gR := 0 ;
  IF StartOf(3)  THEN
    Factor(gL, gR);
    WHILE StartOf(3)  DO
      Factor(gL2, gR2);
      CRT.ConcatSeq(gL, gR, gL2, gR2) ;
    END ;
  ELSIF StartOf(4)  THEN
    gL := CRT.NewNode(CRT.eps, 0, 0); gR := gL ;
  ELSE Error(45)
  END ;
END Term;

PROCEDURE Symbol(VAR name: CRT.Name; VAR kind: INTEGER);
BEGIN
  IF (sym = 1) THEN
    Get;
    kind := ident ;
  ELSIF (sym = 2) THEN
    Get;
    kind := string ;
  ELSE Error(46)
  END ;
  CRS.GetName(CRS.pos, CRS.len, name);
  IF kind = string THEN FixString(name, CRS.len) END ;
END Symbol;

PROCEDURE SimSet(VAR set: CRT.Set);
  VAR c, n, i: INTEGER; name: CRT.Name; s: ARRAY 128 OF CHAR;  
BEGIN
  IF (sym = 1) THEN
    Get;
    CRS.GetName(CRS.pos, CRS.len, name);
    c := CRT.ClassWithName(name);
    IF c < 0 THEN SemErr(15); Sets.Clear(set)
    ELSE CRT.GetClass(c, set)
    END ;
  ELSIF (sym = 2) THEN
    Get;
    CRS.GetName(CRS.pos, CRS.len, s);
    Sets.Clear(set); i := 1; 
    WHILE s[i] # s[0] DO
      Sets.Incl(set, ORD(s[i])); INC(i)
    END ;
  ELSIF (sym = 23) THEN
    Get;
    Expect(24);
    Expect(4);
    CRS.GetName(CRS.pos, CRS.len, name);
    n := 0; i := 0;
    WHILE name[i] # 0X DO
      n := 10 * n + (ORD(name[i]) - ORD("0"));
      INC(i)
    END;
    Sets.Clear(set); Sets.Incl(set, n) ;
    Expect(25);
  ELSIF (sym = 26) THEN
    Get;
    Sets.Fill(set) ;
  ELSE Error(47)
  END ;
END SimSet;

PROCEDURE Set(VAR set: CRT.Set);
  VAR set2: CRT.Set;  
BEGIN
  SimSet(set);
  WHILE (sym = 21) OR (sym = 22) DO
    IF (sym = 21) THEN
      Get;
      SimSet(set2);
      Sets.Unite(set, set2) ;
    ELSE
      Get;
      SimSet(set2);
      Sets.Differ(set, set2) ;
    END ;
  END ;
END Set;

PROCEDURE TokenExpr(VAR gL, gR: INTEGER);
  VAR gL2, gR2: INTEGER; first: BOOLEAN;  
BEGIN
  TokenTerm(gL, gR);
  first := TRUE ;
  WHILE WeakSeparator(27, 1, 5)  DO
    TokenTerm(gL2, gR2);
    IF first THEN 
      CRT.MakeFirstAlt(gL, gR); first := FALSE
    END;
    CRT.ConcatAlt(gL, gR, gL2, gR2) ;
  END ;
END TokenExpr;

PROCEDURE TokenDecl(typ: INTEGER);
  VAR sp, kind, gL, gR: INTEGER; sn: CRT.SymbolNode;
      pos: CRT.Position; name: CRT.Name;  
BEGIN
  Symbol(name, kind);
  IF CRT.FindSym(name) # CRT.noSym THEN SemErr(7)
  ELSE 
    sp := CRT.NewSym(typ, name, CRS.line);
    CRT.GetSym(sp, sn); sn.struct := CRT.classToken;
    CRT.PutSym(sp, sn)
  END ;
  WHILE ~( StartOf(6) ) DO Error(48); Get END ;
  IF (sym = 9) THEN
    Get;
    TokenExpr(gL, gR);
    Expect(10);
    IF kind # ident THEN SemErr(13) END;
    CRT.CompleteGraph(gR);
    CRA.ConvertToStates(gL, sp) ;
  ELSIF StartOf(7)  THEN
    IF kind = ident THEN genScanner := FALSE
    ELSE MatchLiteral(sp)
    END ;
  ELSE Error(49)
  END ;
  IF (sym = 39) THEN
    SemText(pos);
    IF typ = CRT.t THEN SemErr(14) END;
    CRT.GetSym(sp, sn); sn.semPos := pos; CRT.PutSym(sp, sn) ;
  END ;
END TokenDecl;

PROCEDURE SetDecl;
  VAR c: INTEGER; set: CRT.Set; name: CRT.Name;  
BEGIN
  Expect(1);
  CRS.GetName(CRS.pos, CRS.len, name);
  c := CRT.ClassWithName(name); IF c >= 0 THEN SemErr(7) END ;
  Expect(9);
  Set(set);
  c := CRT.NewClass(name, set) ;
  Expect(10);
END SetDecl;

PROCEDURE Expression(VAR gL, gR: INTEGER);
  VAR gL2, gR2: INTEGER; first: BOOLEAN;  
BEGIN
  Term(gL, gR);
  first := TRUE ;
  WHILE WeakSeparator(27, 2, 8)  DO
    Term(gL2, gR2);
    IF first THEN 
      CRT.MakeFirstAlt(gL, gR); first := FALSE
    END;
    CRT.ConcatAlt(gL, gR, gL2, gR2) ;
  END ;
END Expression;

PROCEDURE SemText(VAR semPos: CRT.Position);
BEGIN
  Expect(39);
  semPos.beg := CRS.nextPos; semPos.col := CRS.nextCol ;
  WHILE StartOf(9)  DO
    IF StartOf(10)  THEN
      Get;
    ELSIF (sym = 3) THEN
      Get;
      SemErr(18) ;
    ELSE
      Get;
      SemErr(19) ;
    END ;
  END ;
  Expect(40);
  semPos.len := CRS.pos - semPos.beg ;
END SemText;

PROCEDURE Attribs(VAR attrPos: CRT.Position);
BEGIN
  IF (sym = 35) THEN
    Get;
    attrPos.beg := CRS.nextPos; attrPos.col := CRS.nextCol ;
    WHILE StartOf(11)  DO
      Get;
    END ;
    Expect(36);
    attrPos.len := CRS.pos - attrPos.beg ;
  ELSIF (sym = 37) THEN
    Get;
    attrPos.beg := CRS.nextPos; attrPos.col := CRS.nextCol ;
    WHILE StartOf(12)  DO
      Get;
    END ;
    Expect(38);
    attrPos.len := CRS.pos - attrPos.beg ;
  ELSE Error(50)
  END ;
END Attribs;

PROCEDURE Declaration;
  VAR gL1, gR1, gL2, gR2: INTEGER; nested: BOOLEAN;  
BEGIN
  IF (sym = 12) THEN
    Get;
    WHILE (sym = 1) DO
      SetDecl;
    END ;
  ELSIF (sym = 13) THEN
    Get;
    WHILE (sym = 1) OR (sym = 2) DO
      TokenDecl(CRT.t);
    END ;
  ELSIF (sym = 14) THEN
    Get;
    WHILE (sym = 1) OR (sym = 2) DO
      TokenDecl(CRT.pr);
    END ;
  ELSIF (sym = 15) THEN
    Get;
    Expect(16);
    TokenExpr(gL1, gR1);
    Expect(17);
    TokenExpr(gL2, gR2);
    IF (sym = 18) THEN
      Get;
      nested := TRUE ;
    ELSIF StartOf(13)  THEN
      nested := FALSE ;
    ELSE Error(51)
    END ;
    CRA.NewComment(gL1, gL2, nested) ;
  ELSIF (sym = 19) THEN
    Get;
    IF (sym = 20) THEN
      Get;
      CRT.ignoreCase := TRUE ;
    ELSIF StartOf(14)  THEN
      Set(CRT.ignored);
    ELSE Error(52)
    END ;
  ELSE Error(53)
  END ;
END Declaration;

PROCEDURE CR;
  VAR undef, hasAttrs, ok, ok1: BOOLEAN; eofSy, gR: INTEGER; 
      gramLine, sp: INTEGER;
      gn: CRT.GraphNode; sn: CRT.SymbolNode; 
      name, gramName: CRT.Name;  
BEGIN
  Expect(5);
  Texts.OpenWriter(w);
  CRT.Init; CRX.Init; CRA.Init;
  gramLine := CRS.line;
  eofSy := CRT.NewSym(CRT.t, "EOF", 0);
  genScanner := TRUE;
  CRT.ignoreCase := FALSE;
  ok := TRUE;
  Sets.Clear(CRT.ignored) ;
  Expect(1);
  CRS.GetName(CRS.pos, CRS.len, gramName);
  CRT.semDeclPos.beg := CRS.nextPos; CRT.importPos.beg := -1; ;
  WHILE StartOf(15)  DO
    IF (sym = 6) THEN
      Get;
      CRT.importPos.beg := CRS.nextPos ;
      WHILE StartOf(16)  DO
        Get;
      END ;
      Expect(7);
      CRT.importPos.len := CRS.pos - CRT.importPos.beg;
      CRT.importPos.col := 0;
      CRT.semDeclPos.beg := CRS.nextPos ;
    ELSE
      Get;
    END ;
  END ;
  CRT.semDeclPos.len := CRS.nextPos - CRT.semDeclPos.beg;
  CRT.semDeclPos.col := 0 ;
  WHILE StartOf(17)  DO
    Declaration;
  END ;
  WHILE ~( (sym = 0) OR (sym = 8)) DO Error(54); Get END ;
  Expect(8);
  IF genScanner THEN CRA.MakeDeterministic(ok) END;
  CRT.nNodes := 0 ;
  WHILE (sym = 1) DO
    Get;
    CRS.GetName(CRS.pos, CRS.len, name); 
    sp := CRT.FindSym(name); undef := sp = CRT.noSym;
    IF undef THEN
      sp := CRT.NewSym(CRT.nt, name, CRS.line);
      CRT.GetSym(sp, sn);
    ELSE
      CRT.GetSym(sp, sn);
      IF sn.typ = CRT.nt THEN
        IF sn.struct > 0 THEN SemErr(7) END
      ELSE SemErr(8)
      END;
      sn.line := CRS.line
    END;
    hasAttrs := sn.attrPos.beg >= 0 ;
    IF (sym = 35) OR (sym = 37) THEN
      Attribs(sn.attrPos);
      IF ~undef & ~hasAttrs THEN SemErr(9) END;
      CRT.PutSym(sp, sn) ;
    ELSIF (sym = 9) OR (sym = 39) THEN
      IF ~undef & hasAttrs THEN SemErr(10) END ;
    ELSE Error(55)
    END ;
    IF (sym = 39) THEN
      SemText(sn.semPos);
    END ;
    ExpectWeak(9, 18);
    Expression(sn.struct, gR);
    CRT.CompleteGraph(gR); CRT.PutSym(sp, sn);
    IF CRT.ddt[2] THEN CRT.PrintGraph END ;
    ExpectWeak(10, 19);
  END ;
  sp := CRT.FindSym(gramName);
  IF sp = CRT.noSym THEN SemErr(11);
  ELSE
    CRT.GetSym(sp, sn); 
    IF sn.attrPos.beg >= 0 THEN SemErr(12) END;
    CRT.root := CRT.NewNode(CRT.nt, sp, gramLine);
  END ;
  Expect(11);
  Expect(1);
  CRS.GetName(CRS.pos, CRS.len, name); 
  IF name # gramName THEN SemErr(17) END;
  IF CRS.errors = 0 THEN
    Texts.WriteString(w, " checking"); Texts.Append(Oberon.Log, w.buf);
    CRT.CompSymbolSets;
    IF ok THEN CRT.TestCompleteness(ok) END;
    IF ok THEN
      CRT.TestIfAllNtReached(ok1); CRT.FindCircularProductions(ok)
    END;
    IF ok THEN CRT.TestIfNtToTerm(ok) END;
    IF ok THEN CRT.LL1Test(ok1) END;
    IF CRT.ddt[0] THEN CRA.PrintStates END;
    IF CRT.ddt[7] THEN CRT.XRef END;
    IF ok THEN
      Texts.WriteString(w, " +parser");
      Texts.Append(Oberon.Log, w.buf);
      CRX.GenCompiler;
      IF genScanner THEN
        Texts.WriteString(w, " +scanner");
        Texts.Append(Oberon.Log, w.buf);
        CRA.WriteScanner
      END;
      IF CRT.ddt[8] THEN CRX.WriteStatistics END
    END
  ELSE ok := FALSE
  END;
  IF CRT.ddt[6] THEN CRT.PrintSymbolTable END;
  IF ok THEN Texts.WriteString(w, " done") END;
  Texts.WriteLn(w); Texts.Append(Oberon.Log, w.buf) ;
  Expect(10);
END CR;



PROCEDURE Parse*;
BEGIN
	Get;
  CR;

END Parse;

BEGIN
  symSet[0, 0] := {0,1,2,8,9,12,13,14,15,19};
  symSet[0, 1] := {7};
  symSet[1, 0] := {1,2,24,29,31};
  symSet[1, 1] := {};
  symSet[2, 0] := {1,2,10,24,25,26,27,28,29,30,31};
  symSet[2, 1] := {0,1,7};
  symSet[3, 0] := {1,2,24,26,28,29,31};
  symSet[3, 1] := {1,7};
  symSet[4, 0] := {10,25,27,30};
  symSet[4, 1] := {0};
  symSet[5, 0] := {8,10,12,13,14,15,17,18,19,25,30};
  symSet[5, 1] := {0};
  symSet[6, 0] := {0,1,2,8,9,12,13,14,15,19};
  symSet[6, 1] := {7};
  symSet[7, 0] := {1,2,8,12,13,14,15,19};
  symSet[7, 1] := {7};
  symSet[8, 0] := {10,25,30};
  symSet[8, 1] := {0};
  symSet[9, 0] := {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[9, 1] := {0,1,2,3,4,5,6,7,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[10, 0] := {1,2,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[10, 1] := {0,1,2,3,4,5,6,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[11, 0] := {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[11, 1] := {0,1,2,3,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[12, 0] := {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[12, 1] := {0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[13, 0] := {8,12,13,14,15,19};
  symSet[13, 1] := {};
  symSet[14, 0] := {1,2,23,26};
  symSet[14, 1] := {};
  symSet[15, 0] := {1,2,3,4,5,6,7,9,10,11,16,17,18,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[15, 1] := {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[16, 0] := {1,2,3,4,5,6,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[16, 1] := {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};
  symSet[17, 0] := {12,13,14,15,19};
  symSet[17, 1] := {};
  symSet[18, 0] := {0,1,2,8,9,10,12,13,14,15,19,24,26,27,28,29,31};
  symSet[18, 1] := {1,7};
  symSet[19, 0] := {0,1,2,8,9,11,12,13,14,15,19};
  symSet[19, 1] := {7};

END CRP.
  |  0: Msg("EOF expected")
  |  1: Msg("ident expected")
  |  2: Msg("string expected")
  |  3: Msg("badString expected")
  |  4: Msg("number expected")
  |  5: Msg("'COMPILER' expected")
  |  6: Msg("'IMPORT' expected")
  |  7: Msg("';' expected")
  |  8: Msg("'PRODUCTIONS' expected")
  |  9: Msg("'=' expected")
  | 10: Msg("'.' expected")
  | 11: Msg("'END' expected")
  | 12: Msg("'CHARACTERS' expected")
  | 13: Msg("'TOKENS' expected")
  | 14: Msg("'PRAGMAS' expected")
  | 15: Msg("'COMMENTS' expected")
  | 16: Msg("'FROM' expected")
  | 17: Msg("'TO' expected")
  | 18: Msg("'NESTED' expected")
  | 19: Msg("'IGNORE' expected")
  | 20: Msg("'CASE' expected")
  | 21: Msg("'+' expected")
  | 22: Msg("'-' expected")
  | 23: Msg("'CHR' expected")
  | 24: Msg("'(' expected")
  | 25: Msg("')' expected")
  | 26: Msg("'ANY' expected")
  | 27: Msg("'|' expected")
  | 28: Msg("'WEAK' expected")
  | 29: Msg("'[' expected")
  | 30: Msg("']' expected")
  | 31: Msg("'{' expected")
  | 32: Msg("'}' expected")
  | 33: Msg("'SYNC' expected")
  | 34: Msg("'CONTEXT' expected")
  | 35: Msg("'<' expected")
  | 36: Msg("'>' expected")
  | 37: Msg("'<.' expected")
  | 38: Msg("'.>' expected")
  | 39: Msg("'(.' expected")
  | 40: Msg("'.)' expected")
  | 41: Msg("??? expected")
  | 42: Msg("invalid TokenFactor")
  | 43: Msg("invalid Factor")
  | 44: Msg("invalid Factor")
  | 45: Msg("invalid Term")
  | 46: Msg("invalid Symbol")
  | 47: Msg("invalid SimSet")
  | 48: Msg("this symbol not expected in TokenDecl")
  | 49: Msg("invalid TokenDecl")
  | 50: Msg("invalid Attribs")
  | 51: Msg("invalid Declaration")
  | 52: Msg("invalid Declaration")
  | 53: Msg("invalid Declaration")
  | 54: Msg("this symbol not expected in CR")
  | 55: Msg("invalid CR")
