  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt      	  StampElems Alloc 2002-Aug-12         Syntax10b.Scn.Fnt          	            %      MarkElems Alloc H  ]    8  FoldElems New              8         F +    8      8   #   Syntax10.Scn.Fnt  F    F    (X < msg.X0) OR (X > msg.X0 + w) OR (Y < msg.Y0) OR (Y > msg.Y0 + h)      8      8         (  1    8      8             K      )    8          i    
    e    8              9         8       8             L          8   =    8             M                  8       8   `      MODULE ButtonElems; (* CE  *)

IMPORT Texts, TextFrames, TextPrinter, Oberon, Display, Viewers, Files, Fonts, GU := GUtils, Elems,
			 Input;
		 	
CONST
	DUnit = TextFrames.Unit;
	ML = 2; MM = 1; MR = 0;
			
TYPE
	Elem* = POINTER TO ElemDesc;
	ElemDesc* = RECORD (Elems.ElemDesc)
		caption*: ARRAY 64 OF CHAR;
	END;

PROCEDURE Draw(e : Elem; x, y, color: INTEGER; fnt : Fonts.Font; f : Display.Frame; pressed : BOOLEAN);
VAR h, w, diy, dix : INTEGER;
BEGIN
	h := GU.Unit(e.H, TRUE);	w := GU.Unit(e.W, TRUE);
	GU.Area(f, 13, 0, x, y, w, h, GU.Unit(1, FALSE), TRUE, pressed);
	IF pressed THEN diy := -1; dix := 1 ELSE diy := 0; dix := 0 END;	(* only at display *)
	IF h > GU.Unit(fnt.maxY-fnt.minY, FALSE) THEN
		diy := (h DIV 2) - (GU.Unit(fnt.minY + fnt.maxY, FALSE) DIV 2) + diy;
		GU.String(f, e.caption, x + dix, y + diy, w - dix, fnt, color, Display.paint, GU.center)
	END
END Draw;

PROCEDURE Track(e : Elem; msg : TextFrames.TrackMsg);
VAR X, Y, w, h : INTEGER; keysum : SET; exec : Elems.ExecMsg; pressed : BOOLEAN;
BEGIN
	Input.Mouse(msg.keys, X, Y);
	IF msg.keys = {} THEN
		pressed := TRUE
	ELSE
		pressed := FALSE; keysum := msg.keys;
		w := SHORT(e.W DIV DUnit); h := SHORT(e.H DIV DUnit);
		REPEAT
			Input.Mouse(msg.keys, X, Y); keysum := keysum + msg.keys;
			Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, X, Y);
			IF  outside button  THEN
				IF pressed THEN
					pressed := FALSE; Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, msg.frame, FALSE)
				END
			ELSIF ~pressed THEN
				pressed := TRUE; Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, msg.frame, TRUE)
			END
		UNTIL msg.keys = {};
	
		Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, msg.frame, FALSE)
	END;
	
	IF pressed & ~(MR IN keysum) THEN
		exec.e := e; exec.x := msg.X0; exec.y := msg.Y0;
		exec.f := msg.frame; exec.unload := ML IN keysum;
		e.handle(e, exec)
	END
END Track;

PROCEDURE HandleAttrMsg(e : Elem; VAR msg : Elems.AttrMsg);
BEGIN
	Elems.Done := TRUE;
	IF msg.id = Elems.get THEN
		IF msg.name = "Caption" THEN
			msg.class := Elems.String;
			COPY(e(Elem).caption, msg.s)
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.set THEN
		IF msg.name = "Caption" THEN
			IF msg.class = Elems.String THEN COPY(msg.s, e.caption) END
		ELSE
			Elems.Handle(e, msg)
		END
	ELSIF msg.id = Elems.enum THEN
		Elems.Handle(e, msg);
		msg.enum("Caption", Elems.String)
	ELSE
		Elems.Handle(e, msg)
	END
END HandleAttrMsg;

PROCEDURE Handle*(e: Texts.Elem; VAR msg: Texts.ElemMsg); 
VAR ch : CHAR; copy : Elem;
BEGIN
	WITH e : Elem DO
		WITH msg: TextFrames.DisplayMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.display);
				Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, msg.frame, FALSE)
			END
		| msg : TextPrinter.PrintMsg DO
			IF ~msg.prepare THEN
				GU.SetDevice(GU.printer);
				Draw(e, msg.X0, msg.Y0, msg.col, msg.fnt, NIL, FALSE);
				GU.SetDevice(GU.display)
			END
		| msg : Texts.CopyMsg DO
			IF msg.e = NIL THEN NEW(copy); msg.e := copy ELSE copy := msg.e(Elem) END;
			Elems.CopyElem(e, copy);
			COPY(e.caption, copy.caption); 
			msg.e := copy
		| msg: Texts.IdentifyMsg DO msg.mod := "ButtonElems"; msg.proc := "New"
		| msg : TextFrames.TrackMsg DO
			Elems.Handle(e, msg);
			IF msg.keys = {MM} THEN Track(e, msg) END
		| msg : Elems.AttrMsg DO
			HandleAttrMsg(e, msg)
		| msg: Texts.FileMsg DO
			Elems.Handle(e, msg);
			IF msg.id = Texts.load THEN
				Files.Read(msg.r, ch);	(* version -> not yet used *)
				Files.ReadString(msg.r, e.caption); 
			ELSIF msg.id = Texts.store THEN
				Files.Write(msg.r, 0X);	(* version *)
				Files.WriteString(msg.r, e.caption)
			END
		ELSE
			Elems.Handle(e, msg)
		END
	END
END Handle;

PROCEDURE Init* (e : Elem);
BEGIN
	Elems.Init(e);
	e.handle := Handle;
	e.caption := "Button";
	e.W := 50 * DUnit;
	e.H := LONG(Fonts.Default.maxY - Fonts.Default.minY + 5) * DUnit
END Init;

PROCEDURE New*;
VAR e : Elem;
BEGIN NEW(e); Init(e); Texts.new := e
END New;

PROCEDURE Insert*; (** Name Cmd Par W H Caption *) 
VAR e: Elem; m: TextFrames.InsertElemMsg; s : Texts.Scanner;
BEGIN
	NEW(e); Init(e);
	Elems.GetPar(e, s);
	IF ~s.eot & (s.class IN {Texts.String, Texts.Name}) THEN
		COPY(s.s, e.caption)
	END;
	m.e := e; Viewers.Broadcast(m)
END Insert;

END ButtonElems.

System.Free ButtonElems ~

ButtonElems.Insert "" System.Time "" 0 0 Test ~

