   Syntax10.Scn.Fnt       I StampElems Alloc 24 Feb 97    Syntax10b.Scn.Fnt                 J  MODULE Batch; (* mah  *)
(*
	Batch execution Batch.Start ('^' | name)
	If file 'name' does not exist the text trailing the command is taken as batch job.
	Every line starting with a command (no leading spaces) is executed. Lines with leading
	spaces are omitted. If a line starts with the char '~' the batch job is terminated.
*)
IMPORT Texts, TextFrames, Oberon, In, Out, Input;

VAR
	w : Texts.Writer;

PROCEDURE Start*;
	VAR
		S: Texts.Scanner; beg, end, time: LONGINT; res: INTEGER;
		text: Texts.Text; sel: BOOLEAN; p: Oberon.ParList; ch: CHAR;
BEGIN
	sel:= FALSE; Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S); 
	IF (S.class = Texts.Char) & (S.c = "^") THEN
		Oberon.GetSelection(text, beg, end, time); sel:= TRUE;
		IF time >= 0 THEN Texts.OpenScanner(S, text, beg); Texts.Scan(S) END
	END;
	IF (S.class # Texts.Name) & (S.class # Texts.String) THEN RETURN END;
	text := TextFrames.Text(S.s);
	IF sel & (text.len = 0) THEN RETURN END; 	

	NEW (p);
	IF text.len # 0 THEN
		Oberon.Par.text:=  text; beg:=  0
	ELSE 
		Texts.OpenReader (S, Oberon.Par.text, Oberon.Par.pos);
		REPEAT Texts.Read (S, ch) UNTIL S.eot OR (ch = CHR(13));
		beg:= Texts.Pos (S)
	END;
	Texts.OpenReader (S, Oberon.Par.text, beg-1); Texts.Read (S, ch);
	REPEAT
		WHILE ~S.eot & (ch # CHR(13)) DO
			Texts.Read (S, ch)
		END;
		Texts.Read (S, ch)
	UNTIL S.eot OR ((CAP(ch) >= 'A') & (CAP(ch) <= 'Z')) OR (ch= '~' );
	Texts.OpenScanner (S, Oberon.Par.text, Texts.Pos (S)-1); Texts.Scan (S);
	WHILE (CAP(ch) >= 'A') & (CAP(ch) <= 'Z') DO
		Oberon.Par.pos:= Texts.Pos (S);
		(* called command could change Oberon.Par.text, so save and restore it! *)
		p^:= Oberon.Par^; Oberon.Call (S.s, Oberon.Par, FALSE, res); Oberon.Par^:= p^;
		IF res # 0 THEN
			Texts.WriteString (w, "Call error: "); Texts.WriteInt (w, res, 0); Texts.WriteLn (w);
			Texts.Append (Oberon.Log, w.buf);
			RETURN
		END;
		Texts.OpenReader (S, Oberon.Par.text, Texts.Pos (S)-1); Texts.Read (S, ch);
		REPEAT
			WHILE ~S.eot & (ch # CHR(13)) DO
				Texts.Read (S, ch)
			END;
			Texts.Read (S, ch)
		UNTIL S.eot OR ((CAP(ch) >= 'A') & (CAP(ch) <= 'Z')) OR (ch= '~' );
		Texts.OpenScanner (S, Oberon.Par.text, Texts.Pos (S)-1); Texts.Scan (S)
	END
END Start;

PROCEDURE Pause*;
	VAR n, t, t0: LONGINT;
BEGIN
	In.Open; In.LongInt(n); t0 := Oberon.Time();
	IF ~In.Done THEN n := 0 END;
	REPEAT
		t := Oberon.Time()
	UNTIL (t - t0) * 1000 DIV Input.TimeUnit > n
END Pause;

PROCEDURE Repeat*;
	VAR name: ARRAY 32 OF CHAR; t: Texts.Text; s: Texts.Scanner; res, line: INTEGER; eot: BOOLEAN;
BEGIN
	In.Open; In.Name(name);
	IF In.Done THEN
		NEW(t); Texts.Open(t, name);
		WHILE Input.Available() = 0 DO
			Texts.OpenScanner(s, t, 0); Texts.Scan(s);
			WHILE (s.class = Texts.Name) & (Input.Available() = 0) DO
				line := s.line; Oberon.Par.text := t; Oberon.Par.pos := Texts.Pos(s);
				Oberon.Call(s.s, Oberon.Par, FALSE, res);
				REPEAT eot := s.eot; Texts.Scan(s) UNTIL (s.line # line) OR eot
			END
		END
	END
END Repeat;

BEGIN
	Texts.OpenWriter (w)
END Batch.Start
System.ShowCommands System ~
Browser.ShowDef TextFrames ~
System.Directory *.Mod
Browser.ShowDef TextFrames ~
~